//
// "00-TimeSync_v101.mq4" -- Synchronize time positions of charts in separate windows
//
//    Ver. 1.00  2009/02/15(Sun)  initial version
//    Ver. 1.01  2009/02/17(Tue)  bugfixed: focus is gone after scrolling
// "00-TimeSync_v101_ModByFai.mq4"
//    Ver. 1.01  2009/11/17(Tue)  modified: disabled string sSymbols, added US_Keyboard mode.
//
//
#property  copyright "00"
#property  link      "http://www.mql4.com/"

#include <winuser32.mqh>

#import "user32.dll"
int GetForegroundWindow();
int PeekMessageA(int msg[64], int, int, int, int);
int GetMessageA(int msg[64], int, int, int);
int TranslateMessage(int msg[64]);
int DispatchMessageA(int msg[64]);
int GetParent(int hWnd);
#import

//---- defines
#define VK_BACK        0x08
#define VK_RETURN      0x0D
#define VK_DELETE      0x2E
#define VK_OEM_1       0xBA
#define VK_OEM_PERIOD  0xBE
#define VK_SHIFT       0x10
#define N_MAX_WINDOW   512

//---- indicator settings
#property  indicator_chart_window

#property  indicator_buffers  0

//---- indicator parameters
extern bool US_Keyboard = false;
//---- indicator buffers

//---- vars
string sIndicatorName;
string sIndSelf  = "00-TimeSync_v101";


//----------------------------------------------------------------------
string TimeFrameToStr(int timeFrame)
{
    switch (timeFrame) {
    case 1:     return("M1");
    case 5:     return("M5");
    case 15:    return("M15");
    case 30:    return("M30");
    case 60:    return("H1");
    case 240:   return("H4");
    case 1440:  return("D1");
    case 10080: return("W1");
    case 43200: return("MN");
    }
    
    return("??");
}

//----------------------------------------------------------------------
void init()
{
   if (!IsDllsAllowed()) {
      Alert("ERROR: [Allow DLL imports] NOT Checked.");return;
   }
   string tf = TimeFrameToStr(Period());
   sIndicatorName = sIndSelf + "(" + tf + ")";

   IndicatorShortName(sIndicatorName);
}

//----------------------------------------------------------------------
void start()
{
   int activeWindow = GetActiveWindow();
   int foregroundWindow = GetForegroundWindow();

   if (activeWindow != foregroundWindow) {
      // not active
      return;
   }

   if (GetFocus() != WindowHandle(Symbol(), Period())) {
      // focus on other windows
      return;
   }

   int ibar = WindowFirstVisibleBar();
   string sTime = TimeToStr(Time[ibar],TIME_DATE|TIME_MINUTES);

   int hWnd = GetParent(WindowHandle(Symbol(),Period()));
   for(int i=1;i<N_MAX_WINDOW;i++){
      hWnd = GetWindow(hWnd,2);
      if(hWnd==0) break;

      SetFocus(hWnd);
      SendKey(VK_RETURN);
      for(int k=0;k<20;k++){  // StringLen("2009.02.15 13:10")
         SendKey(VK_BACK);
         SendKey(VK_DELETE);
      }
      int nChar=StringLen(sTime);
      for(k=0;k<nChar;k++) {
         int key=StringGetChar(sTime,k);
         if(key==':') {
            key=VK_OEM_1;  // keyboard depend
            if(US_Keyboard) {
               SendShiftKey(key);
            }else{
               SendKey(key);
            }
         } else if(key=='.') {
            key=VK_OEM_PERIOD;
            SendKey(key);
         }else{
            SendKey(key);
         }
      }
      SendKey(VK_RETURN);

      // process remaining messages
      int msg[64];
      while(PeekMessageA(msg,NULL,0,0,0)!=0){
         if(!GetMessageA(msg,NULL,0,0)) break;
         TranslateMessage(msg);
         DispatchMessageA(msg);
      }
   }

   // get focus
   hWnd = WindowHandle(Symbol(), Period());
   if (hWnd !=NULL) {
   SetFocus(hWnd);
   }
}
void SendKey(int keycode){
   keybd_event(keycode,0,0,0);
   keybd_event(keycode,0,KEYEVENTF_KEYUP,0);
}
void SendShiftKey(int keycode){
   keybd_event(VK_SHIFT,0,0,0);
   keybd_event(keycode,0,0,0);
   keybd_event(keycode,0,KEYEVENTF_KEYUP,0);
   keybd_event(VK_SHIFT,0,KEYEVENTF_KEYUP,0);
}