//+------------------------------------------------------------------+
//|                                                mysql_wrapper.c++ |
//|                                Copyright  2008, Berkers Trading |
//|                                                http://quotar.com |
//+------------------------------------------------------------------+
#include "stdafx.h"

#define WIN32_LEAN_AND_MEAN  // Exclude rarely-used stuff from Windows headers
#include <windows.h>
#include <stdlib.h>
#include <stdio.h>
#include "mysql.h"

//----
#define MT4_EXPFUNC __declspec(dllexport)

struct MqlStr{
   int               len;
   char             *string;
};
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
BOOL APIENTRY DllMain(HANDLE hModule,DWORD ul_reason_for_call,LPVOID lpReserved)
  {
//----
   switch(ul_reason_for_call)
     {
      case DLL_PROCESS_ATTACH:
      case DLL_THREAD_ATTACH:
      case DLL_THREAD_DETACH:
      case DLL_PROCESS_DETACH:
         break;
     }
//----
   return(TRUE);
  }

MT4_EXPFUNC char* __stdcall MT4_mysql_wrapper_version(){

	return("mysql_wrapper v1.0.2 Copyright  2008, Berkers Trading");
}

MT4_EXPFUNC void __stdcall MT4_mysql_fetch_row(MYSQL_RES* res, MqlStr *row){
	//char buffer [50];
	//sprintf (buffer, "%d ", sizeof(MqlStr));
	//MessageBox(NULL,buffer,"Application Message", MB_OK | MB_ICONINFORMATION);
	
	MYSQL_ROW lrow = mysql_fetch_row(res);

	for (unsigned int i=0; i < mysql_num_fields(res);i++){
  		row[i].string = lrow[i];
		row[i].len = strlen(row[i].string);
	}
}
/*
my_ulonglong STDCALL mysql_num_rows(MYSQL_RES *res);
unsigned int STDCALL mysql_num_fields(MYSQL_RES *res);
my_bool STDCALL mysql_eof(MYSQL_RES *res);
MYSQL_FIELD *STDCALL mysql_fetch_field_direct(MYSQL_RES *res,
					      unsigned int fieldnr);
*/
MT4_EXPFUNC void __stdcall MT4_mysql_fetch_fields_string(MYSQL_RES* res, MqlStr *row, int type){

	MYSQL_FIELD *lrow = mysql_fetch_fields(res);

	for (unsigned int i=0; i < mysql_num_fields(res);i++){
		//MessageBox(NULL,lrow[i].name,"Application Message", MB_OK | MB_ICONINFORMATION);
		switch (type){
			case 0:
  				row[i].string = lrow[i].name;				/* Name of column */
				break;
			case 1:
				row[i].string = lrow[i].org_name;           /* Original column name, if an alias */
				break;
			case 2:
				row[i].string = lrow[i].table;              /* Table of column if column was a field */
				break;
			case 3:
				row[i].string = lrow[i].org_table;          /* Org table name, if table was an alias */
				break;
			case 4:
				row[i].string = lrow[i].db;                 /* Database for table */
				break;
			case 5:
				row[i].string = lrow[i].catalog;			/* Catalog for table */
				break;
			case 6:
				row[i].string = lrow[i].def;				/* Default value (set by mysql_list_fields) */
				break;
		}
		row[i].len = strlen(row[i].string);
	}

}

/*
MYSQL_ROW_OFFSET STDCALL mysql_row_tell(MYSQL_RES *res);
MYSQL_FIELD_OFFSET STDCALL mysql_field_tell(MYSQL_RES *res);

unsigned int STDCALL mysql_field_count(MYSQL *mysql);
my_ulonglong STDCALL mysql_affected_rows(MYSQL *mysql);
my_ulonglong STDCALL mysql_insert_id(MYSQL *mysql);
unsigned int STDCALL mysql_errno(MYSQL *mysql);
const char * STDCALL mysql_error(MYSQL *mysql);
const char *STDCALL mysql_sqlstate(MYSQL *mysql);
unsigned int STDCALL mysql_warning_count(MYSQL *mysql);
const char * STDCALL mysql_info(MYSQL *mysql);
unsigned long STDCALL mysql_thread_id(MYSQL *mysql);
const char * STDCALL mysql_character_set_name(MYSQL *mysql);
int          STDCALL mysql_set_character_set(MYSQL *mysql, const char *csname);*//*

MT4_EXPFUNC MYSQL* __stdcall _mysql_init(void){
	MYSQL *mysql_res = mysql_init(0);
	return(mysql_res);
}


my_bool		STDCALL mysql_ssl_set(MYSQL *mysql, const char *key,
				      const char *cert, const char *ca,
				      const char *capath, const char *cipher);
const char *    STDCALL mysql_get_ssl_cipher(MYSQL *mysql);
my_bool		STDCALL mysql_change_user(MYSQL *mysql, const char *user, 
					  const char *passwd, const char *db); 
*//*
MYSQL *		STDCALL mysql_real_connect(MYSQL *mysql, const char *host,
					   const char *user,
					   const char *passwd,
					   const char *db,
					   unsigned int port,
					   const char *unix_socket,
					   unsigned long clientflag);

int		STDCALL mysql_select_db(MYSQL *mysql, const char *db);
int		STDCALL mysql_query(MYSQL *mysql, const char *q);
int		STDCALL mysql_send_query(MYSQL *mysql, const char *q,
					 unsigned long length);
int		STDCALL mysql_real_query(MYSQL *mysql, const char *q,
					unsigned long length);
MYSQL_RES *     STDCALL mysql_store_result(MYSQL *mysql);
MYSQL_RES *     STDCALL mysql_use_result(MYSQL *mysql);
*/