//+--------------------------------------------------------------------------------------------------------------------------------------------------+
//|                                                                                                                  ZH_Global_Chart_Variable_Lib.mq4|
//|                                                                                                                  Copyright  Zhunko              |
//|04.09.2008 - 10.09.2008                                                                                           MF ZHUNKO vadim@zhunko.ru       |
//+--------------------------------------------------------------------------------------------------------------------------------------------------+
//|        .                                                                      |
//|    ( ),      .                                                 |
//| !!!             62-.                                       |
//+--------------------------------------------------------------------------------------------------------------------------------------------------+
//| 1.       .                                                                       |
//| 2.       .                                                                      |
//| 3.        .                                                              |
//| 4.        .                                                             |
//+---    . ------------------------------------------------------------------------------------------------------------+
//| 5.        .                                                                               |
//| 6.          .                                                              |
//| 7.         .                                                                |
//| 8.       .                                                                              |
//+---    . --------------------------------------------------------------------------------------------------------------+
//| 9.        .                                                                        |
//|10.        .                                                                         |
//|11.           .                                                           |
//|12.         .                                                        |
//|13.            .                                             |
//|14.           .                                                           |
//|15.              .                                   |
//|16.              .                                   |
//+---      ,   . ---------------------------------------------------------------+
//|17.      .                                                                                   |
//|18.     .                                                                                           |
//|19.              .                    |
//|20.       .                                                                        |
//|21.     .                                                                                            |
//|22.      .                                                                                    |
//+--------------------------------------------------------------------------------------------------------------------------------------------------+
#property copyright "Copyright  2008 Zhunko"
#property link      "vadim@zhunko.ru"
#property library
//     . 
// 1.       .=========================================================================
//       .
double GlobalChartVariableGetDouble (string& Name) //    .
 {
  return (StrToDouble (ObjectDescription (Name)));
 }
//====================================================================================================================================================
// 2.       .========================================================================
//       .
string GlobalChartVariableGetStr (string& Name) //    .
 {
  return (ObjectDescription (Name));
 }
//====================================================================================================================================================
// 3.        .================================================================
//        .
//    ,     .
//       TRUE,  FALSE.
bool GlobalChartVariableSetDouble (string& Name,      //    .
                                   double& Value,     //  .
                                   int&    Precision) //      .
 {
  int i;
  //----
  if (Name == "" || Name == "Label")
   {
    Print ("   \"GlobalChartVariableSetDouble()\".    .");
    Comment ("   \"GlobalChartVariableSetDouble()\".\n   .");
    return (false);
   }
  if (StringLen (Name) > 62)
   {
    Print ("   \"GlobalChartVariableSetDouble()\".    .        62 .");
    Comment ("   \"GlobalChartVariableSetDouble()\".\n   .\n       62 .");
    return (false);
   }
  //  .
  if (ObjectCreate (Name, OBJ_LABEL, 0, 0, 0, 0, 0) == true)
   {
    if (ObjectFind ("ListGlobalGraphicVariable_0") == -1) //      ,       .
     {
      ObjectCreate  ("ListGlobalGraphicVariable_0", OBJ_LABEL, 0, 0, 0, 0, 0);
      ObjectSet     ("ListGlobalGraphicVariable_0", OBJPROP_TIMEFRAMES, EMPTY);
      ObjectSetText ("ListGlobalGraphicVariable_0", Name, 10, "Areal", EMPTY);
     }
    else //      ,   .
     {
      for (i = 0; i < 100; i++)                          //   .
       {//       .
        if (ObjectFind ("ListGlobalGraphicVariable_" + i) == -1 || ObjectDescription ("ListGlobalGraphicVariable_" + i) == "" || ObjectDescription ("ListGlobalGraphicVariable_" + i) == "Label")
         {//     ,        . 
          ObjectCreate  ("ListGlobalGraphicVariable_" + i, OBJ_LABEL, 0, 0, 0, 0, 0);
          ObjectSet     ("ListGlobalGraphicVariable_" + i, OBJPROP_TIMEFRAMES, EMPTY);
          ObjectSetText ("ListGlobalGraphicVariable_" + i, Name, 10, "Areal", EMPTY);
          break;                                        //   .
         } 
       }
     }
   }
  ObjectSet (Name, OBJPROP_TIMEFRAMES, EMPTY);
  return (ObjectSetText (Name, DoubleToStr (Value, Precision), 10, "Areal", EMPTY));
 }
//====================================================================================================================================================
// 4.        .===============================================================
//        .
//    ,     .
//       TRUE,  FALSE.
bool GlobalChartVariableSetStr (string& Name,  //    .
                                string& Value) //  .
 {
  int i;
  //----
  if (Name == "" || Name == "Label")
   {
    Print ("   \"GlobalChartVariableSetStr()\".    .");
    Comment ("   \"GlobalChartVariableSetStr()\".\n   .");
    return (false);
   }
  if (StringLen (Name) > 62)
   {
    Print ("   \"GlobalChartVariableSetStr()\".    .        62 .");
    Comment ("   \"GlobalChartVariableSetStr()\".\n   .\n       62 .");
    return (false);
   }
  //  .
  if (ObjectCreate (Name, OBJ_LABEL, 0, 0, 0, 0, 0) == true)
   {
    if (ObjectFind ("ListGlobalGraphicVariable_0") == -1) //      ,       .
     {
      ObjectCreate  ("ListGlobalGraphicVariable_0", OBJ_LABEL, 0, 0, 0, 0, 0);
      ObjectSet     ("ListGlobalGraphicVariable_0", OBJPROP_TIMEFRAMES, EMPTY);
      ObjectSetText ("ListGlobalGraphicVariable_0", Name, 10, "Areal", EMPTY);
     }
    else //      ,   .
     {
      for (i = 0; i < 100; i++)                          //   .
       {//       .
        if (ObjectFind ("ListGlobalGraphicVariable_" + i) == -1 || ObjectDescription ("ListGlobalGraphicVariable_" + i) == "" || ObjectDescription ("ListGlobalGraphicVariable_" + i) == "Label")
         {//     ,        . 
          ObjectCreate  ("ListGlobalGraphicVariable_" + i, OBJ_LABEL, 0, 0, 0, 0, 0);
          ObjectSet     ("ListGlobalGraphicVariable_" + i, OBJPROP_TIMEFRAMES, EMPTY);
          ObjectSetText ("ListGlobalGraphicVariable_" + i, Name, 10, "Areal", EMPTY);
          break;                                        //   .
         } 
       }
     }
   }
  ObjectSet    (Name, OBJPROP_TIMEFRAMES, EMPTY);
  return (ObjectSetText (Name, Value, 10, "Areal", EMPTY));
 }
//====================================================================================================================================================
//    . 
// 5.        .=================================================================================
//     ,    .       .
//    "Precision".       TRUE,  FALSE.
bool ChartArraySet (string& Name,      //   .
                    double& Value,     //       .
                    int&    Precision, //      .
                    int&    Size0,     //    .
                    int&    Size1,     //    .
                    int&    Cell0,     //    .
                    int&    Cell1)     //    .
 {
  int    i, j, k;
  int    EndStr1;         //       .
  int    Length;          //   .
  int    StartStr2;       //       .
  string Text = "";       //    . .
  string TextSymbol = ""; //  .
  //----
  if (Name == "" || Name == "Label")
   {
    Print ("   \"ChartArraySet()\".    .");
    Comment ("   \"ChartArraySet()\".\n   .");
    return (false);
   }
  if (StringLen (Name) > 62)
   {
    Print ("   \"ChartArraySet()\".    .        62 .");
    Comment ("   \"ChartArraySet()\".\n   .\n       62 .");
    return (false);
   }
  if ((2 * Size0 * Size1 - 1) > 62)
   {
    Print ("   \"ChartArraySet()\".        62   .");
    Comment ("   \"ChartArraySet()\".\n       62   .");
    return (false);
   }
  if (Cell0 >= Size0)
   {
    Print ("   \"ChartArraySet()\".       .");
    Comment ("   \"ChartArraySet()\".\n      .");
    return (false);
   }
  if (Cell1 >= Size1)
   {
    Print ("   \"ChartArraySet()\".       .");
    Comment ("   \"ChartArraySet()\".\n      .");
    return (false);
   }
  if (ObjectFind (Name) == -1)                           //     ,      .    .
   {
    for (i = 0; i < Size0; i++)                          //   .
     {
      for (j = 0; j < Size1; j++)                        //   .
       {
        k++;                                             //   .
        if (i == Cell0 && j == Cell1) Text = Text + DoubleToStr (Value, Precision); //   ,   .
        else Text = Text + "0";                          //      .
        if (j != (Size1 - 1)) Text = Text + ";";         //    .
        else if (k != Size0 * Size1) Text = Text + "|";  //    .
       }
     }
   }
  else
   {//    ,      .
    Text = "|" + ObjectDescription (Name) + ";";         //  .
    Length = StringLen (Text);                           //  .
    for (i = 0, j = 0, k = 0; i < Length; i++)           //    .
     {
      TextSymbol = StringSubstr (Text, i, 1);            // .
      if (TextSymbol == "|") j++;                        //     .
      if (TextSymbol == ";" || TextSymbol == "|") k++;   //     .
     }
    k--;
    if (j != Size0) //          .
     {
      Print ("   \"ChartArraySet()\".           \"Size0\".");
      Comment ("   \"ChartArraySet()\".\n          \"Size0\".");
      return (false);
     }
    if (k / j != Size1) //          .
     {
      Print ("   \"ChartArraySet()\".           \"Size0\".");
      Comment ("   \"ChartArraySet()\".\n          \"Size1\".");
      return (false);
     }
    //       .
    for (i = 0, k = 0; i < Length; i++)                  //    .
     {
      TextSymbol = StringSubstr (Text, i, 1);            //  .
      if (TextSymbol == ";" || TextSymbol == "|")        //  .
       {
        if (k == (Cell0 * Size1 + Cell1))                //        .
         {
          EndStr1 = i;                                   //         .
          break;                                         //   .
         }
        k++;                                             //  .
       }
     }
    for (i++; i < Length; i++)                           //     .
     {
      TextSymbol = StringSubstr (Text, i, 1);            //  .
      if (TextSymbol == ";" || TextSymbol == "|")        //  .
       {
        StartStr2 = i;                                   //         .
        break;                                           //   .
       }
     }
    //   .
    Text = StringSubstr (Text, 0, EndStr1 + 1) + DoubleToStr (Value, Precision) + StringSubstr (Text, StartStr2, 0);
    Text = StringSubstr (Text, 1, StringLen (Text) - 2); //      .
    if (StringLen (Text) > 62)
     {
      Print ("     \"ChartArraySet()\".        62   .");
      Comment ("     \"ChartArraySet()\".        62   .");
      return (false);
     }
   }
  //  .
  if (ObjectCreate (Name, OBJ_LABEL, 0, 0, 0, 0, 0) == true)
   {
    if (ObjectFind ("ListGlobalGraphicVariable_0") == -1) //      ,       .
     {
      ObjectCreate  ("ListGlobalGraphicVariable_0", OBJ_LABEL, 0, 0, 0, 0, 0);
      ObjectSet     ("ListGlobalGraphicVariable_0", OBJPROP_TIMEFRAMES, EMPTY);
      ObjectSetText ("ListGlobalGraphicVariable_0", Name, 10, "Areal", EMPTY);
     }
    else //      ,   .
     {
      for (i = 0; i < 100; i++)                           //   .
       {//       .
        if (ObjectFind ("ListGlobalGraphicVariable_" + i) == -1 || ObjectDescription ("ListGlobalGraphicVariable_" + i) == "" || ObjectDescription ("ListGlobalGraphicVariable_" + i) == "Label")
         {//     ,        . 
          ObjectCreate  ("ListGlobalGraphicVariable_" + i, OBJ_LABEL, 0, 0, 0, 0, 0);
          ObjectSet     ("ListGlobalGraphicVariable_" + i, OBJPROP_TIMEFRAMES, EMPTY);
          ObjectSetText ("ListGlobalGraphicVariable_" + i, Name, 10, "Areal", EMPTY);
          break;                                          //   .
         } 
       }
     }
   }
  ObjectSet (Name, OBJPROP_TIMEFRAMES, EMPTY);
  return (ObjectSetText (Name, Text, 10, "Areal", EMPTY));
 }
//====================================================================================================================================================
// 6.          .================================================================
//       "-1"   .   ,   "Cell0"    .
double ChartArrayGet (string& Name,  //   .
                      int&    Cell0, //    .
                      int&    Cell1) //    .
 {
  int    i, j, k;
  int    Length;          //   .
  int    LengthNumber;    //   .
  int    Start;           //     .
  string Text = "|" + ObjectDescription (Name) + ";";
  string TextSymbol = ""; //  .
  //----
  Length = StringLen (Text);
  for (i = 0; i < Length; i++)
   {
    TextSymbol = StringSubstr (Text, i, 1);                 //  .
    if (TextSymbol == "|")                                  //          .
     {
      if (j == Cell0)                                       //          .
       {
        for (; i < Length; i++)                             //    .
         {
          TextSymbol = StringSubstr (Text, i, 1);           //  .
          if (TextSymbol == ";")                            //       .
           {
            if (k == Cell1)                                 //          .
             {
              LengthNumber = i;                             //    .  ";"    .
              for (i--; i >= 0; i--)                        //          .
               {
                TextSymbol = StringSubstr (Text, i, 1);     //  .
                if (TextSymbol == ";" || TextSymbol == "|") //      .
                 {
                  Start = i + 1;
                  LengthNumber = LengthNumber - Start;
                  break;
                 }
               }
              return (StrToDouble (StringSubstr (Text, Start, LengthNumber)));
             }
            k++;
           }
         }
       }
      j++;
     }
   }
  return (-1);
 }
//====================================================================================================================================================
// 7.         .==================================================================
//        ,    "-1".
int ChartArrayRange (string& Name,       //   .
                     int&    RangeIndex) //  .
 {
  int    i, j, k;                                     //       .
  int    Length;                                      //   .
  string Text = "|" + ObjectDescription (Name) + ";"; //    . .
  string TextSymbol = "";                             //  .
  //----
  Length = StringLen (Text);                          //  .
  for (i = 0, j = 0, k = 0; i < Length; i++)          //    .
   {
    TextSymbol = StringSubstr (Text, i, 1);           // .
    if (TextSymbol == "|") j++;                       //     .
    if (TextSymbol == ";" || TextSymbol == "|") k++;  //       .
   }
  if (RangeIndex == 0) return (j);                    //      .
  if (RangeIndex == 1) return ((k - 1) / j);          //      .
  return (-1);
 }
//====================================================================================================================================================
// 8.       .================================================================================
//        ,      ,
//     -1,     .
int ChartArrayResize (string& Name,       //   .
                      int&    RangeIndex, //  .
                      int&    NewSize)    //  .
 {
  int    i, j, k, l;                                  //       .
  int    Length;                                      //   .
  int    Size0;                                       //   .
  int    Size1;                                       //   .
  string StringSize1 = "";                            //    .
  string Text = "|" + ObjectDescription (Name) + ";"; //    . .   .
  string TextSymbol = "";                             //  .
  // .
  string ArraySize0[];                                //      .
  //----  .------------------------------------------------------------------------------------------------------------------
  if (RangeIndex < 0 || 1 < RangeIndex)               //   " ".
   {
    Print ("   \"ChartArrayResize()\".       . RangeIndex = ", RangeIndex);
    Comment ("   \"ChartArrayResize()\".\n      .\nRangeIndex = ", RangeIndex);
    return (-1);
   }
  if (NewSize < 0)                                    //   " ".
   {
    Print ("   \"ChartArrayResize()\".       . NewSize = ", NewSize);
    Comment ("   \"ChartArrayResize()\".\n      .\nNewSize = ", NewSize);
    return (-1);
   }
  //    .
  Length = StringLen (Text);                          //  .
  for (i = 0, j = 0, k = 0; i < Length; i++)          //    .
   {
    TextSymbol = StringSubstr (Text, i, 1);           // .
    if (TextSymbol == "|") j++;                       //     .
    if (TextSymbol == ";" || TextSymbol == "|") k++;  //       .
   }
  Size0 = j;                                          //   .
  Size1 = (k - 1) / j;                                //   .
  //----    .-----------------------------------------------------------------------------------------------------
  if (RangeIndex == 0)
   {
    if (NewSize < Size0)                              //    ,  .
     {
      for (i = 0, j = -1; i < Length; i++)            //    .
       {
        TextSymbol = StringSubstr (Text, i, 1);       // .
        if (TextSymbol == "|") j++;                   //     .  .
        //       .      .    .
        if (j == NewSize) if (ObjectSetText (Name, StringSubstr (Text, 1, i - 1), 10, "Areal", EMPTY) == true) return (j * Size1);
       }
     }
    if (NewSize == Size0) return (k - 1);             //     .
    if (NewSize > Size0)                              //    ,  .
     {
      StringSize1 = "|";                              //      .
      for (i = 0; i < Size1; i++)                     //        .
       {
        if (i == (Size1 - 1)) StringSize1 = StringSize1 + "0"; //      .
        else StringSize1 = StringSize1 + "0;";
       }
      Text = ObjectDescription (Name);
      for (i = 0; i < (NewSize - Size0); i++) Text = Text + StringSize1;
      //        .
      if (StringLen (Text) > 62)
       {
        Print ("   \"ChartArrayResize()\".        62   .");
        Comment ("   \"ChartArrayResize()\".\n       62   .");
        return (-1);
       }
      if (ObjectSetText (Name, Text, 10, "Areal", EMPTY) == true) return ((Size0 + i) * Size1); //    .
     }
   }
  //----    .-----------------------------------------------------------------------------------------------------
  if (RangeIndex == 1)
   {
    if (NewSize < Size1)                                              //    ,  .
     {
      ArrayResize (ArraySize0, Size0);                                //           .
      for (i = 0; i < Size0; i++) ArraySize0[i] = "";                 //     .
      for (i = 0, j = -1, l = 0; i < Length; i++)                     //    .
       {
        TextSymbol = StringSubstr (Text, i, 1);                       // .
        if (TextSymbol == "|")                                        //     . 
         {
          j++;                                                        //    .
          k = 0;                                                      //     .
         }
        if (TextSymbol == ";" || TextSymbol == "|")                   //       .
         {
          k++;                                                        //    .
          if (k <= NewSize) l++;                                      //    .
         }
        if (k <= NewSize) ArraySize0[j] = ArraySize0[j] + TextSymbol; //          .
       }
      //              .
      for (i = 1; i < Size0; i++) ArraySize0[0] = ArraySize0[0] + ArraySize0[i];
      //    .   .    .
      if (ObjectSetText (Name, StringSubstr (ArraySize0[0], 1, 0), 10, "Areal", EMPTY) == true) return (l);
     }
    if (NewSize == Size1) return (k - 1);                             //     .
    if (NewSize > Size1)                                              //    ,  .
     {
      ArrayResize (ArraySize0, Size0);                                //           .
      for (i = 0; i < Size0; i++) ArraySize0[i] = "";                 //     .
      Text = "|" + ObjectDescription (Name);                          //    . .   .
      Length = StringLen (Text);                                      //  .
      for (i = 0, j = -1, k = 0; i < Length; i++)                     //    .
       {
        TextSymbol = StringSubstr (Text, i, 1);                       // .
        if (TextSymbol == "|") j++;                                   //     .     .
        if (TextSymbol == ";" || TextSymbol == "|") k++;              //       .
        ArraySize0[j] = ArraySize0[j] + TextSymbol;                   //          .
       }
      StringSize1 = ";";                                              //      .
      for (i = 0, l = 0; i < (NewSize - Size1); i++, l++)             //       .
       {
        if (i == (NewSize - Size1 - 1)) StringSize1 = StringSize1 + "0"; //      .
        else StringSize1 = StringSize1 + "0;";
       }
      //       .
      for (i = 0; i < Size0; i++) ArraySize0[i] = ArraySize0[i] + StringSize1;
      //              .
      for (i = 1; i < Size0; i++) ArraySize0[0] = ArraySize0[0] + ArraySize0[i];
      //    .
      Text = StringSubstr (ArraySize0[0], 1, 0);
      if (StringLen (Text) > 62)
       {
        Print ("   \"ChartArrayResize()\".        62   .");
        Comment ("   \"ChartArrayResize()\".\n       62   .");
        return (-1);
       }
      //   .    .
      if (ObjectSetText (Name, Text, 10, "Areal", EMPTY) == true) return (k + l * Size0);
     }
   }
  return (-1);
 }
//====================================================================================================================================================
//    . 
// 9.        .==========================================================================
//      ,    .
//         .    "-1".
int FileChartWriteArray1Int (string& Name,    //   .
                             int&    Array[], //   .
                             int&    Start,   //     (   ).
                             int&    Count)   //   .
 {
  int i;
  int Length;
  string Text = "";
  //   .
  if (Name == "" || Name == "Label") //  .
   {
    Print ("   \"FileChartWriteArray1Int()\".    .");
    Comment ("   \"FileChartWriteArray1Int()\".\n   .");
    return (-1);
   }
  if (StringLen (Name) > 62) //   .
   {
    Print ("   \"FileChartWriteArray1Int()\".     .        62 .");
    Comment ("   \"FileChartWriteArray1Int()\".\n    .\n       62 .");
    return (-1);
   }
  //    .
  for (i = Start; i < (Start + Count); i++)
   {
    Text = Text + DoubleToStr (Array[i], 0) + ";";
    Length = StringLen (Text) - 1;
    if (Length > 62)
     {
      Print ("   \"FileChartWriteArray1Int()\".        62   .");
      Comment ("   \"FileChartWriteArray1Int()\".        62   .");
      return (-1);
     }
   }
  Text = StringSubstr (Text, 0, Length);
  //  .
  if (ObjectCreate (Name, OBJ_LABEL, 0, 0, 0, 0, 0) == true)
   {
    if (ObjectFind ("ListGlobalGraphicVariable_0") == -1) //      ,       .
     {
      ObjectCreate  ("ListGlobalGraphicVariable_0", OBJ_LABEL, 0, 0, 0, 0, 0);
      ObjectSet     ("ListGlobalGraphicVariable_0", OBJPROP_TIMEFRAMES, EMPTY);
      ObjectSetText ("ListGlobalGraphicVariable_0", Name, 10, "Areal", EMPTY);
     }
    else //      ,   .
     {
      for (i = 0; i < 100; i++)                          //   .
       {//       .
        if (ObjectFind ("ListGlobalGraphicVariable_" + i) == -1 || ObjectDescription ("ListGlobalGraphicVariable_" + i) == "" || ObjectDescription ("ListGlobalGraphicVariable_" + i) == "Label")
         {//     ,        . 
          ObjectCreate  ("ListGlobalGraphicVariable_" + i, OBJ_LABEL, 0, 0, 0, 0, 0);
          ObjectSet     ("ListGlobalGraphicVariable_" + i, OBJPROP_TIMEFRAMES, EMPTY);
          ObjectSetText ("ListGlobalGraphicVariable_" + i, Name, 10, "Areal", EMPTY);
          break;                                        //   .
         } 
       }
     }
   }
  ObjectSet (Name, OBJPROP_TIMEFRAMES, EMPTY);
  if (ObjectSetText (Name, Text, 10, "Areal", EMPTY) == true) return (Length);
  return (-1);
 }
//====================================================================================================================================================
//10.        .===========================================================================
//      ,    .
//         .    "-1".
int FileChartWriteArray2Int (string& Name,      //   .
                             int&    Array[][]) //   .
 {
  int    Size0 = ArrayRange (Array, 0);
  int    Size1 = ArrayRange (Array, 1);
  int    i, j;
  int    Length;
  string Text = "";
  //   .
  if (Name == "" || Name == "Label") //  .
   {
    Print ("   \"FileChartWriteArray2Int()\".    .");
    Comment ("   \"FileChartWriteArray2Int()\".\n   .");
    return (-1);
   }
  if (StringLen (Name) > 62) //   .
   {
    Print ("   \"FileChartWriteArray2Int()\".    .        62 .");
    Comment ("   \"FileChartWriteArray2Int()\".\n   .\n       62 .");
    return (-1);
   }
  //    .
  for (i = 0; i < Size0; i++)
   {
    for (j = 0; j < Size1; j++)
     {
      if (j == (Size1 - 1)) Text = Text + DoubleToStr (Array[i][j], 0) + "|";
      else Text = Text + DoubleToStr (Array[i][j], 0) + ";";
      Length = StringLen (Text) - 1;
      if (Length > 62)
       {
        Print ("   \"FileChartWriteArray2Int()\".        62   .");
        Comment ("   \"FileChartWriteArray2Int()\".        62   .");
        return (-1);
       }
     }
   }
  Text = StringSubstr (Text, 0, Length);
  //  .
  if (ObjectCreate (Name, OBJ_LABEL, 0, 0, 0, 0, 0) == true)
   {
    if (ObjectFind ("ListGlobalGraphicVariable_0") == -1) //      ,       .
     {
      ObjectCreate  ("ListGlobalGraphicVariable_0", OBJ_LABEL, 0, 0, 0, 0, 0);
      ObjectSet     ("ListGlobalGraphicVariable_0", OBJPROP_TIMEFRAMES, EMPTY);
      ObjectSetText ("ListGlobalGraphicVariable_0", Name, 10, "Areal", EMPTY);
     }
    else //      ,   .
     {
      for (i = 0; i < 100; i++)                          //   .
       {//       .
        if (ObjectFind ("ListGlobalGraphicVariable_" + i) == -1 || ObjectDescription ("ListGlobalGraphicVariable_" + i) == "" || ObjectDescription ("ListGlobalGraphicVariable_" + i) == "Label")
         {//     ,        . 
          ObjectCreate  ("ListGlobalGraphicVariable_" + i, OBJ_LABEL, 0, 0, 0, 0, 0);
          ObjectSet     ("ListGlobalGraphicVariable_" + i, OBJPROP_TIMEFRAMES, EMPTY);
          ObjectSetText ("ListGlobalGraphicVariable_" + i, Name, 10, "Areal", EMPTY);
          break;                                        //   .
         } 
       }
     }
   }
  ObjectSet (Name, OBJPROP_TIMEFRAMES, EMPTY);
  if (ObjectSetText (Name, Text, 10, "Areal", EMPTY) == true) return (Length);
  return (-1);
 }
//====================================================================================================================================================
//11.           .=============================================================
//      ,      .
//         .    "-1".
int FileChartWriteArray1Double (string& Name,      //   .
                                double& Array[],   //   .
                                int&    Precision, //      .
                                int&    Start,     //     (   ).
                                int&    Count)     //   .
 {
  int i;
  int Length;
  string Text = "";
  //   .
  if (Name == "" || Name == "Label") //  .
   {
    Print ("   \"FileChartWriteArray1Double()\".    .");
    Comment ("   \"FileChartWriteArray1Double()\".\n   .");
    return (-1);
   }
  if (StringLen (Name) > 62) //   .
   {
    Print ("   \"FileChartWriteArray1Double()\".    .        62 .");
    Comment ("   \"FileChartWriteArray1Double()\".\n   .\n       62 .");
    return (-1);
   }
  //    .
  for (i = Start; i < (Start + Count); i++)
   {
    Text = Text + DoubleToStr (Array[i], Precision) + ";";
    Length = StringLen (Text) - 1;
    if (Length > 62)
     {
      Print ("   \"FileChartWriteArray1Double()\".        62   .");
      Comment ("   \"FileChartWriteArray1Double()\".        62   .");
      return (-1);
     }
   }
  Text = StringSubstr (Text, 0, Length);
  //  .
  if (ObjectCreate (Name, OBJ_LABEL, 0, 0, 0, 0, 0) == true)
   {
    if (ObjectFind ("ListGlobalGraphicVariable_0") == -1) //      ,       .
     {
      ObjectCreate  ("ListGlobalGraphicVariable_0", OBJ_LABEL, 0, 0, 0, 0, 0);
      ObjectSet     ("ListGlobalGraphicVariable_0", OBJPROP_TIMEFRAMES, EMPTY);
      ObjectSetText ("ListGlobalGraphicVariable_0", Name, 10, "Areal", EMPTY);
     }
    else //      ,   .
     {
      for (i = 0; i < 100; i++)                          //   .
       {//       .
        if (ObjectFind ("ListGlobalGraphicVariable_" + i) == -1 || ObjectDescription ("ListGlobalGraphicVariable_" + i) == "" || ObjectDescription ("ListGlobalGraphicVariable_" + i) == "Label")
         {//     ,        . 
          ObjectCreate  ("ListGlobalGraphicVariable_" + i, OBJ_LABEL, 0, 0, 0, 0, 0);
          ObjectSet     ("ListGlobalGraphicVariable_" + i, OBJPROP_TIMEFRAMES, EMPTY);
          ObjectSetText ("ListGlobalGraphicVariable_" + i, Name, 10, "Areal", EMPTY);
          break;                                        //   .
         } 
       }
     }
   }
  ObjectSet (Name, OBJPROP_TIMEFRAMES, EMPTY);
  if (ObjectSetText (Name, Text, 10, "Areal", EMPTY) == true) return (Length);
  return (-1);
 }
//====================================================================================================================================================
//12.         .==========================================================
//       .
//      ,      .
//         .    "-1".
int FileChartWriteArray2Double (string& Name,      //   .
                                double& Array[][], //   .
                                int&    Precision) //      .
 {
  int    Size0 = ArrayRange (Array, 0);
  int    Size1 = ArrayRange (Array, 1);
  int    i, j;
  int    Length;
  string Text = "";
  //   .
  if (Name == "" || Name == "Label") //  .
   {
    Print ("   \"FileChartWriteArray2Double()\".    .");
    Comment ("   \"FileChartWriteArray2Double()\".\n   .");
    return (-1);
   }
  if (StringLen (Name) > 62) //   .
   {
    Print ("   \"FileChartWriteArray2Double()\".    .        62 .");
    Comment ("   \"FileChartWriteArray2Double()\".\n   .\n       62 .");
    return (-1);
   }
  //    .
  for (i = 0; i < Size0; i++)
   {
    for (j = 0; j < Size1; j++)
     {
      if (j == (Size1 - 1)) Text = Text + DoubleToStr (Array[i][j], Precision) + "|";
      else Text = Text + DoubleToStr (Array[i][j], Precision) + ";";
      Length = StringLen (Text) - 1;
      if (Length > 62)
       {
        Print ("   \"FileChartWriteArray2Double()\".        62   .");
        Comment ("   \"FileChartWriteArray2Double()\".        62   .");
        return (-1);
       }
     }
   }
  Text = StringSubstr (Text, 0, Length);
  //  .
  if (ObjectCreate (Name, OBJ_LABEL, 0, 0, 0, 0, 0) == true)
   {
    if (ObjectFind ("ListGlobalGraphicVariable_0") == -1) //      ,       .
     {
      ObjectCreate  ("ListGlobalGraphicVariable_0", OBJ_LABEL, 0, 0, 0, 0, 0);
      ObjectSet     ("ListGlobalGraphicVariable_0", OBJPROP_TIMEFRAMES, EMPTY);
      ObjectSetText ("ListGlobalGraphicVariable_0", Name, 10, "Areal", EMPTY);
     }
    else //      ,   .
     {
      for (i = 0; i < 100; i++)                          //   .
       {//       .
        if (ObjectFind ("ListGlobalGraphicVariable_" + i) == -1 || ObjectDescription ("ListGlobalGraphicVariable_" + i) == "" || ObjectDescription ("ListGlobalGraphicVariable_" + i) == "Label")
         {//     ,        . 
          ObjectCreate  ("ListGlobalGraphicVariable_" + i, OBJ_LABEL, 0, 0, 0, 0, 0);
          ObjectSet     ("ListGlobalGraphicVariable_" + i, OBJPROP_TIMEFRAMES, EMPTY);
          ObjectSetText ("ListGlobalGraphicVariable_" + i, Name, 10, "Areal", EMPTY);
          break;                                        //   .
         } 
       }
     }
   }
  ObjectSet (Name, OBJPROP_TIMEFRAMES, EMPTY);
  if (ObjectSetText (Name, Text, 10, "Areal", EMPTY) == true) return (Length);
  return (-1);
 }
//====================================================================================================================================================
//13.            .===============================================
//        .
//      .
int FileChartReadArray1Int (string& Name,    //   .
                            int&    Array[], // ,    .
                            int&    Start,   //      .
                            int&    Count)   //    .
 {
  int    i;
  int    j = 0;
  int    Length;
  string Text = ObjectDescription (Name) + ";";
  string TextNumber = ""; //     .
  string TextSymbol = ""; //  .
  //----
  Length = StringLen (Text);
  for (i = 0; i < Length; i++)
   {
    TextSymbol = StringSubstr (Text, i, 1);
    if (TextSymbol == ";")
     {
      if (Count == j) break;
      Array[Start + j] = StrToInteger (TextNumber);
      TextNumber = ""; //  .
      TextSymbol = ""; //  .
      j++;
     }
    else TextNumber = TextNumber + TextSymbol;
   }
  return (j);
 }
//====================================================================================================================================================
//14.           .=============================================================
//           .
//      "|",   ,        .
//   ,   ,    .    .
//      .
int FileChartReadArray2Int (string& Name,       //   .
                            int&    Array[][])  // ,    .
 {
  int    Size0 = ArrayRange (Array, 0);         //   .
  int    Size1 = ArrayRange (Array, 1);         //   .
  int    i;                                     //    .
  int    j = 0;                                 //    .
  int    k = 0;                                 //    .
  int    AmountElement = 0;                     //  .
  int    Length;                                //  .
  string Text = ObjectDescription (Name) + ";"; //  .
  string TextNumber = "";                       //     .
  string TextSymbol = "";                       //  .
  //----
  Length = StringLen (Text);                    //   .
  for (i = 0; i < Length; i++)                  //     .
   {
    TextSymbol = StringSubstr (Text, i, 1);     //  .
    if (TextSymbol == ";" || TextSymbol == "|" || k == Size1) //   .
     {
      Array[j][k] = StrToInteger (TextNumber);  //     .
      k++;                                      //      .
      if (TextSymbol == "|" || k == Size1)      //             .
       {
        j++;                                    //      .
        k = 0;                                  //     .
       }
      AmountElement++;                          //   .
      if (j >= Size0) break;                    //   ,         .
      TextNumber = "";                          //  .
      TextSymbol = "";                          //  .
     }
    else TextNumber = TextNumber + TextSymbol;  //  .
   }
  return (AmountElement);
 }
//====================================================================================================================================================
//15.              .=====================================
//        .
//      .
int FileChartReadArray1Double (string& Name,    //   .
                               double& Array[], // ,    .
                               int&    Start,   //      .
                               int&    Count)   //    .
 {
  int    i;
  int    j = 0;
  int    Length;
  string Text = ObjectDescription (Name) + ";";
  string TextNumber = ""; //     .
  string TextSymbol = ""; //  .
  //----
  Length = StringLen (Text);
  for (i = 0; i < Length; i++)
   {
    TextSymbol = StringSubstr (Text, i, 1);
    if (TextSymbol == ";")
     {
      if (Count == j) break;
      Array[Start + j] = StrToInteger (TextNumber);
      TextNumber = ""; //  .
      TextSymbol = ""; //  .
      j++;
     }
    else TextNumber = TextNumber + TextSymbol;
   }
  return (j);
 }
//====================================================================================================================================================
//16.              .=====================================
//           .
//      "|",   ,       .
//   ,   ,    .    .
//      .
int FileChartReadArray2double (string& Name,      //   .
                               double& Array[][]) // ,    .
 {
  int    Size0 = ArrayRange (Array, 0);         //   .
  int    Size1 = ArrayRange (Array, 1);         //   .
  int    i;                                     //    .
  int    j = 0;                                 //    .
  int    k = 0;                                 //    .
  int    AmountElement = 0;                     //  .
  int    Length;                                //  .
  string Text = ObjectDescription (Name) + ";"; //  .
  string TextNumber = "";                       //     .
  string TextSymbol = "";                       //  .
  //----
  Length = StringLen (Text);
  for (i = 0; i < Length; i++)
   {
    TextSymbol = StringSubstr (Text, i, 1);
    if (TextSymbol == ";" || TextSymbol == "|" || k == Size1)
     {
      Array[j][k] = StrToInteger (TextNumber);
      k++;
      if (TextSymbol == "|" || Size1 == k)
       {
        j++;
        k = 0;
       }
      AmountElement++;
      if (j >= Size0) break;
      TextNumber = ""; //  .
      TextSymbol = ""; //  .
     }
    else TextNumber = TextNumber + TextSymbol;
   }
  return (AmountElement);
 }
//====================================================================================================================================================
//      ,   . 
//17.      .=====================================================================================
//   TRUE,     ,   FALSE.
bool GlobalChartVariableCheck (string& Name) //    .
 {
  if (ObjectFind (Name) == -1) return (false);
  else return (true);
 }
//====================================================================================================================================================
//18.     .=============================================================================================
//       .
//      TRUE,  FALSE.
bool GlobalChartVariableDel (string& Name) //    .
 {
  int i;
  //----
  for (i = 0; i < 100; i++) //    .
   {//    .
    if (ObjectDescription ("ListGlobalGraphicVariable_" + i) == Name)
     {
      for (; i < 100; i++)  //      . .
       {
        if (ObjectFind ("ListGlobalGraphicVariable_" + i) == -1 || ObjectDescription ("ListGlobalGraphicVariable_" + i) == "")
         {//        .
          for (; ObjectDescription ("ListGlobalGraphicVariable_" + i) == "" || ObjectDescription ("ListGlobalGraphicVariable_" + i) == "Label"; i--) ObjectDelete ("ListGlobalGraphicVariable_" + i);
          //   ,     ,         .
          return (ObjectDelete (Name));
         }
        //      .
        ObjectSetText ("ListGlobalGraphicVariable_" + i, ObjectDescription (StringConcatenate("ListGlobalGraphicVariable_", i + 1)), 10, "Areal", EMPTY);
       }
     }
   }
  return (ObjectDelete (Name));
 }
//====================================================================================================================================================
//19.              .======================
//         100.    .    99.
//        ,     .
string GlobalChartVariableName (int& Index) //      .      0  ,  GlobalChartVariablesTotal().
 {
  return (ObjectDescription ("ListGlobalGraphicVariable_" + Index));
 }
//====================================================================================================================================================
//20.       .==========================================================================
//     "-1".
int GlobalChartVariablesTotal()
 {
  int    i;
  string Name;
  //----
  for (i = 0; i < 100; i++)
   {
    Name = "ListGlobalGraphicVariable_" + i;
    if (ObjectFind (Name) == -1 || ObjectDescription (Name) == "" || ObjectDescription (Name) == "Label") return (i);
   }
  return (-1);
 }
//====================================================================================================================================================
//21.     .==============================================================================================
//    .      ,      .
//         ,      .
//            "-1".
int GlobalChartVariablesDeleteAll (string& PrefixName) //     .
 {
  int AmountDelete; //     .
  int i, j;
  int Length;       //  .
  //----
  if (PrefixName == "")       //    ,      .
   {
    for (i = 0; i < 100; i++) //      .
     {
      if (ObjectFind ("ListGlobalGraphicVariable_" + i) == -1) return (i); //  ,    .
      ObjectDelete (ObjectDescription ("ListGlobalGraphicVariable_" + i)); //    .
      ObjectDelete ("ListGlobalGraphicVariable_" + i);                     //      .
     }
   }
  else //   ,    .
   {//           .
    Length = StringLen (PrefixName);
    for (i = 0; i < 100; i++) //      .
     {
      if (StringSubstr (ObjectDescription ("ListGlobalGraphicVariable_" + i), 0, Length) == PrefixName)
       {
        AmountDelete++;                                                               //     .
        ObjectDelete (ObjectDescription ("ListGlobalGraphicVariable_" + i));          //    .
        ObjectSetText ("ListGlobalGraphicVariable_" + i, "", 10, "Areal", EMPTY);     //    .
       }
     }
    // .       .
    for (i = 0; i < 100 && ObjectFind ("ListGlobalGraphicVariable_" + j) != -1; i++)  //      .   ,    () .
     {
      if (ObjectDescription ("ListGlobalGraphicVariable_" + i) == "" || ObjectDescription ("ListGlobalGraphicVariable_" + i) == "Label") //    .
       {
        j = i;                                                                        //      .
        //      .   ,    () .
        for (j++; j < 100 && ObjectFind ("ListGlobalGraphicVariable_" + j) != -1; j++)
         {//    .
          if (ObjectDescription ("ListGlobalGraphicVariable_" + j) != "" && ObjectDescription ("ListGlobalGraphicVariable_" + j) != "Label")
           {//      .
            ObjectSetText ("ListGlobalGraphicVariable_" + i, ObjectDescription ("ListGlobalGraphicVariable_" + j), 10, "Areal", EMPTY);
            ObjectSetText ("ListGlobalGraphicVariable_" + j, "", 10, "Areal", EMPTY); //    .
            break;                                                                    //    .
           }
         }
       }
     }
    //        .
    for (; ObjectDescription ("ListGlobalGraphicVariable_" + i) == "" || ObjectDescription ("ListGlobalGraphicVariable_" + i) == "Label"; i--) ObjectDelete ("ListGlobalGraphicVariable_" + i);                     //      .
    return (AmountDelete); //  .
   }
  return (-1);
 }
//====================================================================================================================================================
//22.      .======================================================================================
//  TRUE,    .    - FALSE.
bool RenamingGlobalChartVariable (string& Name1, //    ,   .
                                  string& Name2) //   ,    .
 {
  int i;
  //    ( )   .
  ObjectCreate  (Name2, OBJ_LABEL, 0, 0, 0, 0, 0);
  ObjectSet     (Name2, OBJPROP_TIMEFRAMES, EMPTY);
  ObjectSetText (Name2, ObjectDescription (Name1), 10, "Areal", EMPTY); //     .
  //       .
  for (i = 0; i < 100; i++) //      .
   {
    if (ObjectDescription ("ListGlobalGraphicVariable_" + i) == Name1)
     {
      ObjectSetText ("ListGlobalGraphicVariable_" + i, Name2, 10, "Areal", EMPTY); //    .
      break;
     }
   }
  return (ObjectDelete (Name1)); //        .
 }
//====================================================================================================================================================
//