//+------------------------------------------------------------------+
//|                                            FiboCandlesSignal.mqh |
//|                             Copyright  2011,   Nikolay Kositsin | 
//|                              Khabarovsk,   farria@mail.redcom.ru | 
//+------------------------------------------------------------------+
#property copyright "Copyright  2011, Nikolay Kositsin"
#property link      "farria@mail.redcom.ru"
//+------------------------------------------------------------------+
//| Included files                                                   |
//+------------------------------------------------------------------+
#property tester_indicator "FiboCandles.ex5"
#include <Expert\ExpertSignal.mqh>
//--- wizard description start
//+------------------------------------------------------------------+ 
//|  Declaration of constants                                        |
//+------------------------------------------------------------------+ 
#define OPEN_LONG     80  // The constant for returning the buy command to the Expert Advisor
#define OPEN_SHORT    80  // The constant for returning the sell command to the Expert Advisor
#define CLOSE_LONG    40  // The constant for returning the command to close a long position to the Expert Advisor
#define CLOSE_SHORT   40  // The constant for returning the command to close a short position to the Expert Advisor
#define REVERSE_LONG  100 // The constant for returning the command to reverse a long position to the Expert Advisor
#define REVERSE_SHORT 100 // The constant for returning the command to reverse a short position to the Expert Advisor
#define NO_SIGNAL      0  // The constant for returning the absence of a signal to the Expert Advisor
//+----------------------------------------------------------------------+
//| Description of the class                                             |
//| Title=The signals based on FiboCandles indicator                     |
//| Type=SignalAdvanced                                                  |
//| Name=FiboCandles                                                     |
//| Class=CFiboCandlesSignal                                             |
//| Page=                                                                |
//| Parameter=BuyPosOpen,bool,true,Permission to buy                     |
//| Parameter=SellPosOpen,bool,true,Permission to sell                   |
//| Parameter=BuyPosClose,bool,true,Permission to exit a long position   |
//| Parameter=SellPosClose,bool,true,Permission to exit a short position |
//| Parameter=Ind_Timeframe,ENUM_TIMEFRAMES,PERIOD_H4,Timeframe          |
//| Parameter=period,uint,10,Smoothing period                            |
//| Parameter=fiboLevel,uint,1,Fibo level value (1 - 5)                  |
//| Parameter=SignalBar,uint,1,Bar index for entry signal                |
//+----------------------------------------------------------------------+
//--- wizard description end
//+----------------------------------------------------------------------+
//| CFiboCandlesSignal class.                                            |
//| Purpose: Signals generator class by the indicator values             |
//| FiboCandles http://www.mql5.com/en/code/536/.                        |
//|             Is derived from the CExpertSignal class.                 |
//+----------------------------------------------------------------------+
class CFiboCandlesSignal : public CExpertSignal
  {
protected:
   CiCustom          m_indicator;        // the object for access to FiboCandles values

   //--- adjusted parameters
   bool              m_BuyPosOpen;       // permission to buy
   bool              m_SellPosOpen;      // permission to sell
   bool              m_BuyPosClose;      // permission to exit a long position
   bool              m_SellPosClose;     // permission to exit a short position  
   ENUM_TIMEFRAMES   m_Ind_Timeframe;    // FiboCandles indicator timeframe
   uint              m_period;           // Smoothing period
   uint              m_fiboLevel;        // Fibo level value (1 - 5) 
   uint              m_SignalBar;        // bar index for getting entry signal 
   
public:
                     CFiboCandlesSignal();
   //--- methods of setting adjustable parameters
   void              BuyPosOpen(bool value)                  { m_BuyPosOpen=value;       }
   void              SellPosOpen(bool value)                 { m_SellPosOpen=value;      }
   void              BuyPosClose(bool value)                 { m_BuyPosClose=value;      }
   void              SellPosClose(bool value)                { m_SellPosClose=value;     }
   void              Ind_Timeframe(ENUM_TIMEFRAMES value)    { m_Ind_Timeframe=value;    }
   void              period(uint value)                      { m_period=value;           }
   void              fiboLevel(uint value)                   { m_fiboLevel=value;        }
   void              SignalBar(uint value)                   { m_SignalBar=value;        }

   //--- adjustable parameters validation method
   virtual bool      ValidationSettings();
   //--- adjustable parameters validation method
   virtual bool      InitIndicators(CIndicators *indicators); // indicators initialization
   //--- market entry signals generation method
   virtual int       LongCondition();
   virtual int       ShortCondition();

   bool              InitFiboCandles(CIndicators *indicators);   // FiboCandles indicator initializing method
  };
//+------------------------------------------------------------------+
//| CFiboCandlesSignal constructor.                                  |
//| INPUT:  no.                                                      |
//| OUTPUT: no.                                                      |
//| REMARK: no.                                                      |
//+------------------------------------------------------------------+
void CFiboCandlesSignal::CFiboCandlesSignal()
  {
//--- setting default parameters
   m_BuyPosOpen=true;
   m_SellPosOpen=true;
   m_BuyPosClose=true;
   m_SellPosClose=true;
   m_Ind_Timeframe=PERIOD_H4; 
   m_period=10;
   m_fiboLevel=1; 
   m_SignalBar=1;
   m_used_series=USE_SERIES_OPEN+USE_SERIES_HIGH+USE_SERIES_LOW+USE_SERIES_CLOSE;
  }
//+------------------------------------------------------------------+
//| Checking adjustable parameters.                                  |
//| INPUT:  no.                                                      |
//| OUTPUT: true if the settings are valid, false - if not.          |
//| REMARK: no.                                                      |
//+------------------------------------------------------------------+
bool CFiboCandlesSignal::ValidationSettings()
  {
//--- checking parameters
   if(m_period<=0)
     {
      printf(__FUNCTION__+": Smoothing period must be greater than zero!");
      printf(__FUNCTION__+": Default value equal to 1 will be used!");
      m_period=1;
     }
     
   if(m_fiboLevel<1)
     {
      printf(__FUNCTION__+": Fibo value parameter cannot be less than 1!");
      printf(__FUNCTION__+": Default value equal to 1 will be used!");
      m_fiboLevel=1;
     }

   if(m_fiboLevel>5)
     {
      printf(__FUNCTION__+": Fibo level value parameter cannot be more than 5!");
      printf(__FUNCTION__+": Default value equal to 5 will be used!");
      m_fiboLevel=5;
     }

//--- successful completion
   return(true);
  }
//+------------------------------------------------------------------+
//| Initialization of indicators and time series.                    |
//| INPUT:  indicators - pointer to an object-collection             |
//|                      of indicators and time series.              |
//| OUTPUT: true - in case of successful, otherwise - false.         |
//| REMARK: no.                                                      |
//+------------------------------------------------------------------+
bool CFiboCandlesSignal::InitIndicators(CIndicators *indicators)
  {
//--- check of pointer
   if(indicators==NULL) return(false);

//--- indicator initialization
   if(!InitFiboCandles(indicators)) return(false);

//--- successful completion
   return(true);
  }
//+------------------------------------------------------------------+
//| FiboCandles indicator initialization.                            |
//| INPUT:  indicators - pointer to an object-collection             |
//|                      of indicators and time series.              |
//| OUTPUT: true - in case of successful, otherwise - false.         |
//| REMARK: no.                                                      |
//+------------------------------------------------------------------+
bool CFiboCandlesSignal::InitFiboCandles(CIndicators *indicators)
  {
//--- check of pointer
   if(indicators==NULL) return(false);

//--- adding an object to the collection
   if(!indicators.Add(GetPointer(m_indicator)))
     {
      printf(__FUNCTION__+": error of adding the object");
      return(false);
     }

//--- setting the indicator parameters
   MqlParam parameters[5];
   
   parameters[0].type=TYPE_STRING;
   parameters[0].string_value="FiboCandles.ex5";
   
   parameters[1].type=TYPE_UINT;
   parameters[1].integer_value=m_period;
   
   parameters[2].type=TYPE_UINT;
   parameters[2].integer_value=m_fiboLevel;
   
   parameters[3].type=TYPE_UINT;
   parameters[3].integer_value=m_SignalBar;
   
   parameters[4].type=TYPE_UINT;
   parameters[4].integer_value=0;

//--- object initialization   
   if(!m_indicator.Create(m_symbol.Name(),m_Ind_Timeframe,IND_CUSTOM,5,parameters))
     {
      printf(__FUNCTION__+": object initialization error");
      return(false);
     }
     
//--- number of buffers
   if(!m_indicator.NumBuffers(5)) return(false);
   
//--- FiboCandles indicator initialized successfully
   return(true);
  }
//+------------------------------------------------------------------+
//| Checking conditions for opening                                  |
//| a long position and closing a short one                          |
//| INPUT:  no                                                       |
//| OUTPUT: Vote weight from 0 to 100                                |
//| REMARK: no.                                                      |
//+------------------------------------------------------------------+
int CFiboCandlesSignal::LongCondition()
  {
//--- buy signal is determined by buffer 4 of the FiboCandles indicator
   double Signal0=m_indicator.GetData(4,m_SignalBar);
   double Signal1=m_indicator.GetData(4,m_SignalBar+1);

//--- getting a trading signal 
   if(Signal0==0)
     {
      if(Signal1==1)
        {
         if(m_BuyPosOpen)
           {
            if(m_SellPosClose) return(REVERSE_SHORT);
            else return(OPEN_LONG);
           }
         if(m_SellPosClose) return(CLOSE_SHORT);
        }
     }
//--- no trading signal
   return(NO_SIGNAL);
  }
//+------------------------------------------------------------------+
//| Checking conditions for opening                                  |
//| a short position and closing a long one                          |
//| INPUT:  no                                                       |
//| OUTPUT: Vote weight from 0 to 100                                |
//| REMARK: no.                                                      |
//+------------------------------------------------------------------+
int CFiboCandlesSignal::ShortCondition()
  {
//--- sell signal is determined by buffer 4 of the FiboCandles indicator
   double Signal0=m_indicator.GetData(4,m_SignalBar);
   double Signal1=m_indicator.GetData(4,m_SignalBar+1);

//--- getting a trading signal 
   if(Signal0==1)
     {
      if(Signal1==0)
        {
         if(m_SellPosOpen)
           {
            if(m_BuyPosClose) return(REVERSE_LONG);
            else return(OPEN_SHORT);
           }
         if(m_BuyPosClose) return(CLOSE_LONG);
        }
     }
//--- no trading signal   
   return(NO_SIGNAL);
  }
//+------------------------------------------------------------------+