//+------------------------------------------------------------------+
//|                                                 Speed_Kharko.mq4 |
//|                      Copyright  2005, MetaQuotes Software Corp. |
//|                                       http://www.metaquotes.net/ |
//+------------------------------------------------------------------+
#property copyright "Copyright  2007, Kharko"

//---- indicator settings
#property  indicator_chart_window
#property  indicator_buffers 4
#property  indicator_color1  Yellow
#property  indicator_color2  Yellow
#property  indicator_style2  STYLE_DOT
#property  indicator_color3  Aqua
#property  indicator_color4  Aqua
#property  indicator_style4  STYLE_DOT

//---- indicator parameters
extern int    Bar          = 24;       // 
extern int    Cena         = 0;        // : 1 - ; 2 - ; 3 - ; 4 - ;
                                       //       5 - (H + L)/2; 6 - (H+L+C)/3; 7 - (H+L+C+O)/4;
                                       //       0 - (H+L+C+O)/4
extern bool   Sp_vis        = true;    // /  
extern bool   SpOf_vis      = true;    // /      

//---- indicator buffers
double     ExtBuffer0[];
double     ExtBuffer1[];
double     ExtBuffer2[];
double     ExtBuffer3[];
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int init()
  {
//---- drawing settings
   SetIndexStyle(0,DRAW_LINE);
   SetIndexStyle(1,DRAW_LINE);
   SetIndexStyle(2,DRAW_LINE);
   SetIndexStyle(3,DRAW_LINE);
//---- 4 indicator buffers mapping
   SetIndexBuffer(0,ExtBuffer0);
   SetIndexBuffer(1,ExtBuffer1);
   SetIndexBuffer(2,ExtBuffer2);
   SetIndexBuffer(3,ExtBuffer3);
//---- name for DataWindow and indicator subwindow label
   IndicatorShortName("Speed");
   SetIndexLabel(0,"Speed");
   SetIndexLabel(1,"SpeedNULL");
   SetIndexLabel(2,"Speed+Offset");
   SetIndexLabel(3,"SpeedNULL+Offset");
//---- initialization done

   return(0);
  }
//+------------------------------------------------------------------+
//| Accelerator/Decelerator Oscillator                               |
//+------------------------------------------------------------------+
int start()
  {
   int    limit,Error;
//---- last counted bar will be recounted
   int counted_bars=IndicatorCounted();
   if(counted_bars>0) counted_bars--;
   limit=Bars-counted_bars-Bar;
   if(limit<1)limit=1;
//---- 
   if(ExtBuffer0[0]!=0)ExtBuffer0[0]=0;
   if(ExtBuffer2[Bar]!=0)ExtBuffer2[Bar]=0;
   for(int i=0; i<limit; i++)
   {
      ExtBuffer0[i]=value(i);
      ExtBuffer1[i]=value(i+Bar);
      ExtBuffer2[i+Bar]=ExtBuffer0[i];
      ExtBuffer3[i+Bar]=value(i+Bar);
   }
   if(!Sp_vis)
   {
      ArrayInitialize(ExtBuffer0,0);
      ArrayInitialize(ExtBuffer1,0);
   }
   if(!SpOf_vis)
   {
      ArrayInitialize(ExtBuffer2,0);
      ArrayInitialize(ExtBuffer3,0);
   }

   Error=GetLastError();
   if(Error!=0 && Error!=1) {Print("Error START : ",Error);RefreshRates();}
   return(0);
  }
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
double value(int i)
{
  switch(Cena)
  {
      case 1:
         return(Open[i]);
      case 2:
         return(Close[i]);
      case 3:
         return(High[i]);
      case 4:
         return(Low[i]);
      case 5:
         return((High[i]+Low[i])/2);
      case 6:
         return((High[i]+Low[i]+Close[i])/3);
      case 7:
         return((High[i]+Low[i]+Close[i]+Open[i])/4);
      default:
         return((High[i]+Low[i]+Close[i]+Open[i])/4);
  }

}

