//+------------------------------------------------------------------+
//|                                            LinearRegSlope_V1.mq5 | 
//|                                Copyright  2006, TrendLaboratory |
//|            http://finance.groups.yahoo.com/group/TrendLaboratory |
//|                                   E-mail: igorad2003@yahoo.co.uk |
//|                                                                  |
//|                         Modified from LinearRegSlope_v1 by Toshi |
//|                                  http://toshi52583.blogspot.com/ |
//+------------------------------------------------------------------+
//| Place the SmoothAlgorithms.mqh file                              |
//| to the directory: terminal_data_folder\MQL5\Include              |
//+------------------------------------------------------------------+
#property copyright "Copyright  2006, TrendLaboratory"
#property link      "http://finance.groups.yahoo.com/group/TrendLaboratory"
//--- indicator version
#property version   "1.00"
//--- drawing the indicator in a separate window
#property indicator_separate_window
//--- number of indicator buffers 2
#property indicator_buffers 2 
//--- only two plots are used
#property indicator_plots   2
//+-----------------------------------+
//|  Indicator 1 drawing parameters   |
//+-----------------------------------+
//--- drawing the indicator as a line
#property indicator_type1   DRAW_LINE
//--- dodger blue color is used for the indicator line
#property indicator_color1 DodgerBlue
//--- the indicator line is a continuous curve
#property indicator_style1  STYLE_SOLID
//--- indicator line width is equal to 1
#property indicator_width1  1
//--- displaying the indicator line label
#property indicator_label1  "Linear Reg Slope line"
//+-----------------------------------+
//|  Indicator 2 drawing parameters   |
//+-----------------------------------+
//--- drawing the indicator as a line
#property indicator_type2   DRAW_LINE
//--- coral color is used for the indicator line
#property indicator_color2 Coral
//--- the indicator line is a continuous curve
#property indicator_style2  STYLE_SOLID
//--- indicator line width is equal to 1
#property indicator_width2  1
//--- displaying the indicator line label
#property indicator_label2  "Trigger line"
//+-----------------------------------+
//|  CXMA class description           |
//+-----------------------------------+
#include <SmoothAlgorithms.mqh> 
//+-----------------------------------+
//--- declaration of the CXMA class variables from the SmoothAlgorithms.mqh file
CXMA XMA1;
//+-----------------------------------+
//|  Declaration of enumerations      |
//+-----------------------------------+
enum Applied_price_      // Type of constant
  {
   PRICE_CLOSE_ = 1,     // Close
   PRICE_OPEN_,          // Open
   PRICE_HIGH_,          // High
   PRICE_LOW_,           // Low
   PRICE_MEDIAN_,        // Median Price (HL/2)
   PRICE_TYPICAL_,       // Typical Price (HLC/3)
   PRICE_WEIGHTED_,      // Weighted Close (HLCC/4)
   PRICE_SIMPLE,         // Simple Price (OC/2)
   PRICE_QUARTER_,       // Quarted Price (HLOC/4) 
   PRICE_TRENDFOLLOW0_,  // TrendFollow_1 Price 
   PRICE_TRENDFOLLOW1_   // TrendFollow_2 Price 
  };
//+-----------------------------------+
//|  Indicator input parameters       |
//+-----------------------------------+
input Smooth_Method SlMethod=MODE_SMA; // Smoothing method
input int SlLength=12;                 // Smoothing depth
input int SlPhase=15;                  // Smoothing parameter
input Applied_price_ IPC=PRICE_CLOSE;  // Price constant
input int Shift=0;                     // Horizontal shift of the indicator in bars
input uint TriggerShift=1;             // Bar shift for the trigger 
//+-----------------------------------+
//--- declaration of the integer variables for the start of data calculation
int min_rates_total;
//--- declaration of dynamic arrays that will be used as indicator buffers
double RegSlopeBuffer[],TriggerBuffer[];
//--- declaration of global variables
int TriggerShift_;
double Num2,SumBars;
//--- declaration of dynamic arrays that will be used as ring buffers
int Count[];
double Smooth[];
//+------------------------------------------------------------------+
//|  Recalculation of position of the newest element in the array    |
//+------------------------------------------------------------------+   
void Recount_ArrayZeroPos(int &CoArr[], // return the current value of the price series by the link
                          int Size)     // number of the elements in the ring buffer
  {
//---
   int numb,Max1,Max2;
   static int count=1;

   Max2=Size;
   Max1=Max2-1;

   count--;
   if(count<0) count=Max1;

   for(int iii=0; iii<Max2; iii++)
     {
      numb=iii+count;
      if(numb>Max1) numb-=Max2;
      CoArr[iii]=numb;
     }
//---
  }
//+------------------------------------------------------------------+   
//| Custom indicator initialization function                         | 
//+------------------------------------------------------------------+ 
void OnInit()
  {
//--- initialization of variables of the start of data calculation
   min_rates_total=XMA1.GetStartBars(SlMethod,SlLength,SlPhase);
//--- setting up alerts for unacceptable values of external variables
   XMA1.XMALengthCheck("SlLength", SlLength);
   XMA1.XMAPhaseCheck("SlPhase", SlPhase, SlMethod);
//--- initialization of variables   
   SumBars=SlLength *(SlLength-1)*0.5;
   double SumSqrBars=(SlLength-1.0)*SlLength *(2.0*SlLength-1.0)/6.0;
   Num2=SumBars*SumBars-SlLength*SumSqrBars;
   TriggerShift_=int(min_rates_total+TriggerShift-1);
//--- memory distribution for variables' arrays  
   ArrayResize(Count,SlLength);
   ArrayResize(Smooth,SlLength);
//--- initialization of the variables arrays
   ArrayInitialize(Count,0);
   ArrayInitialize(Smooth,0.0);
//--- set RegSlopeBuffer[] dynamic array as an indicator buffer
   SetIndexBuffer(0,RegSlopeBuffer,INDICATOR_DATA);
//--- moving the indicator 1 horizontally
   PlotIndexSetInteger(0,PLOT_SHIFT,Shift);
//--- performing the shift of the beginning of the indicator drawing
   PlotIndexSetInteger(0,PLOT_DRAW_BEGIN,min_rates_total);
//--- setting the indicator values that won't be visible on a chart
   PlotIndexSetDouble(0,PLOT_EMPTY_VALUE,EMPTY_VALUE);
//--- set TriggerBuffer[] dynamic array as an indicator buffer
   SetIndexBuffer(1,TriggerBuffer,INDICATOR_DATA);
//--- moving the indicator 1 horizontally
   PlotIndexSetInteger(1,PLOT_SHIFT,Shift);
//--- performing the shift of the beginning of the indicator drawing
   PlotIndexSetInteger(1,PLOT_DRAW_BEGIN,min_rates_total);
//--- setting the indicator values that won't be visible on a chart
   PlotIndexSetDouble(1,PLOT_EMPTY_VALUE,EMPTY_VALUE);
//--- initializations of a variable for the indicator short name
   string shortname;
   string Smooth1=XMA1.GetString_MA_Method(SlMethod);
   StringConcatenate(shortname,"Linear Reg Slope(",SlLength,", ",Smooth1,")");
//--- creation of the name to be displayed in a separate sub-window and in a tooltip
   IndicatorSetString(INDICATOR_SHORTNAME,shortname);
//--- determination of accuracy of displaying the indicator values
// IndicatorSetInteger(INDICATOR_DIGITS,_Digits+1);
//--- initialization end
  }
//+------------------------------------------------------------------+ 
//| Custom indicator iteration function                              | 
//+------------------------------------------------------------------+ 
int OnCalculate(const int rates_total,     // number of bars in history at the current tick
                const int prev_calculated, // number of bars calculated at previous call
                const datetime &time[],
                const double &open[],
                const double &high[],
                const double &low[],
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[])
  {
//--- checking the number of bars to be enough for the calculation
   if(rates_total<min_rates_total) return(0);
//--- declaration of variables with a floating point  
   double price_,Sum1,Sum2,SumY,Num1;
//--- declaration of integer variables and getting already calculated bars
   int first,bar,iii;
//--- calculation of the 'first' starting index for the bars recalculation loop
   if(prev_calculated>rates_total || prev_calculated<=0) // checking for the first start of the indicator calculation
      first=0;                   // starting index for calculation of all bars
   else first=prev_calculated-1; // starting index for calculation of new bars
//--- main indicator calculation loop
   for(bar=first; bar<rates_total && !IsStopped(); bar++)
     {
      //--- call of the PriceSeries function to get the input price 'price_'
      price_=PriceSeries(IPC,bar,open,low,high,close);
      Smooth[Count[0]]=XMA1.XMASeries(0,prev_calculated,rates_total,SlMethod,SlPhase,SlLength,price_,bar,false);
      //---
      Sum1=0;
      SumY=0;
      //---
      for(iii=0; iii<SlLength; iii++)
        {
         SumY+=Smooth[Count[iii]];
         Sum1+=iii*Smooth[Count[iii]];
        }
      //---
      Sum2=SumBars*SumY;
      Num1=SlLength*Sum1-Sum2;
      //---
      if(Num2!=0.0) RegSlopeBuffer[bar]=100*Num1/Num2;
      else          RegSlopeBuffer[bar]=EMPTY_VALUE;
      //---
      if(bar>TriggerShift_) TriggerBuffer[bar]=RegSlopeBuffer[bar-TriggerShift];
      else                 TriggerBuffer[bar]=EMPTY_VALUE;
      //--- recalculation of the elements positions in the Smooth[] ring buffer
      if(bar<rates_total-1) Recount_ArrayZeroPos(Count,SlLength);
     }
//---     
   return(rates_total);
  }
//+------------------------------------------------------------------+
