//+------------------------------------------------------------------+
//|                                                         Corr.mq5 | 
//|                                           Copyright  2006, Nike | 
//|                                              http://www.mql4.com | 
//+------------------------------------------------------------------+ 
#property copyright "Copyright  2006, Nike"
#property link "http://www.mql4.com"
//----   
#property version   "1.00"
//---     
#property indicator_separate_window
//----   
#property indicator_buffers 1 
//----     
#property indicator_plots   1
//+-----------------------------------+
//|       |
//+-----------------------------------+
//----     
#property indicator_type1   DRAW_LINE
//----       DodgerBlue 
#property indicator_color1 clrDodgerBlue
//----   -  
#property indicator_style1  STYLE_SOLID
//----     1
#property indicator_width1  1
//----   
#property indicator_label1  "Corr"
//+-----------------------------------+
//|         |
//+-----------------------------------+
input uint CorrLen=7;  // 
input int Shift=0;     //      
//+-----------------------------------+

//----   ,    
//      
double IndBuffer[];
//----      
int min_rates_total;
//+------------------------------------------------------------------+   
//| Custom indicator initialization function                         | 
//+------------------------------------------------------------------+ 
void OnInit()
  {
//----     
   min_rates_total=int(CorrLen);
   
//----      
   SetIndexBuffer(0,IndBuffer,INDICATOR_DATA);
//----    1  
   PlotIndexSetInteger(0,PLOT_SHIFT,Shift);
//----      
   PlotIndexSetInteger(0,PLOT_DRAW_BEGIN,min_rates_total);
//----   ,      
   PlotIndexSetDouble(0,PLOT_EMPTY_VALUE,0);
   
//----      
   string shortname;
   StringConcatenate(shortname,"Corr(",CorrLen,", ",Shift,")");
//---           
   IndicatorSetString(INDICATOR_SHORTNAME,shortname);
   
//---     
   IndicatorSetInteger(INDICATOR_DIGITS,0);
//----  
  }
//+------------------------------------------------------------------+ 
//| Custom indicator iteration function                              | 
//+------------------------------------------------------------------+ 
int OnCalculate(
                const int rates_total,    //       
                const int prev_calculated,//       
                const datetime &time[],
                const double &open[],
                const double &high[],
                const double &low[],
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[]
                )
  {
//----       
   if(rates_total<min_rates_total) return(0);
   
//----        
   int first,bar;

//----    first    
   if(prev_calculated>rates_total || prev_calculated<=0) //      
      first=min_rates_total-1; //      
   else first=prev_calculated-1; //      

//----    
   for(bar=first; bar<rates_total && !IsStopped(); bar++) 
     {
      IndBuffer[bar]=(close[bar]-open[bar])/_Point;
      IndBuffer[bar]=corr(IndBuffer,bar,CorrLen);
     }
//----     
   return(rates_total);
  }
//+------------------------------------------------------------------+
//|  corr()                                                          |
//+------------------------------------------------------------------+
double corr(double &a[],int index,int len)
  {
//----
   double m1 = 0;
   double m2 = 0;
   double m1_2 = 0;
   double m2_2 = 0;
   double m12=0;
//----
   for(int i=0; i<len; i++)
     {
      m1+=a[i];
      m2+=a[index-i];
      m1_2+=a[i]*a[i];
      m2_2+=a[index-i]*a[index-i];
      m12+=a[i]*a[index-i];
     }
//----
   m1 = m1/len;
   m2 = m2/len;
   m1_2/=len;
   m2_2/=len;
   m12/=len;
   double res=(m1_2-m1*m1)*(m2_2-m2*m2);
   if(!res) return(0);
//----
   return((m12 - m1*m2)/MathSqrt(MathAbs(res)));
  }
//+------------------------------------------------------------------+
