//+------------------------------------------------------------------+
//|                                   KeyboardTrader_Isolation.mq5   |
//|                        Generated by Gemini for User              |
//|                                                                  |
//+------------------------------------------------------------------+
#property copyright "Gemini AI"
#property link      ""
#property version   "5.30"

#include <Trade\Trade.mqh>

//--- [枚举定义]
enum ENUM_STRATEGY_MODE { MODE_SCALP, MODE_TREND, MODE_ERROR };
enum ENUM_LOT_MODE      { LOT_FIXED,  LOT_RISK_PERCENT };

//--- [外观设置]
input string         _Sep0          = "=== 外观设置 ===";
input color          InpTitleColor  = clrGray; // 标题颜色

//--- [资金管理 (核心)]
input string         _SepRisk       = "=== 资金管理 (核心) ===";
input ENUM_LOT_MODE  InpLotMode     = LOT_RISK_PERCENT; // 默认使用风险百分比
input double         InpRiskPercent = 1.0;              // 每单亏损本金的 1%
input double         InpFixedLots   = 0.01;             // 如果选固定，用这个手数

//--- [公共设置]
input int            InpSlippage    = 10; // 允许滑点

//--- [参数组 A: 短线模式 (M1-M30)]
input string         _SepA          = ">>> [A] 短线模式 (M1-M30) <<<";
input int            Magic_Scalp    = 555001;   // [独立魔术号]
input int            S_StopLoss     = 300;      // 止损 (点数)
input int            S_TakeProfit   = 600;      // 止盈 (点数)
input int            S_BEStart      = 150;      // 自动保本触发点
input int            S_BEOffset     = 20;       // 保本保护距离
input int            S_TrailStart   = 300;      // 追踪止损触发点
input int            S_TrailDist    = 100;      // 追踪距离
input int            S_TrailStep    = 50;       // 追踪步长
input int            S_MaxTPTimes   = 3;        // 最大扩利次数

//--- [参数组 B: 趋势模式 (H1-D1)]
input string         _SepB          = ">>> [B] 趋势模式 (H1-D1) <<<";
input int            Magic_Trend    = 888002;   // [独立魔术号]
input int            T_StopLoss     = 500;      // 止损 (点数)
input int            T_TakeProfit   = 1500;     // 止盈 (点数)
input int            T_BEStart      = 200;      // 自动保本触发点
input int            T_BEOffset     = 30;       // 保本保护距离
input int            T_TrailStart   = 500;      // 追踪止损触发点
input int            T_TrailDist    = 400;      // 追踪距离
input int            T_TrailStep    = 200;      // 追踪步长
input int            T_MaxTPTimes   = 20;       // 最大扩利次数

//--- [功能开关]
input string         _SepC          = "=== 功能开关 ===";
input bool           InpUseBE       = true;     // 启用自动保本
input bool           InpUseTrail    = true;     // 启用追踪止损
input bool           InpSyncTP      = true;     // 启用止盈跟随

//--- 全局变量
CTrade         trade;
int            g_mult = 1; 
ENUM_STRATEGY_MODE g_currentMode = MODE_ERROR;

//+------------------------------------------------------------------+
//| 初始化函数                                                        |
//+------------------------------------------------------------------+
int OnInit()
  {
   trade.SetDeviationInPoints(InpSlippage);
   trade.SetAsyncMode(true); // 异步模式，提高响应速度
   
   // 自动判断黄金3位报价修正 (x10)
   if(StringFind(_Symbol, "XAU") != -1 && _Digits == 3) {
      g_mult = 10;
      Print(">>> 检测到3位报价黄金，自动开启 x10 倍率修正");
   }
   
   CheckTimeframe(); // 初始化时立即检测周期
   
   ChartSetInteger(0, CHART_EVENT_OBJECT_CREATE, true); 
   ChartSetInteger(0, CHART_EVENT_OBJECT_DELETE, true);
   EventSetTimer(1); 
   
   ObjectsDeleteAll(0, "KeyTrader_"); // 清理旧对象
   UpdatePanel();
   
   return(INIT_SUCCEEDED);
  }

//+------------------------------------------------------------------+
//| 去初始化函数                                                      |
//+------------------------------------------------------------------+
void OnDeinit(const int reason)
  {
   EventKillTimer();
   ObjectsDeleteAll(0, "KeyTrader_"); 
   Comment(""); 
  }

//+------------------------------------------------------------------+
//| 报价跳动事件                                                      |
//+------------------------------------------------------------------+
void OnTick()
  {
   CheckTimeframe(); // 实时检测周期，防止用户中途切图表
   if(InpUseBE || InpUseTrail) ManagePositions();
  }

//+------------------------------------------------------------------+
//| 定时器事件 (刷新面板)                                             |
//+------------------------------------------------------------------+
void OnTimer()
  {
   UpdatePanel();
  }

//+------------------------------------------------------------------+
//| 周期自动识别                                                      |
//+------------------------------------------------------------------+
void CheckTimeframe()
  {
   ENUM_TIMEFRAMES p = Period();
   
   // 短线组: M1, M5, M15, M30
   if(p == PERIOD_M1 || p == PERIOD_M5 || p == PERIOD_M15 || p == PERIOD_M30) 
      g_currentMode = MODE_SCALP;
   // 趋势组: H1, H4, D1
   else if(p == PERIOD_H1 || p == PERIOD_H4 || p == PERIOD_D1)
      g_currentMode = MODE_TREND;
   // 不支持的周期
   else
      g_currentMode = MODE_ERROR;
  }

//+------------------------------------------------------------------+
//| 核心算法：风控手数计算                                            |
//+------------------------------------------------------------------+
double CalculateRiskLots(int slPoints)
  {
   if(InpLotMode == LOT_FIXED) return InpFixedLots;
   
   double balance = AccountInfoDouble(ACCOUNT_BALANCE);
   double riskMoney = balance * InpRiskPercent / 100.0;
   
   double tickValue = SymbolInfoDouble(_Symbol, SYMBOL_TRADE_TICK_VALUE);
   double tickSize  = SymbolInfoDouble(_Symbol, SYMBOL_TRADE_TICK_SIZE);
   double point     = SymbolInfoDouble(_Symbol, SYMBOL_POINT);
   
   // 计算真实的止损距离 (Point单位)
   double slDistance = slPoints * g_mult;
   
   // 防止除零错误
   if(tickSize == 0 || slDistance == 0) return InpFixedLots;

   // 计算每点价值
   double pointValue = tickValue * (point / tickSize);
   
   double lots = riskMoney / (slDistance * pointValue);
   
   // 规范化手数
   double minLot  = SymbolInfoDouble(_Symbol, SYMBOL_VOLUME_MIN);
   double maxLot  = SymbolInfoDouble(_Symbol, SYMBOL_VOLUME_MAX);
   double stepLot = SymbolInfoDouble(_Symbol, SYMBOL_VOLUME_STEP);
   
   lots = MathFloor(lots / stepLot) * stepLot; 
   
   if(lots < minLot) lots = minLot;
   if(lots > maxLot) lots = maxLot;
   
   return lots;
  }

//+------------------------------------------------------------------+
//| 辅助：获取当前模式下的参数                                         |
//+------------------------------------------------------------------+
int    CurMagic()      { return (g_currentMode == MODE_SCALP) ? Magic_Scalp : Magic_Trend; }
int    CurSL()         { return (g_currentMode == MODE_SCALP) ? S_StopLoss : T_StopLoss; }
int    CurTP()         { return (g_currentMode == MODE_SCALP) ? S_TakeProfit : T_TakeProfit; }

//+------------------------------------------------------------------+
//| 面板显示函数                                                      |
//+------------------------------------------------------------------+
void UpdatePanel()
  {
   CheckTimeframe(); // 刷新状态
   
   datetime time = TimeCurrent();
   int ping = TerminalInfoInteger(TERMINAL_PING_LAST) / 1000; 
   int spread = (int)SymbolInfoInteger(_Symbol, SYMBOL_SPREAD);
   
   // 获取各周期倒计时
   long secM5  = GetTimeLeftSeconds(PERIOD_M5);
   long secM15 = GetTimeLeftSeconds(PERIOD_M15);
   long secH1  = GetTimeLeftSeconds(PERIOD_H1);
   long secH4  = GetTimeLeftSeconds(PERIOD_H4);
   
   string strM5  = "M5: "  + FormatTimeLeft(secM5);
   string strM15 = "M15: " + FormatTimeLeft(secM15);
   string strH1  = "H1: "  + FormatTimeLeft(secH1);
   string strH4  = "H4: "  + FormatTimeLeft(secH4);
   
   string modeStr = "";
   color  modeColor = clrGray;
   string line3 = "";
   
   double currentLots = (g_currentMode == MODE_ERROR) ? 0 : CalculateRiskLots(CurSL());
   double rrRatio     = (g_currentMode == MODE_ERROR) ? 0 : (double)CurTP() / (double)CurSL();
   
   // 设置状态栏文本
   if(g_currentMode == MODE_SCALP) {
      modeStr = "[模式: 短线]";
      modeColor = clrDeepSkyBlue; 
      line3 = StringFormat("独占控制: 短线单 (...%d) | 盈亏比 1:%.1f", Magic_Scalp % 1000, rrRatio);
   } 
   else if(g_currentMode == MODE_TREND) {
      modeStr = "[模式: 趋势]";
      modeColor = clrOrangeRed;   
      line3 = StringFormat("独占控制: 趋势单 (...%d) | 盈亏比 1:%.1f", Magic_Trend % 1000, rrRatio);
   }
   else {
      modeStr = "[不支持]";
      modeColor = clrRed;
      line3 = "请切换周期";
   }
   
   string line1 = StringFormat("=== 独立控制 v5.3 %s ===", modeStr);
   string line2 = "[D] 多单 | [J] 空单 | [B] 平盈 | [V] 全平";
   
   // 风险信息行
   string riskInfo = (InpLotMode == LOT_FIXED) ? StringFormat("固定: %.2f", InpFixedLots) : StringFormat("风险: %.1f%%", InpRiskPercent);
   string line4_Risk = StringFormat("%s = %.2f手 | SL: %d | TP: %d", riskInfo, currentLots, CurSL(), CurTP());
   
   string line_Time = StringFormat("时间: %s | 盘口: %s", TimeToString(time, TIME_SECONDS), GetMarketSession());
   string line_Info = StringFormat("点差: %d | 延迟: %d ms", spread, ping);

   // --- 绘制对象 ---
   CreateLabel("KeyTrader_L1", line1, 20, 20, modeColor, 10, true);
   CreateLabel("KeyTrader_L2", line2, 20, 45, clrWhite, 10);
   CreateLabel("KeyTrader_L3", line3, 20, 65, clrLime, 10); 
   
   // 风控行 (黄色)
   CreateLabel("KeyTrader_Risk", line4_Risk, 20, 85, clrYellow, 10, true);

   // 倒计时行 (单行并排)
   int y_cd = 110;
   CreateLabel("KeyTrader_M5",  strM5,  20,  y_cd, GetCountdownColor(PERIOD_M5, secM5), 10, true);
   CreateLabel("KeyTrader_M15", strM15, 100, y_cd, GetCountdownColor(PERIOD_M15, secM15), 10, true);
   CreateLabel("KeyTrader_H1",  strH1,  180, y_cd, GetCountdownColor(PERIOD_H1, secH1), 10, true);
   CreateLabel("KeyTrader_H4",  strH4,  260, y_cd, GetCountdownColor(PERIOD_H4, secH4), 10, true);

   // 底部信息
   CreateLabel("KeyTrader_Time", line_Time, 20, 135, clrSilver, 9);
   
   color spreadColor = (spread > 30 * g_mult) ? clrRed : clrGray;
   CreateLabel("KeyTrader_Info", line_Info, 20, 155, spreadColor, 9);
   
   ChartRedraw();
  }

//+------------------------------------------------------------------+
//| 开单逻辑 (自动使用对应 Magic)                                      |
//+------------------------------------------------------------------+
void OpenOrder(ENUM_ORDER_TYPE type)
  {
   if(g_currentMode == MODE_ERROR) { Alert("当前周期不支持交易!"); PlaySound("Timeout"); return; }
   
   // 设置对应的魔术号
   trade.SetExpertMagicNumber(CurMagic());
   
   int currentSL = CurSL();
   int currentTP = CurTP();
   double lots = CalculateRiskLots(currentSL);
   
   double price = (type == ORDER_TYPE_BUY) ? SymbolInfoDouble(_Symbol, SYMBOL_ASK) : SymbolInfoDouble(_Symbol, SYMBOL_BID);
   int realSL = currentSL * g_mult; 
   int realTP = currentTP * g_mult;
   double sl=0, tp=0;
   
   if(currentSL > 0) sl = (type == ORDER_TYPE_BUY) ? price - realSL * _Point : price + realSL * _Point;
   if(currentTP > 0) tp = (type == ORDER_TYPE_BUY) ? price + realTP * _Point : price - realTP * _Point;
   
   string comment = (g_currentMode == MODE_SCALP) ? "Risk-Scalp" : "Risk-Trend";
   
   if(type == ORDER_TYPE_BUY) trade.Buy(lots, _Symbol, price, NormalizeDouble(sl, _Digits), NormalizeDouble(tp, _Digits), comment);
   else trade.Sell(lots, _Symbol, price, NormalizeDouble(sl, _Digits), NormalizeDouble(tp, _Digits), comment);
  }

//+------------------------------------------------------------------+
//| 订单管理 (严格隔离：只管理属于当前模式的 Magic)                      |
//+------------------------------------------------------------------+
void ManagePositions() {
   // 获取当前窗口应该管理的 Magic
   long targetMagic = CurMagic();
   
   for(int i = PositionsTotal() - 1; i >= 0; i--) {
      ulong ticket = PositionGetTicket(i);
      if(PositionSelectByTicket(ticket) && PositionGetString(POSITION_SYMBOL) == _Symbol) {
         long magic = PositionGetInteger(POSITION_MAGIC);
         
         // [严格隔离] 如果魔术号不匹配当前窗口，跳过！
         if(magic != targetMagic) continue;

         // 加载对应参数
         int p_BEStart=0, p_BEOffset=0, p_TrailStart=0, p_TrailDist=0, p_TrailStep=0, p_MaxTimes=0, p_BaseTP=0;
         if(magic == Magic_Scalp) {
            p_BEStart=S_BEStart; p_BEOffset=S_BEOffset; p_TrailStart=S_TrailStart; p_TrailDist=S_TrailDist; p_TrailStep=S_TrailStep; p_MaxTimes=S_MaxTPTimes; p_BaseTP=S_TakeProfit;
         } else {
            p_BEStart=T_BEStart; p_BEOffset=T_BEOffset; p_TrailStart=T_TrailStart; p_TrailDist=T_TrailDist; p_TrailStep=T_TrailStep; p_MaxTimes=T_MaxTPTimes; p_BaseTP=T_TakeProfit;
         }

         // 执行通用管理
         int r_BEStart=p_BEStart*g_mult; int r_BEOffset=p_BEOffset*g_mult; int r_TrailStart=p_TrailStart*g_mult; int r_TrailDist=p_TrailDist*g_mult; int r_TrailStep=p_TrailStep*g_mult;
         long type = PositionGetInteger(POSITION_TYPE); double open = PositionGetDouble(POSITION_PRICE_OPEN);
         double sl = PositionGetDouble(POSITION_SL); double tp = PositionGetDouble(POSITION_TP);
         double cur = (type == POSITION_TYPE_BUY) ? SymbolInfoDouble(_Symbol, SYMBOL_BID) : SymbolInfoDouble(_Symbol, SYMBOL_ASK);
         double pt = SymbolInfoDouble(_Symbol, SYMBOL_POINT);
         double profit = (type == POSITION_TYPE_BUY) ? (cur - open) / pt : (open - cur) / pt;
         bool mod = false; double nSL = sl; double nTP = tp;

         // 保本
         if(InpUseBE && profit >= r_BEStart) {
            double be = (type == POSITION_TYPE_BUY) ? open + r_BEOffset * pt : open - r_BEOffset * pt;
            if((type == POSITION_TYPE_BUY && (sl < be - pt || sl == 0)) || (type == POSITION_TYPE_SELL && (sl > be + pt || sl == 0))) { nSL = be; mod = true; }
         }
         // 追踪
         bool trailTrig = false;
         if(InpUseTrail && profit >= r_TrailStart) {
            double target = (type == POSITION_TYPE_BUY) ? cur - r_TrailDist * pt : cur + r_TrailDist * pt;
            if((type == POSITION_TYPE_BUY && target > sl + r_TrailStep * pt) || (type == POSITION_TYPE_SELL && (target < sl - r_TrailStep * pt || sl == 0))) {
               nSL = target; mod = true; trailTrig = true;
            }
            // TP跟随
            if(InpSyncTP && trailTrig && tp > 0) {
               double baseTPVal = (type == POSITION_TYPE_BUY) ? open + p_BaseTP * g_mult * pt : open - p_BaseTP * g_mult * pt;
               int times = (int)(MathAbs(tp - baseTPVal) / (r_TrailStep * pt));
               if(times < p_MaxTimes) {
                  nTP = (type == POSITION_TYPE_BUY) ? tp + r_TrailStep * pt : tp - r_TrailStep * pt; mod = true;
               }
            }
         }
         if(mod) trade.PositionModify(ticket, NormalizeDouble(nSL, _Digits), NormalizeDouble(nTP, _Digits));
      }
   }
}

//+------------------------------------------------------------------+
//| 键盘监听                                                          |
//+------------------------------------------------------------------+
void OnChartEvent(const int id, const long &lparam, const double &dparam, const string &sparam) {
   if(id == CHARTEVENT_KEYDOWN) {
      if(lparam == 68) OpenOrder(ORDER_TYPE_BUY);       // [D]
      if(lparam == 74) OpenOrder(ORDER_TYPE_SELL);      // [J]
      if(lparam == 66) CloseProfitPositions();          // [B]
      if(lparam == 86) CloseAllPositions();             // [V]
      ChartRedraw();
   }
}

//+------------------------------------------------------------------+
//| 平盈逻辑 (严格隔离：只平当前 Magic)                                 |
//+------------------------------------------------------------------+
void CloseProfitPositions() { 
   if(g_currentMode == MODE_ERROR) return;
   
   long targetMagic = CurMagic(); // [关键]
   
   double b=SymbolInfoDouble(_Symbol,SYMBOL_BID),a=SymbolInfoDouble(_Symbol,SYMBOL_ASK); 
   for(int i=PositionsTotal()-1;i>=0;i--){
      ulong t=PositionGetTicket(i);
      if(PositionSelectByTicket(t)&&PositionGetString(POSITION_SYMBOL)==_Symbol) {
         long m = PositionGetInteger(POSITION_MAGIC);
         
         // 只有 Magic 匹配才平
         if(m == targetMagic) {
            long ty=PositionGetInteger(POSITION_TYPE);double o=PositionGetDouble(POSITION_PRICE_OPEN);
            if((ty==POSITION_TYPE_BUY&&b>o)||(ty==POSITION_TYPE_SELL&&a<o)) trade.PositionClose(t);
         }
      }
   }
}

//+------------------------------------------------------------------+
//| 全平逻辑 (严格隔离：只平当前 Magic)                                 |
//+------------------------------------------------------------------+
void CloseAllPositions() { 
   if(g_currentMode == MODE_ERROR) return;

   long targetMagic = CurMagic(); // [关键]

   for(int i=PositionsTotal()-1;i>=0;i--){
      ulong t=PositionGetTicket(i);
      if(PositionSelectByTicket(t)&&PositionGetString(POSITION_SYMBOL)==_Symbol) {
         long m = PositionGetInteger(POSITION_MAGIC);
         
         // 只有 Magic 匹配才平
         if(m == targetMagic) trade.PositionClose(t);
      }
   } 
}

//--- 通用辅助函数 ---
long GetTimeLeftSeconds(ENUM_TIMEFRAMES p){datetime t=iTime(_Symbol,p,0);if(t==0)return 0;long ps=PeriodSeconds(p);long l=(t+ps)-TimeCurrent();return(l<0)?0:l;}
string FormatTimeLeft(long t){if(t>=3600)return StringFormat("%d:%02d:%02d",t/3600,(t%3600)/60,t%60);else return StringFormat("%02d:%02d",t/60,t%60);}
color GetCountdownColor(ENUM_TIMEFRAMES p,long t){long lim=PeriodSeconds(p)/5;if(t<lim)return clrRed;if(p==PERIOD_H1||p==PERIOD_H4)return clrGold;return clrWhite;}
string GetMarketSession() { datetime g=TimeGMT(); MqlDateTime d; TimeToStruct(g,d); int h=d.hour; string s=""; if(h>=0&&h<9)s+="亚盘 "; if(h>=7&&h<16)s+="欧盘 "; if(h>=12&&h<21)s+="美盘 "; return (s=="")?"清淡":s; }
void CreateLabel(string n,string t,int x,int y,color c,int s,bool b=false) { if(ObjectFind(0,n)<0){ObjectCreate(0,n,OBJ_LABEL,0,0,0);ObjectSetInteger(0,n,OBJPROP_CORNER,(long)CORNER_LEFT_UPPER);ObjectSetInteger(0,n,OBJPROP_XDISTANCE,(long)x);ObjectSetInteger(0,n,OBJPROP_YDISTANCE,(long)y);}ObjectSetString(0,n,OBJPROP_TEXT,t);ObjectSetInteger(0,n,OBJPROP_COLOR,(long)c);ObjectSetInteger(0,n,OBJPROP_FONTSIZE,(long)s);ObjectSetString(0,n,OBJPROP_FONT,b?"Microsoft YaHei Bold":"Microsoft YaHei");}
color GetLatencyColor(int p) { if(p<50)return clrLime; if(p<150)return clrYellow; return clrRed; }
//+------------------------------------------------------------------+