//+------------------------------------------------------------------+
//|                                         Test_IchimokuOnArray.mq5 |
//|                        Copyright 2011, MetaQuotes Software Corp. |
//|                                              http://www.mql5.com |
//+------------------------------------------------------------------+
#property copyright "Copyright 2011, MetaQuotes Software Corp."
#property link      "http://www.mql5.com"
#property version   "1.00"
#property indicator_chart_window
#property indicator_buffers 6
#property indicator_plots   4
//--- plot Label1
#property indicator_label1  "Label1"
#property indicator_type1   DRAW_LINE
#property indicator_color1  clrRed
#property indicator_style1  STYLE_SOLID
#property indicator_width1  1
//--- plot Label2
#property indicator_label2  "Label2"
#property indicator_type2   DRAW_LINE
#property indicator_color2  clrDeepSkyBlue
#property indicator_style2  STYLE_SOLID
#property indicator_width2  1
//--- plot Label3
#property indicator_label3  "Label3"
#property indicator_type3   DRAW_LINE
#property indicator_color3  clrKhaki
#property indicator_style3  STYLE_SOLID
#property indicator_width3  1
//--- plot Label4
#property indicator_label4  "Label4"
#property indicator_type4   DRAW_LINE
#property indicator_color4  clrSandyBrown
#property indicator_style4  STYLE_SOLID
#property indicator_width4  1
//--- input parameters
input int PeriodTenkan  =  9;
input int PeriodKijun   =  26;
input int PeriodSenkou  =  52;
/* 
  If TestShift=true, the SpanA and SpanB lines are shifter during calculation; 
  in this case, there will be no future data for these lines.

  If TestShift=false, shift the SpanA and SpanB lines 
  using the PlotIndexSetInteger(x,PLOT_SHIFT..., function, or calculate the index with consideration of SpanABShift().
*/
input bool TestShift=true;
//--- indicator buffers
double         TBuffer[];
double         KBuffer[];
double         SABuffer[];
double         SBBuffer[];

double         DataHigh[];
double         DataLow[];

#include <IncOnArray/IncIchimokuOnArray.mqh>
CIchimokuOnArray ich;
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int OnInit()
  {
   ich.Init(PeriodTenkan,PeriodKijun,PeriodSenkou,TestShift);

//--- indicator buffers mapping
   SetIndexBuffer(0,TBuffer,INDICATOR_DATA);
   SetIndexBuffer(1,KBuffer,INDICATOR_DATA);
   SetIndexBuffer(2,SABuffer,INDICATOR_DATA);
   SetIndexBuffer(3,SBBuffer,INDICATOR_DATA);

   SetIndexBuffer(4,DataHigh,INDICATOR_CALCULATIONS);
   SetIndexBuffer(5,DataLow,INDICATOR_CALCULATIONS);

   if(!TestShift)
     {
      PlotIndexSetInteger(2,PLOT_SHIFT,PeriodKijun);
      PlotIndexSetInteger(3,PLOT_SHIFT,PeriodKijun);
     }

   PlotIndexSetString(0,PLOT_LABEL,ich.NameT());
   PlotIndexSetString(1,PLOT_LABEL,ich.NameK());
   PlotIndexSetString(2,PLOT_LABEL,ich.NameSA());
   PlotIndexSetString(3,PLOT_LABEL,ich.NameSB());

   PlotIndexSetInteger(0,PLOT_DRAW_BEGIN,ich.BarsRequiredTK());
   PlotIndexSetInteger(1,PLOT_DRAW_BEGIN,ich.BarsRequiredTK());
   PlotIndexSetInteger(2,PLOT_DRAW_BEGIN,ich.BarsRequiredAB());
   PlotIndexSetInteger(3,PLOT_DRAW_BEGIN,ich.BarsRequiredAB());

//---
   return(0);
  }
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int OnCalculate(const int rates_total,
                const int prev_calculated,
                const datetime &time[],
                const double &open[],
                const double &high[],
                const double &low[],
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[])
  {
   int start;
   if(prev_calculated>0)
     {
      start=prev_calculated-1;
     }
   else
     {
      start=0;
     }
   for(int i=start;i<rates_total;i++)
     {
      DataHigh[i]=high[i];
      DataLow[i]=low[i];
     }

   ich.Solve(rates_total,prev_calculated,DataHigh,DataLow,TBuffer,KBuffer,SABuffer,SBBuffer);

   return(rates_total);
  }
//+------------------------------------------------------------------+
