//+------------------------------------------------------------------+
//|                                              Test_RSIOnArray.mq5 |
//|                        Copyright 2011, MetaQuotes Software Corp. |
//|                                              http://www.mql5.com |
//+------------------------------------------------------------------+
#property copyright "Copyright 2011, MetaQuotes Software Corp."
#property link      "http://www.mql5.com"
#property version   "1.00"
#property indicator_separate_window
#property indicator_minimum 0
#property indicator_maximum 100
#property indicator_buffers 6
#property indicator_plots   1
//--- plot Label1
#property indicator_label1  "Label1"
#property indicator_type1   DRAW_LINE
#property indicator_color1  clrRed
#property indicator_style1  STYLE_SOLID
#property indicator_width1  1
//--- 
input int            RSIPeriod   =  14;
input ENUM_MA_METHOD RSIMethod   =  MODE_SMMA;
//--- indicator buffers
double         RSIBuffer[];
double         data[];
//--- 
double         PBuffer[];
double         MBuffer[];
double         PSBuffer[];
double         MSBuffer[];
//--- 
#include <IncOnArray/IncRSIOnArray.mqh>
CRSIOnArray rsi;
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int OnInit()
  {
   rsi.Init(RSIPeriod,RSIMethod);
//--- indicator buffers mapping
   SetIndexBuffer(0,RSIBuffer,INDICATOR_DATA);
   SetIndexBuffer(1,PBuffer,INDICATOR_CALCULATIONS);
   SetIndexBuffer(2,MBuffer,INDICATOR_CALCULATIONS);
   SetIndexBuffer(3,PSBuffer,INDICATOR_CALCULATIONS);
   SetIndexBuffer(4,MSBuffer,INDICATOR_CALCULATIONS);
   SetIndexBuffer(5,data,INDICATOR_CALCULATIONS);

   PlotIndexSetInteger(0,PLOT_DRAW_BEGIN,rsi.BarsRequired());
   PlotIndexSetString(0,PLOT_LABEL,rsi.Name());
//---
   return(0);
  }
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int OnCalculate(const int rates_total,
                const int prev_calculated,
                const int begin,
                const double &price[])
  {
   int start;
   if(prev_calculated>0)
     {
      start=prev_calculated-1;
     }
   else
     {
      start=0;
     }
   for(int i=start;i<rates_total;i++)
     {
      data[i]=price[i];
     }

   rsi.Solve(rates_total,prev_calculated,data,PBuffer,MBuffer,PSBuffer,MSBuffer,RSIBuffer);

   return(rates_total);
  }
//+------------------------------------------------------------------+
