//+------------------------------------------------------------------+
//|                                                IncRSIOnArray.mqh |
//|                                                          Integer |
//|                          https://login.mql5.com/en/users/Integer |
//+------------------------------------------------------------------+
#property copyright "Integer"
#property link      "https://login.mql5.com/en/users/Integer"
#property version   "1.00"
/*
   External parameters:
   input int            RSIPeriod   =  14;
   input ENUM_MA_METHOD RSIMethod   =  MODE_SMMA;

   Declaration:

   #include <IncOnArray/IncRSIOnArray.mqh>
   CRSIOnArray rsi;

   In OnInit:  
   rsi.Init(RSIPeriod,RSIMethod);

   In OnCalculate:
   rsi.Solve(rates_total,prev_calculated,data,PBuffer,MBuffer,PSBuffer,MSBuffer,RSIBuffer);    

*/

#include <IncOnArray/IncMAOnArray.mqh>
//+------------------------------------------------------------------+
//| CRSIOnArray                                                      |
//+------------------------------------------------------------------+
class CRSIOnArray
  {
private:
   int               m_Period;
   ENUM_MA_METHOD    m_Method;
   string            m_Name;
   CMAOnArray        m_pma;
   CMAOnArray        m_mma;
   int               m_br;
public:
   void Init(int aPeriod=14,ENUM_MA_METHOD aMethod=MODE_SMMA)
     {
      m_Period=aPeriod;
      m_Method=aMethod;
      m_pma.Init(m_Period,m_Method);
      m_mma.Init(m_Period,m_Method);
      m_Name="RSI("+IntegerToString(m_Period)+","+m_pma.NameMethod()+")";
      m_br=m_pma.BarsRequired()+1;
     }
   void Solve(const int aRatesTotal,
              const int aPrevCalc,
              double  &aData[],
              double  &aP[],
              double  &aM[],
              double  &aPS[],
              double  &aMS[],
              double  &aRSI[])
     {
      int Start=0;
      if(aPrevCalc==0)
        {
         for(int i=0;i<aRatesTotal;i++)
           {
            if(aData[i]!=0 && aData[i]!=EMPTY_VALUE)
              {
               Start=i+1;
               break;
              }
           }
         double diff=aData[Start]-aData[Start-1];
         aP[Start]=(diff>0?diff:0.00000001);
         aM[Start]=(diff<0?-diff:0.00000001);
         Start++;
        }
      else
        {
         Start=aPrevCalc-1;
        }
      for(int i=Start;i<aRatesTotal;i++)
        {
         double diff=aData[i]-aData[i-1];
         aP[i]=(diff>0?diff:0);
         aM[i]=(diff<0?-diff:0);
        }
      m_pma.Solve(aRatesTotal,aPrevCalc,aP,aPS);
      m_mma.Solve(aRatesTotal,aPrevCalc,aM,aMS);
      for(int i=Start;i<aRatesTotal;i++)
        {
         if(aMS[i]!=0)aRSI[i]=100.0-100.0/(1+aPS[i]/aMS[i]);
        }
     }
   int BarsRequired()
     {
      return(m_br);
     }
   string Name()
     {
      return(m_Name);
     }
   string About()
     {
      return("Integer's RSIOnArray class. https://login.mql5.com/en/users/Integer");
     }
  };
//+------------------------------------------------------------------+
