//+------------------------------------------------------------------+
//|                                              IncForceOnArray.mqh |
//|                                                          Integer |
//|                          https://login.mql5.com/ru/users/Integer |
//+------------------------------------------------------------------+
#property copyright "Integer"
#property link      "https://login.mql5.com/ru/users/Integer"
#property version   "1.00"
/*
   External parameters:
   input int               FPeriod  =  14;
   input ENUM_MA_METHOD    FMethod  =  MODE_SMA;

   Declaration:
   #include <IncOnArray/IncForceOnArray.mqh>
   CForceOnArray force;

   In OnInit:
   force.Init(FPeriod,FMethod);

   In OnCalculate:
   force.Solve(rates_total,prev_calculated,DataPrice,DataVolume,MABuffer,FBuffer);
*/

#include <IncOnArray/IncMAOnArray.mqh>
//+------------------------------------------------------------------+
//| CForceOnArray                                                    |
//+------------------------------------------------------------------+
class CForceOnArray
  {
private:
   int               m_Period;
   string            m_Name;
   CMAOnArray        m_ma;
   int               m_br;
public:
   void Init(int aPeriod=14,ENUM_MA_METHOD aMethod=MODE_SMA)
     {
      m_Period=aPeriod;
      m_ma.Init(m_Period,aMethod);
      m_Name="Force("+IntegerToString(m_Period)+","+m_ma.NameMethod()+")";
      m_br=m_ma.BarsRequired()+1;
     }
   void Solve(const int aRatesTotal,
              const int aPrevCalc,
              double  &aDataPrice[],
              double  &aDataVolume[],
              double  &aMA[],
              double  &aForce[])
     {
      m_ma.Solve(aRatesTotal,aPrevCalc,aDataPrice,aMA);
      int Start=0;
      if(aPrevCalc==0)
        {
         for(int i=0;i<aRatesTotal;i++)
           {
            if(aMA[i]!=0 && aMA[i]!=EMPTY_VALUE)
              {
               Start=i+1;
               break;
              }
           }
        }
      else
        {
         Start=aPrevCalc-1;
        }
      for(int i=Start;i<aRatesTotal;i++)
        {

         aForce[i]=aDataVolume[i]*(aMA[i]-aMA[i-1]);
        }
     }
   int BarsRequired()
     {
      return(m_br);
     }
   string Name()
     {
      return(m_Name);
     }
   string About()
     {
      return("Integer's ForceOnArray class. https://login.mql5.com/ru/users/Integer");
     }
  }; 
//+------------------------------------------------------------------+
