//+------------------------------------------------------------------+
//|                                            Test_ForceOnArray.mq5 |
//|                        Copyright 2011, MetaQuotes Software Corp. |
//|                                              http://www.mql5.com |
//+------------------------------------------------------------------+
#property copyright "Copyright 2011, MetaQuotes Software Corp."
#property link      "http://www.mql5.com"
#property version   "1.00"
#property indicator_separate_window
#property indicator_buffers 4
#property indicator_plots   1
//--- plot Label1
#property indicator_label1  "Label1"
#property indicator_type1   DRAW_LINE
#property indicator_color1  clrRed
#property indicator_style1  STYLE_SOLID
#property indicator_width1  1
//--- input parameters
input int               FPeriod  =  14;
input ENUM_MA_METHOD    FMethod  =  MODE_SMA;
//--- indicator buffers
double         FBuffer[];
double         MABuffer[];
double         DataPrice[];
double         DataVolume[];
#include <IncOnArray/IncForceOnArray.mqh>
CForceOnArray force;
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int OnInit()
  {
   force.Init(FPeriod,FMethod);

//--- indicator buffers mapping
   SetIndexBuffer(0,FBuffer,INDICATOR_DATA);
   SetIndexBuffer(1,MABuffer,INDICATOR_CALCULATIONS);
   SetIndexBuffer(2,DataPrice,INDICATOR_CALCULATIONS);
   SetIndexBuffer(3,DataVolume,INDICATOR_CALCULATIONS);

   PlotIndexSetInteger(0,PLOT_DRAW_BEGIN,force.BarsRequired());
   PlotIndexSetString(0,PLOT_LABEL,force.Name());
//---
   return(0);
  }
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int OnCalculate(const int rates_total,
                const int prev_calculated,
                const datetime &time[],
                const double &open[],
                const double &high[],
                const double &low[],
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[])
  {
   int start;
   if(prev_calculated>0)
     {
      start=prev_calculated-1;
     }
   else
     {
      start=0;
     }
   for(int i=start;i<rates_total;i++)
     {
      DataPrice[i]=close[i];
      DataVolume[i]=(double)tick_volume[i];
     }

   force.Solve(rates_total,prev_calculated,DataPrice,DataVolume,MABuffer,FBuffer);

//--- return value of prev_calculated for next call
   return(rates_total);
  }
//+------------------------------------------------------------------+
