//+------------------------------------------------------------------+
//|                                             QuickSortStructT.mqh |
//|                             Copyright 2021-2024, MetaQuotes Ltd. |
//|                                             https://www.mql5.com |
//+------------------------------------------------------------------+

//+------------------------------------------------------------------+
//| Templatized class for quick sorting of anything                  |
//+------------------------------------------------------------------+
template<typename T>
class QuickSortStructT
{
public:
   void Swap(T &array[], const int i, const int j)
   {
      if(i == j) return;
      const T temp = array[i];
      array[i] = array[j];
      array[j] = temp;
   }
   
   // should override this with operator '>' equivalent
   // applied to any field of struct, object or array column
   virtual bool Compare(const T &a, const T &b) = 0;
   
   void QuickSort(T &array[], const int start = 0, int end = INT_MAX)
   {
      if(end == INT_MAX)
      {
         end = start + ArraySize(array) - 1;
      }
      if(start < end)
      {
         int pivot = start;
         Swap(array, (start + end) / 2 + 1, end); // eliminate slow-downs and minimize probability of stack-overflows for mostly sorted large arrays
   
         for(int i = start; i <= end; i++)
         {
            // use custom implementation of virtual Compare override
            if(!Compare(array[i], array[end]))
            {
               Swap(array, i, pivot++);
            }
         }
   
         --pivot;
   
         QuickSort(array, start, pivot - 1);
         QuickSort(array, pivot + 1, end);
      }
   }
};

//+------------------------------------------------------------------+
//| Convenient macro to sort 'A'rray of 'T'ype by 'F'ield            |
//+------------------------------------------------------------------+
#define SORT_STRUCT(T,A,F)                                           \
{                                                                    \
   class InternalSort : public QuickSortStructT<T>                   \
   {                                                                 \
      virtual bool Compare(const T &a, const T &b) override          \
      {                                                              \
         return a.##F > b.##F;                                       \
      }                                                              \
   } sort;                                                           \
   sort.QuickSort(A);                                                \
}

//+------------------------------------------------------------------+
//| Convenient macro to sort 'A'rray of 'T'ype by two 'F'ields       |
//+------------------------------------------------------------------+
#define SORT_STRUCT_2(T,A,F1,F2)                                     \
{                                                                    \
   class InternalSort : public QuickSortStructT<T>                   \
   {                                                                 \
      virtual bool Compare(const T &a, const T &b) override          \
      {                                                              \
         return (a.##F1 > b.##F1)                                    \
            || (a.##F1 == b.##F1 && a.##F2 > b.##F2);                \
      }                                                              \
   } sort;                                                           \
   sort.QuickSort(A);                                                \
}

//+------------------------------------------------------------------+
//| Example of macro usage to sort MqlRates struct by 'high' price   |
//+------------------------------------------------------------------+
/*
   MqlRates rates[];
   CopyRates(_Symbol, _Period, 0, 10000, rates);
   SORT_STRUCT(MqlRates, rates, high);
*/