//+------------------------------------------------------------------+
//|                                                         test.mq5 |
//|                                   Copyright 2024, Paulo Henrique |
//|                  https://www.mql5.com/en/users/pau1ohenrique.dev |
//+------------------------------------------------------------------+
#property copyright  "Copyright 2024, Paulo Henrique"
#property link       "https://www.mql5.com/en/users/pau1ohenrique.dev"
#property version    "1.00"

// Includes
#include <ErrorDescription2.mqh>

//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
void OnStart()
  {
//--- usage example #1
   Print("Description of MQL5 errors:");
   for(int i=FIRST_RUNTIME_ERROR; i<=LAST_TRADE_SERVER_ERROR; i++)
     {
      string error_desc=GetError(i);
      if(IsSuccess(i) || error_desc==NULL)
         continue;
      if(IsRuntimeError(i))
         Print("RuntimeError: ",error_desc);
      if(IsTradeServerError(i))
         Print("TradeServerError: ",error_desc);
      if(IsUserError(i))
         Print("UserError: ",error_desc);
     }
//--- usage example #2
   Print("\nLast error description:");
   int retcode=GetLastError();
   if(!IsSuccess(retcode))
      Print(GetError(retcode));

//--- or simply
   Print(GetError());
   // The operation completed successfully [0]
   // Unexpected internal error [4001]
   // ...
   Print(GetError(false));
   // The operation completed successfully
   // Unexpected internal error
   // ...
  }

//+------------------------------------------------------------------+
