//+------------------------------------------------------------------+
//|                             chande_momentum_oscillatorSignal.mqh |
//|                                                    2011, etrader |
//|                                             http://efftrading.ru |
//+------------------------------------------------------------------+
#property copyright "2011, etrader"
#property link      "http://efftrading.ru"
//+------------------------------------------------------------------+
//| include files                                                 |
//+------------------------------------------------------------------+
#include <Expert\ExpertSignal.mqh>
#define INDICATOR_CMO_FILENAME "chande_momentum_oscillator.ex5"
#property tester_indicator INDICATOR_CMO_FILENAME
#include <Expert\Signal\MySignals\BasedOnIndicatorExpertSignal.mqh>
// wizard description start
//+------------------------------------------------------------------+
//| Description of the class                                         |
//| Title=Signal based on Chande Momentum Oscillator                 |
//| Type=SignalAdvanced                                              |
//| Name=Chande_Momentum_Oscillator                                  |
//| Class=CChande_Momentum_Oscillator                                |
//| Page=                                                            |
//| Parameter=CMO_period,int,9,period of CMO                         |
//| Parameter=CMO_Shift,int,0,horizontal shift in bars               |
//+------------------------------------------------------------------+
//+------------------------------------------------------------------+
// wizard description end
//+------------------------------------------------------------------+

//+------------------------------------------------------------------+
//| CChande_Momentum_Oscillator class                                |
//| Purpose: A module of trade signals, based on                     |
//|          Chande Momentum Oscillator                              |
//|          http://www.mql5.com/en/code/411                         |  
//+------------------------------------------------------------------+
class CChande_Momentum_Oscillator: public CBasedOnIndicatorExpertSignal{
  private: 
   int m_cmo_period; //CMO period
   int m_cmo_shift ; //horizontal shift in bars
  public:
   virtual int       ShortCondition();      //check conditions to open short position
   virtual int       LongCondition();       //check conditions to open long position
   virtual void      FillParameters();      //setting parameters of custom indicator
//--- sets period of CMO
   void              CMO_period( int passedvalue ){ m_cmo_period = passedvalue;}  
//--- sets shift of CMO
   void              CMO_Shift( int passedvalue ) { m_cmo_shift = passedvalue;}  
};


//+------------------------------------------------------------------+
//| setting parameters of custom indicator                           |
//| INPUT: none                                                      |
//| OUTPUT: none                                                     |
//| REMARK: none                                                     |
//+------------------------------------------------------------------+
void CChande_Momentum_Oscillator::FillParameters(void){
//--- 3 parameters
  ArrayResize(m_parameters, 3 );
//--- indicator name
  m_parameters[0].type         = TYPE_STRING;      
  m_parameters[0].string_value = INDICATOR_CMO_FILENAME; 
//--- CMO_period
  m_parameters[1].type         = TYPE_INT;      
  m_parameters[1].integer_value = m_cmo_period; 
//--- CMO_shift
  m_parameters[2].type         = TYPE_INT;      
  m_parameters[2].integer_value= m_cmo_shift; 
}

//+------------------------------------------------------------------+
//| Checks conditions to open short position                         |
//| INPUT:  None                                                     |
//| OUTPUT: Vote weight from 0 to 100                                |
//| REMARK: None.                                                    |
//+------------------------------------------------------------------+
int CChande_Momentum_Oscillator::ShortCondition(){
//--- the 0th buffer of CMO indicator is used
//--- checking of upward crossover of 50 level  
   if( m_indicator.GetData( 0, 1 ) > 50  && m_indicator.GetData(0, 2 )<= 50 )   return( 100 );
//--- condition is not satisfied
   return(0); 
}


//+------------------------------------------------------------------+
//| Checks conditions to open long position                         |
//| INPUT:  None                                                     |
//| OUTPUT: Vote weight from 0 to 100                                |
//| REMARK: None.                                                    |
//+------------------------------------------------------------------+
int CChande_Momentum_Oscillator::LongCondition(){
//--- the 0th buffer of CMO indicator is used
//--- checking of downward crossover of -50 level  
   if( m_indicator.GetData( 0, 1 ) < -50  && m_indicator.GetData(0, 2 )>= -50 )   return( 100 );
//--- condition is not satisfied
   return(0); 
}
//+------------------------------------------------------------------+