//+------------------------------------------------------------------+
//|                                                 tottiss_BRAR.mq5 |
//|                                                     qq 513394217 |
//|                           https://www.mql5.com/zh/users/tottiss/ |
//+------------------------------------------------------------------+
#property copyright "qq 513394217"
#property link      "https://www.mql5.com/zh/users/tottiss/"
#property version   "1.00"
#property indicator_separate_window
#property indicator_buffers 2
#property indicator_plots   2
//--- plot BR
#property indicator_label1  "BR"
#property indicator_type1   DRAW_LINE
#property indicator_color1  clrWhite
#property indicator_style1  STYLE_SOLID
#property indicator_width1  1
//--- plot AR
#property indicator_label2  "AR"
#property indicator_type2   DRAW_LINE
#property indicator_color2  clrYellow
#property indicator_style2  STYLE_SOLID
#property indicator_width2  1
//--- input parameters
input int      N=26;
//--- indicator buffers
double         BRBuffer[];
double         ARBuffer[];

//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int OnInit() {
//--- indicator buffers mapping
   SetIndexBuffer(0,BRBuffer,INDICATOR_DATA);
   SetIndexBuffer(1,ARBuffer,INDICATOR_DATA);
   PlotIndexSetInteger(0,PLOT_DRAW_BEGIN,N);
   PlotIndexSetInteger(1,PLOT_DRAW_BEGIN,N);
   ArraySetAsSeries(BRBuffer,true);
   ArraySetAsSeries(ARBuffer,true);
//---
   return(INIT_SUCCEEDED);
}
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int OnCalculate(const int rates_total,
                const int prev_calculated,
                const datetime &time[],
                const double &open[],
                const double &high[],
                const double &low[],
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[]) {
//---
   ArraySetAsSeries(close,true);
   ArraySetAsSeries(high,true);
   ArraySetAsSeries(low,true);
   ArraySetAsSeries(open,true);
   int i,j,limit=0;
   double sum1,sum2,sum3,sum4;
   if(rates_total<=0)return(0);
   if(prev_calculated<=0)limit=rates_total-1;
   else limit = rates_total - prev_calculated +1;
   for(i=limit; i>=0 && !IsStopped(); i--) {
      if(i>rates_total-1-N) continue;
      sum1=sum2=sum3=sum4=0;
      for(j=i-1+N; j>=i; j--) {
         sum1+=MathMax(0.0,high[j]-close[j+1]);
         sum2+=MathMax(0.0,close[j+1]-low[j]);
         sum3+=(high[j]-open[j]);
         sum4+=(open[j]-low[j]);
      }

      BRBuffer[i]=sum1/sum2*100;
      ARBuffer[i]=sum3/sum4*100;
   }

//--- return value of prev_calculated for next call
   return(rates_total);
}
//+------------------------------------------------------------------+
