//+------------------------------------------------------------------+
//|                                                   AmelyClose.mq4 |
//|                        Copyright 2021, MetaQuotes Software Corp. |
//|                                             https://www.mql5.com |
//+------------------------------------------------------------------+
#property copyright "Copyright 2021, MetaQuotes Software Corp."
#property link      "https://www.mql5.com"
#property version   "1.00"
#property strict
//+------------------------------------------------------------------+
//| Expert initialization function                                   |
//+------------------------------------------------------------------+
int OnInit()
  {
//--- create timer
   EventSetTimer(1);

//---
   return(INIT_SUCCEEDED);
  }
//+------------------------------------------------------------------+
//| Expert deinitialization function                                 |
//+------------------------------------------------------------------+
void OnDeinit(const int reason)
  {
//--- destroy timer
   EventKillTimer();

  }
//+------------------------------------------------------------------+
//| Expert tick function                                             |
//+------------------------------------------------------------------+
void OnTick()
  {
//---

  }
//+------------------------------------------------------------------+
//| Timer function                                                   |
//+------------------------------------------------------------------+
void OnTimer()
  {
//---
   int total = OrdersTotal();
   string req = "";
   if(total > 0)
     {
      for(int pos = 0; pos < total; pos++)
        {
         if(OrderSelect(pos,SELECT_BY_POS) == false)
           {
            continue;
           }
         else
           {
            if(StringLen(OrderComment()) > 0)
              {
               string orderSignal = StringSubstr(OrderComment(),0,StringLen(OrderComment())-9);
               StringAdd(req,orderSignal+",");
              }
           }
        }
      string rep = resp(req);
      if(StringLen(rep) > 0)
        {
         for(int pos = 0; pos < total; pos++)
           {
            OrderSelect(pos, SELECT_BY_POS, MODE_TRADES);
            if(StringLen(OrderComment()) > 0)
              {
               string orderSignal = StringSubstr(OrderComment(),0,StringLen(OrderComment())-9);
               if(StringFind(rep,orderSignal,0))
                 {
                  if(OrderType()==OP_SELL)
                    {
                     OrderClose(OrderTicket(),OrderLots(),Ask,3,CLR_NONE);
                    }
                  if(OrderType()==OP_BUY)
                    {
                     OrderClose(OrderTicket(),OrderLots(),Bid,3,CLR_NONE);
                    }
                 }
              }
           }
        }
     }
  }
//+------------------------------------------------------------------+
string resp(string tickets)
  {
   string method  = "GET";
   string url     = "https://amely.jjkeeper.com/gainer/getTickets?tickets="+tickets;
   string headers = NULL;
   char   data[],
          result[];
   int res = WebRequest(method,url,headers,500,data,result,headers);
   Print(res);
   return CharArrayToString(result,0,ArraySize(result),"CP_ACP");
  }
//+------------------------------------------------------------------+

