//+------------------------------------------------------------------+ 
//|                                                     RSI_2HTF.mq5 | 
//|                                         Copyright  2006, lukas1 | 
//|                                                                  | 
//+------------------------------------------------------------------+ 
#property copyright "Copyright  2006, lukas1"
#property link ""
//---   
#property version   "1.60"
#property description "    RSI      ."
//---     
#property indicator_separate_window
//---    2
#property indicator_buffers 2 
//---     
#property indicator_plots   1
//+-------------------------------------+
//|                   |
//+-------------------------------------+
#define RESET 0               //        
#define INDICATOR_NAME "RSI"  //    
#define SIZE 2                //      CountIndicator 
//+-------------------------------------+
//|         |
//+-------------------------------------+
//---      
#property indicator_type1   DRAW_FILLING
//---     
#property indicator_color1  clrTeal,clrMagenta
//---   
#property indicator_label1  "RSI_2HTF"
//+-------------------------------------+
//|           |
//+-------------------------------------+ 
input ENUM_TIMEFRAMES TimeFrame1=PERIOD_H2;      //    1 ( )
input uint                 RSIPeriod1=7;
input ENUM_APPLIED_PRICE   RSIPrice1=PRICE_CLOSE;
input ENUM_TIMEFRAMES TimeFrame2=PERIOD_H4;      //    2 ( )
input uint                 RSIPeriod2=7;
input ENUM_APPLIED_PRICE   RSIPrice2=PRICE_CLOSE;
input int                  Shift=0;              //      
//+-------------------------------------+ 
//---   ,   
//---      
double Ind1Buffer[];
double Ind2Buffer[];
//---      
int min_rates_total;
//---      
int Ind1_Handle,Ind2_Handle;
//+------------------------------------------------------------------+
//|                                    |
//+------------------------------------------------------------------+
string GetStringTimeframe(ENUM_TIMEFRAMES timeframe)
  {return(StringSubstr(EnumToString(timeframe),7,-1));}
//+------------------------------------------------------------------+    
//| Custom indicator initialization function                         | 
//+------------------------------------------------------------------+  
int OnInit()
  {
//---     
   if(!TimeFramesCheck(INDICATOR_NAME,TimeFrame1,TimeFrame2)) return(INIT_FAILED);
//---   
   min_rates_total=2;
//---    RSI 1
   Ind1_Handle=iRSI(Symbol(),TimeFrame1,RSIPeriod1,RSIPrice1);
   if(Ind1_Handle==INVALID_HANDLE)
     {
      Print("      RSI 1");
      return(INIT_FAILED);
     }
//---    RSI 2
   Ind2_Handle=iRSI(Symbol(),TimeFrame2,RSIPeriod2,RSIPrice2);
   if(Ind2_Handle==INVALID_HANDLE)
     {
      Print("      RSI 2");
      return(INIT_FAILED);
     }
//---   
   IndInit(0,Ind1Buffer);
   IndInit(1,Ind2Buffer);
   PlotInit(0,0.0,min_rates_total,Shift);
//---           
   string shortname;
   StringConcatenate(shortname,INDICATOR_NAME,"(",GetStringTimeframe(TimeFrame1),", ",GetStringTimeframe(TimeFrame2),")");
//---
   IndicatorSetString(INDICATOR_SHORTNAME,shortname);
//---     
   IndicatorSetInteger(INDICATOR_DIGITS,_Digits);
//---  
   return(INIT_SUCCEEDED);
  }
//+------------------------------------------------------------------+  
//| Custom iteration function                                        | 
//+------------------------------------------------------------------+  
int OnCalculate(const int rates_total,    //       
                const int prev_calculated,//       
                const datetime &time[],
                const double &open[],
                const double &high[],
                const double &low[],
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[])
  {
//---       
   if(rates_total<min_rates_total) return(RESET);
   if(BarsCalculated(Ind1_Handle)<Bars(Symbol(),TimeFrame1)) return(prev_calculated);
   if(BarsCalculated(Ind2_Handle)<Bars(Symbol(),TimeFrame2)) return(prev_calculated);
//---         
   ArraySetAsSeries(time,true);
//---
   if(!CountIndicator(0,NULL,TimeFrame1,Ind1_Handle,0,Ind1Buffer,time,rates_total,prev_calculated,min_rates_total)) return(RESET);
   if(!CountIndicator(1,NULL,TimeFrame2,Ind2_Handle,0,Ind2Buffer,time,rates_total,prev_calculated,min_rates_total)) return(RESET);
//---     
   return(rates_total);
  }
//+------------------------------------------------------------------+
//|                                  |
//+------------------------------------------------------------------+    
void IndInit(int Number,double &Buffer[])
  {
//---      
   SetIndexBuffer(Number,Buffer,INDICATOR_DATA);
//---       
   ArraySetAsSeries(Buffer,true);
  }
//+------------------------------------------------------------------+
//|                                  |
//+------------------------------------------------------------------+    
void PlotInit(int Number,double Empty_Value,int Draw_Begin,int nShift)
  {
//---      
   PlotIndexSetInteger(Number,PLOT_DRAW_BEGIN,Draw_Begin);
//---   ,      
   PlotIndexSetDouble(Number,PLOT_EMPTY_VALUE,Empty_Value);
//---    2    Shift
   PlotIndexSetInteger(Number,PLOT_SHIFT,nShift);
  }
//+------------------------------------------------------------------+
//| CountLine                                                        |
//+------------------------------------------------------------------+
bool CountIndicator(uint     Numb,            //   CountLine      (  - 0)
                    string   Symb,            //  
                    ENUM_TIMEFRAMES TFrame,   //  
                    int      IndHandle,       //   
                    uint     BuffNumb,        //    
                    double&  IndBuf[],        //   
                    const datetime& iTime[],  //  
                    const int Rates_Total,    //       
                    const int Prev_Calculated,//       
                    const int Min_Rates_Total)//       
  {
//---
   static int LastCountBar[SIZE];
   datetime IndTime[1];
   int limit;
//---     
//---    limit    
   if(Prev_Calculated>Rates_Total || Prev_Calculated<=0)//      
     {
      limit=Rates_Total-Min_Rates_Total-1; //      
      LastCountBar[Numb]=limit;
     }
   else limit=LastCountBar[Numb]+Rates_Total-Prev_Calculated; //       
//---    
   for(int bar=limit; bar>=0 && !IsStopped(); bar--)
     {
      //---      
      IndBuf[bar]=0.0;
      //---       IndTime
      if(CopyTime(Symbol(),TFrame,iTime[bar],1,IndTime)<=0) return(RESET);
      //---
      if(iTime[bar]>=IndTime[0] && iTime[bar+1]<IndTime[0])
        {
         LastCountBar[Numb]=bar;
         double Arr[1];
         //---       Arr
         if(CopyBuffer(IndHandle,BuffNumb,iTime[bar],1,Arr)<=0) return(RESET);
         IndBuf[bar]=Arr[0];
        }
      else IndBuf[bar]=IndBuf[bar+1];
     }
//---     
   return(true);
  }
//+------------------------------------------------------------------+
//| TimeFramesCheck()                                                |
//+------------------------------------------------------------------+    
bool TimeFramesCheck(string IndName,
                     ENUM_TIMEFRAMES TFrame1, //   1 ( )
                     ENUM_TIMEFRAMES TFrame2) //   3 ( )
  {
//---     
   if(TFrame1<Period() && TFrame1!=PERIOD_CURRENT)
     {
      Print("  1   "+IndName+"       !");
      Print("    !");
      return(RESET);
     }

   if(TFrame2<=TFrame1)
     {
      Print("  2   "+IndName+"      1!");
      Print("    !");
      return(RESET);
     }
//---
   return(true);
  }
//+------------------------------------------------------------------+
