//+------------------------------------------------------------------+
//|                                                  OptimReport.mqh |
//|                                                            v2.15 |
//|                 Copyright Shurik740, Gemera-Trade Software Corp. |
//+------------------------------------------------------------------+

/*
#include <OptimReport.mqh>
*/

/* 
   OtimReport(1); // add this line to OnInit() function of your EA
*/

/* 
   OtimReport(2);  // add this line to OnTick() function of your EA
*/

/* 
   OtimReport(3); // add this line to the code when trade operations of your EA
*/

/* This function returns the value when "Custom max" parameter is optimized
double OnTester()
  {
   OtimReport(4);
   Input_Param="input";
   if(Crt_HTML) Sort_HTML_Ar();
   return(Vigoda);
  }
*/

// Global variables
//----
double   Vigoda,// Vigoda parameter (greater values better)
ProcDay,// Daily profit in percents
ProcSd,// Profit percentage per deal
SdDay,// Deals (day)
Prib,// Profit
SrDWo,// Average drawdown 
MxDw,// Maximal drawdown
PipMin,// Pips per minute (for open positions)
SA_PipMin,// Pips per minute
MaxDWo, // Relative drawdown (balance)
MaxDwb, // Maximal drawdown (balance)
MDwSd, // Maximal drawdown of the current deal
Ust, // Recovery factor
PrFak, // Profit Factor
AllDays, // Days in period
Sdelki, // Total deals
PipOrd,   // Average pios per deal
Bal_MaxG, // Maximal slope of the balance line (points/minute)
Bal_MinG, // Minimal slope of the balance line (points/minute)
Bal_Grad, // Difference between the maximal and minimal (Slope)
Bal_Chan, // Maximal width for slope calculation channel (in pips)
CurGrChan,// Balance slope (points/minutes)
PipSum,PM_time_sum,PM_time_begin,// variable for PipMin calculation
Bal_begin,Bal_end,Bal_max,Bal_min,
SdProfit,SdLoss,Profit,Loss,Eq,Sum_MDw,N_Prohoda,
PipVol[],PipMaxG,PipMinG,
HTML_Ar[100][22];


int  handle,han,Sch_MDw,BalPrib_B,BalPrib_S,Days,Pos_Total;
long ID;
datetime End_Day,Begin_Day,TF_min;
string Input_Param,HTML_ArStr[100];
input string expert_name="Exp"; // Expert Name
input ENUM_TIMEFRAMES TF_opt=PERIOD_M1; // Timeframe
input int Formula=5; // Used formula
input double Sd_Ned=10; // Minumum deal/week
input int MaxDW=40; // Max. drawdown (%)
input int PribSd=30; // Min. profitable deals (%)
input double Lot_Risk=10; // Margin use (%) 
input bool Crt_HTML=true; // Create HTML file
input bool Publ; // Publish on FTP
input int ChanOrd=20; // Balance channel length (in deals)
MqlDateTime str1;

// Prepare table headers
string Header[17];
// Prepare table contents
string Content[100][17]; // rows | columns

//+------------------------------------------------------------------+
//|    Calculate Percent per day or per deal dependent on range      |
//+------------------------------------------------------------------+

double Procent(double Days_Sdelki,double bal_begin,double bal_end)
  {
   if(Days_Sdelki>1 && bal_begin!=0) return((MathExp(((1/Days_Sdelki)*(MathLog10(bal_end/bal_begin))))-1)*100);
   else return(0);
  }
//+------------------------------------------------------------------+
void OtimReport(int Mode)
  {
   if(MQL5InfoInteger(MQL5_TESTING))
     {
      double Risk=Lot_Risk; // Lot_Risk is a percent of used margin (for variable lot) 
      string smb=Symbol();
      if(Mode==1) //  OnInit()
        {
         AllDays=1;
         Bal_begin=AccountInfoDouble(ACCOUNT_BALANCE);
         TimeCurrent(str1);
         Days=str1.day_of_year;
         Begin_Day=TimeCurrent();
         Eq=AccountInfoDouble(ACCOUNT_BALANCE);
         TF_min=(PeriodSeconds(TF_opt)/60);
         ArrayResize(PipVol,ChanOrd,0);
         if(MQL5InfoInteger(MQL5_OPTIMIZATION))
           {
            handle=FileOpen(smb+"_"+expert_name+"_html.OA",FILE_READ|FILE_BIN);
            if(handle>0)
              {
               han=FileReadArray(handle,HTML_Ar,0,3000);
               FileClose(handle);
              }
            handle=FileOpen(smb+"_"+expert_name+"_html.PR",FILE_READ|FILE_TXT);
            if(handle>0)
              {
               han=FileReadArray(handle,HTML_ArStr,0,100);
               FileClose(handle);
              }
            if(GlobalVariableCheck("OptProh")) N_Prohoda=GlobalVariableGet("OptProh");
           }
        }
      //+------------------------------------------------------------------+
      if(Mode==2) //  OnTick()
        {
         TimeCurrent(str1);
         if(Days!=str1.day_of_year) {Days=str1.day_of_year; AllDays++;}                           // Trade days
         if(AccountInfoDouble(ACCOUNT_BALANCE)>Eq) {Profit+=AccountInfoDouble(ACCOUNT_BALANCE)-Eq; Eq=AccountInfoDouble(ACCOUNT_BALANCE); SdProfit++;} // Calculate profit and profitable deals
         if(AccountInfoDouble(ACCOUNT_BALANCE)<Eq) {Loss+=AccountInfoDouble(ACCOUNT_BALANCE)-Eq;   Eq=AccountInfoDouble(ACCOUNT_BALANCE); SdLoss++;}   // Calculate loss and loss deals
         //----
         if(AccountInfoDouble(ACCOUNT_EQUITY)>Bal_max) {Bal_max=AccountInfoDouble(ACCOUNT_EQUITY); Bal_min=0;}
         if(AccountInfoDouble(ACCOUNT_EQUITY)<Bal_min|| Bal_min==0) Bal_min=AccountInfoDouble(ACCOUNT_EQUITY);
         if(Bal_max!=0 && Bal_min!=0)
           {
            if(MaxDWo<(100*((Bal_max-Bal_min)/Bal_max))) MaxDWo=100*((Bal_max-Bal_min)/Bal_max);
            if((Bal_max-Bal_min)>MaxDwb) MaxDwb=Bal_max-Bal_min;
           }
         //----
         if(Pos_Total!=PositionsTotal())
           {
            HistorySelect(0,TimeCurrent());
            int deals=HistoryDealsTotal();
            ulong deal_ticket;
            for(int i=0;i<deals;i++)
              {
               deal_ticket=HistoryDealGetTicket(i);
               if(HistoryDealGetInteger(deal_ticket,DEAL_TIME)==ID)
                 {
                  deal_ticket=HistoryDealGetTicket(i+1);
                  PipSum+=(HistoryDealGetDouble(deal_ticket,DEAL_PROFIT)/HistoryDealGetDouble(deal_ticket,DEAL_VOLUME));
                  PM_time_sum+=(Bars(_Symbol,TF_opt)-PM_time_begin);
                  if((Bars(_Symbol,TF_opt)-PM_time_begin)>0)
                     SA_PipMin+=((HistoryDealGetDouble(deal_ticket,DEAL_PROFIT)/HistoryDealGetDouble(deal_ticket,DEAL_VOLUME))/(Bars(_Symbol,TF_opt)-PM_time_begin));
                  PM_time_begin=0;
                  ID=0;
                  Pos_Total=PositionsTotal();
                  Sum_MDw+=MDwSd; Sch_MDw++; MDwSd=0;
                  for(int pg=ChanOrd-1;pg>=1;pg--) PipVol[pg]=PipVol[pg-1]; PipVol[0]=PipSum;
                  if(deals>=ChanOrd)
                    {
                     PipMaxG=0; PipMinG=0;
                     CurGrChan=(PipVol[0]-PipVol[ChanOrd-1])/ChanOrd; // current balance channel slope
                     if((Bal_MaxG<CurGrChan) || (Bal_MaxG==0)) Bal_MaxG=CurGrChan;
                     if((Bal_MinG>CurGrChan) || (Bal_MinG==0)) Bal_MinG=CurGrChan;
                     for(int pg=ChanOrd-1;pg>=1;pg--)
                       {
                        double curg=(PipVol[pg]-PipVol[ChanOrd-1])-((ChanOrd-pg)*CurGrChan);
                        if((PipMaxG<curg) || (PipMaxG==0)) PipMaxG=curg;
                        if((PipMinG>curg) || (PipMinG==0)) PipMinG=curg;
                        if(Bal_Chan<(PipMaxG-PipMinG)) Bal_Chan=(PipMaxG-PipMinG);
                       }
                    }
                 }
              }
           }
         if(PositionSelect(_Symbol))
           {
            if(PositionGetDouble(POSITION_PROFIT)<0)
              {
               if(MDwSd<((MathAbs(PositionGetDouble(POSITION_PROFIT))/Eq)*100)) MDwSd=((MathAbs(PositionGetDouble(POSITION_PROFIT))/Eq)*100);
              }
           }
        }
//---
      if(Mode==3) // Order Open
        {
         Sdelki++;
         Pos_Total=PositionsTotal();
         PM_time_begin=Bars(_Symbol,TF_opt);
         if(PositionSelect(Symbol())) ID=PositionGetInteger(POSITION_TIME);
         else ID=0;
        }
//---
      if(Mode==4 && Sdelki>0) // OnTester()
        {
         End_Day=TimeCurrent();
         Bal_end=AccountInfoDouble(ACCOUNT_EQUITY);
         AllDays++;
         Prib=(Bal_end-Bal_begin);                                // Profit
         ProcDay=Procent(AllDays,Bal_begin,Bal_end);              // Daily profit (%)
         ProcSd=Procent(Sdelki,Bal_begin,Bal_end);                // Profit per deal (%)
         Bal_Grad=Bal_MaxG-Bal_MinG;                              // Balance channel deviation
         if(PM_time_sum!=0) PipMin=PipSum/(PM_time_sum*TF_min);   // Pips per minute
         if(Sdelki>0)
           {
            SA_PipMin/=Sdelki;                           // Pips per minute (averaged)
            PipOrd=PipSum/Sdelki;                        // Pips per deal (averaged)
           }
         if(AllDays!=0) SdDay=Sdelki/AllDays;                     // Deals per day (averaged)
         if(Sch_MDw!=0) SrDWo=Sum_MDw/Sch_MDw;                    // Deal drawdown (averaged)
         if(MaxDwb!=0) Ust=Prib/MaxDwb;                           // Recovery factor
         if(Loss==0 && Profit>0) PrFak=10;
         else PrFak=Profit/(Loss*(-1));
         if(PrFak==0 && Profit>0) PrFak=10;
         if(Formula==1)
            if((SdDay*5)>Sd_Ned && MaxDWo>5 && MaxDWo<MaxDW && ((SdProfit/Sdelki)*100)>PribSd)
              {
               if(PrFak>=3) Vigoda=2*(SdDay*TF_min)+(PipMin*10)+(Ust/20)+(((ProcDay*300)/Risk)/(MaxDWo+(SrDWo*10)-10));
               else Vigoda=(PrFak-1)*(SdDay*TF_min)+(PipMin*10)+(Ust/20)+(((ProcDay*300)/Risk)/(MaxDWo+(SrDWo*10)-10));
              }
         if(Formula==2)
           {
            if(PrFak>=3) Vigoda=2*(SdDay*TF_min);
            else Vigoda=(PrFak-1)*(SdDay*TF_min);
           }
         if(Formula==3)
           {
            Vigoda=(PipMin*10)*(SdDay*TF_min);
           }
         if(Formula==4)
           {
            if(PrFak>=2) Vigoda=(2*SdDay)+((SdProfit/Sdelki)*PipMin*SdDay);
            else
              {
               if(PrFak>=1) Vigoda=(PrFak*SdDay)+((SdProfit/Sdelki)*PipMin*SdDay*(PrFak-1));
               else Vigoda=(SdProfit/Sdelki)*PrFak*SdDay;
              }
            Vigoda*=10;
           }
         if(Formula==5)
           {
            if(PrFak>=2)
              {
               Vigoda=SdDay;
               Vigoda+=((SdProfit/Sdelki)*PipMin*SdDay);
               Vigoda+=(((ProcDay*100)/Risk)/(MaxDWo+(SrDWo*10)-10));
               Vigoda*=10;
              }
            else
              {
               if(PrFak>=1)
                 {
                  Vigoda=SdDay*(PrFak-1);
                  Vigoda+=((SdProfit/Sdelki)*PipMin*SdDay*(PrFak-1));
                  Vigoda+=(((ProcDay*100)/Risk)/(MaxDWo+(SrDWo*10)-10));
                  Vigoda*=10;
                 }
               else Vigoda=(SdProfit/Sdelki)*PrFak*SdDay;
              }
           }
         if(Formula==6)
           {
            if((SdDay*5)>Sd_Ned)
              {
               Vigoda=PrFak*(((SdDay/5)*TF_min));
               Vigoda+=(PipMin*SdDay);
               Vigoda+=(3*(((ProcDay*100)/Risk)/(MaxDWo+(SrDWo*10)-10)));
               if(PrFak>1)
                 {
                  Vigoda+=(PrFak*((1.5-((Bal_Chan-PipMinG)/4000))+(1.0-((Bal_Grad-Bal_MinG)/400))+(Ust/10)));
                 }
              }
            else Vigoda=PrFak*(((SdDay/5)*TF_min));
           }
         if(!MQL5InfoInteger(MQL5_OPTIMIZATION))
           {
            Print("Testing period: "+TimeToString(Begin_Day)+" >>> "+TimeToString(End_Day));
            Print("Days: "+DoubleToString(AllDays,0));
            Print("Initial balance: "+DoubleToString(Bal_begin,0));
            Print("Total Profit: "+DoubleToString(Profit,0));
            Print("Total Loss: "+DoubleToString(Loss,0));
            Print("Recovery factor: "+DoubleToString(Ust,2));
            Print("Loss deals: "+DoubleToString(SdLoss,0)+" ("+DoubleToString((SdLoss/Sdelki)*100,0)+" %)");
            Print("Profitable deals: "+DoubleToString(SdProfit,0)+" ("+DoubleToString((SdProfit/Sdelki)*100,0)+" %)");
            Print("Total deals: "+DoubleToString(Sdelki,0));
            Print("Deals per week: "+DoubleToString(SdDay*5,2));
            Print("Profit per deal in percents: "+DoubleToString(ProcSd,2)+" %");
            Print("Profit per day in percents: "+DoubleToString(ProcDay,2)+" %");
            Print("SrDW: "+DoubleToString(SrDWo,2)+" percents   of "+DoubleToString(Sch_MDw,0));
            Print("MaxDW: "+DoubleToString(MaxDWo,2)+" percents   $: "+DoubleToString(MaxDwb,2));
            Print("PipMin: "+DoubleToString(PipMin,3));
            Print("SA_PipMin: "+DoubleToString(SA_PipMin,3));
            Print("Points per deal: "+DoubleToString(PipOrd,3));
            Print("Pip_MinG: "+DoubleToString(PipMinG,2),"   Pip_MaxG: "+DoubleToString(PipMaxG,2));
            Print("Bal_MinG: "+DoubleToString(Bal_MinG,2),"   Bal_MaxG: "+DoubleToString(Bal_MaxG,2));
            Print("Bal_Grad: "+DoubleToString(Bal_Grad,2),"   Bal_Chan: "+DoubleToString(Bal_Chan,2));
            Print("Profit: "+DoubleToString(Prib,0));
            Print("PF: "+DoubleToString(PrFak,2));
            Print("Vigoda: "+DoubleToString(Vigoda,2));
           }
        }
     }
  }
//+------------------------------------------------------------------+
//|             Write results for HTML report                        |
//+------------------------------------------------------------------+
bool Sort_HTML_Ar()
  {
   int k,s,x;
   string smb=Symbol();
   if(Vigoda!=0 && MQL5InfoInteger(MQL5_OPTIMIZATION))//
     {
      //GlobalVariableSet("OptProh",N_Prohoda+1);
      for(x=0;x<=99;x++)
        {
         if(Vigoda==HTML_Ar[x][1]) return(false);
         if((Vigoda>HTML_Ar[x][1])
            || (HTML_Ar[x][1]==0))
           {
            for(s=99;s>x;s--)
              {
               for(k=0;k<=21;k++) HTML_Ar[s][k]=HTML_Ar[s-1][k];
               HTML_ArStr[s]=HTML_ArStr[s-1];
              }
            HTML_Ar[x][0]=GlobalVariableGet("OptProh");
            HTML_Ar[x][1]=Vigoda;
            HTML_Ar[x][2]=Prib;
            HTML_Ar[x][3]=PipMin;
            HTML_Ar[x][4]=SA_PipMin;
            HTML_Ar[x][5]=Sdelki;
            HTML_Ar[x][6]=SdProfit;
            HTML_Ar[x][7]=(SdProfit/Sdelki)*100;
            HTML_Ar[x][8]=SdLoss;
            HTML_Ar[x][9]=(SdLoss/Sdelki)*100;
            HTML_Ar[x][10]=PrFak;
            HTML_Ar[x][11]=ProcDay;
            HTML_Ar[x][12]=ProcSd;
            HTML_Ar[x][13]=SdDay;
            HTML_Ar[x][14]=SrDWo;
            HTML_Ar[x][15]=MaxDWo;
            HTML_Ar[x][16]=Bal_Chan;
            HTML_Ar[x][17]=Bal_Grad;
            HTML_Ar[x][18]=Bal_MinG;
            HTML_Ar[x][19]=PipMinG;
            HTML_Ar[x][20]=Ust;
            HTML_Ar[x][21]=PipOrd;
            HTML_ArStr[x]=Input_Param;
            handle=FileOpen(smb+"_"+expert_name+"_html.OA",FILE_WRITE|FILE_BIN);
            if(handle!=INVALID_HANDLE)
              {
               han=FileWriteArray(handle,HTML_Ar,0,3000);
               FileClose(handle);
              }
            else Print("FileOpen failed, error ",GetLastError());
            handle=FileOpen(smb+"_"+expert_name+"_html.PR",FILE_WRITE|FILE_TXT);
            if(handle!=INVALID_HANDLE)
              {
               han=FileWriteArray(handle,HTML_ArStr,0,100);
               FileClose(handle);
              }
            else Print("FileOpen failed, error ",GetLastError());
            x=100;
            Report_HTML();
           }
        }
     }
   return(true);
  }
//+------------------------------------------------------------------+
//|                     Create HTML report                           |
//+------------------------------------------------------------------+
void Report_HTML()
  {
   string smb=Symbol();
   int s;
   if(MQL5InfoInteger(MQL5_OPTIMIZATION))
     {
   //---- Prepare header
      Header[0]="Vigoda";
      Header[1]="Profit";
      Header[2]="PF"; // Profit factor
      Header[3]="Max DW"; // Maximal drawdown
      Header[4]="Sr. DWo"; // Average Drawdown
      Header[5]="PipOrd"; // Average pips per deal
      Header[6]="PipMin";
      Header[7]="SA PM"; // Averaged PipMin
      Header[8]="Ust.";  // Profit/Drawdown $ (Recovery factor)
      Header[9]="Deals (Week)";
      Header[10]="% (+)";
      Header[11]="% (-)";
      Header[12]="%/day ";
      Header[13]="%/ord";
      Header[14]="Bal Chan";  //
      Header[15]="Bal Grad";  //
      Header[16]="Input Parameters";
   
   //--- Prepare an array with table content 
      for(s=0;s<100;s++)
        {
         Content[s][0]=DoubleToString(HTML_Ar[s][1],2);
         Content[s][1]=DoubleToString(HTML_Ar[s][2],2);
         Content[s][2]=DoubleToString(HTML_Ar[s][10],2);
         Content[s][3]=DoubleToString(HTML_Ar[s][15],2)+"%";
         Content[s][4]=DoubleToString(HTML_Ar[s][14],2)+"%";
         Content[s][5]=DoubleToString(HTML_Ar[s][21],0)+"p";
         Content[s][6]=DoubleToString(HTML_Ar[s][3],2);
         Content[s][7]=DoubleToString(HTML_Ar[s][4],2);
         Content[s][8]=DoubleToString(HTML_Ar[s][20],2);
         Content[s][9]=DoubleToString(HTML_Ar[s][5],0)+" ("+DoubleToString(HTML_Ar[s][13]*5,1)+")";
         Content[s][10]=DoubleToString(HTML_Ar[s][7],0)+"% ("+DoubleToString(HTML_Ar[s][6],0)+")";
         Content[s][11]=DoubleToString(HTML_Ar[s][9],0)+"% ("+DoubleToString(HTML_Ar[s][8],0)+")";
         Content[s][12]=DoubleToString(HTML_Ar[s][11],2)+"%";
         Content[s][13]=DoubleToString(HTML_Ar[s][12],2)+"%";
         Content[s][14]=DoubleToString(HTML_Ar[s][16],0)+" ("+DoubleToString(HTML_Ar[s][19],0)+")";
         Content[s][15]=DoubleToString(HTML_Ar[s][17],0)+" ("+DoubleToString(HTML_Ar[s][18],0)+")";
         Content[s][16]=HTML_ArStr[s];
        }
      string str=cr_HTML_Table(); // Create table
   //--- Save file
      int h=FileOpen(smb+"_"+expert_name+".htm",FILE_WRITE|FILE_TXT);
      if(h!=INVALID_HANDLE)
        {
         FileWrite(h,str);
   //--- Send file to ftp server
         if(Publ==true) SendFTP(smb+"_"+expert_name+".htm","ftp.gemera.ru");
         FileClose(h);
        }
      else Print("FileOpen error, error no ",GetLastError());
     }
  }
//+------------------------------------------------------------------+
//|               Creates the file with HTML table                   |
//+------------------------------------------------------------------+
string cr_HTML_Table()
  {
   bool     aLeftBold         =  true;             // Left column Bold
   bool     aHeaderFlag       =  true;             // Header. If the header isn't needed, you have to allocate memory for aHeader array
   bool     aColorAltFlag     =  true;             // Rows with different colors
   string   aFontFace         =  "Tahoma";         // Font
   int      aFontSize         =  2;                // Font size
   int      aBorderSize       =  0;                // Border size
   int      aCellPadding      =  4;                // Cell padding
   int      aCellSpacing      =  1;                // Cell spacing
   string   aFontColor        =  "#FFFFFF";        // Font color
   string   aBorderColor      =  "#FFFFFF";        // Border color
   string   aHeaderColor      =  "#2A3A6D";        // Header color
   string   aRowColor_1       =  "#808BA7";        // Row color 1
   string   aRowColor_2       =  "#ADB2C6";        // Row color 2
   int tj,ti;
   string   tRetStr="<html><head><title>"+expert_name+"</title></head><body><div>";
   tRetStr=tRetStr+"<table border=1 bordercolor="+aHeaderColor+" cellpadding=0 cellspacing=0><tr><td>\n";
   tRetStr=tRetStr+"<table border="+IntegerToString(aBorderSize)+" bordercolor="+aBorderColor+" cellpadding="+IntegerToString(aCellPadding)+" cellspacing="+IntegerToString(aCellSpacing)+">\n";
   if(aHeaderFlag)
     {
      tRetStr=tRetStr+"<tr bgcolor="+aHeaderColor+">";
      for(tj=0;tj<ArraySize(Header);tj++)
        {
         tRetStr=tRetStr+"<td><b><p align=center><font face="+aFontFace+" size="+IntegerToString(aFontSize)+" color="+aFontColor+">"+Header[tj]+"</font></p></b></td>\n";
        }
      tRetStr=tRetStr+"</tr>\n";
     }
   string tColor=aRowColor_1;
   for(ti=0;ti<ArraySize(Content)/ArraySize(Header);ti++)
     {
      tRetStr=tRetStr+"<tr bgcolor="+tColor+">\n";
      for(tj=0;tj<ArraySize(Header);tj++)
        {
         string tStr=Content[ti][tj];
         if(tj==0)
           {
            if(aLeftBold)
              {
               tStr="<b>"+tStr+"</b>\n";
              }
           }
         tRetStr=tRetStr+"<td><p align=right><font face="+aFontFace+" size="+IntegerToString(aFontSize)+" color="+aFontColor+">"+tStr+"</font></p></td>\n";
        }
      tRetStr=tRetStr+"</tr>\n";
      if(aColorAltFlag)
        {
         if(tColor==aRowColor_1)
           {
            tColor=aRowColor_2;
           }
         else
           {
            tColor=aRowColor_1;
           }
        }
     }
   tRetStr=tRetStr+"</table></td></tr></table></div></body></html>\n";
   return(tRetStr);
  }
//+------------------------------------------------------------------+
