//+------------------------------------------------------------------+
//|                                                 i-FractalsEx.mq5 |
//|                                          Copyright  2007, RickD |
//|                                                   www.e2e-fx.net |
//+------------------------------------------------------------------+
//---  
#property copyright "Copyright  2007, RickD"
//---    
#property link      "www.e2e-fx.net"
//---   
#property version   "1.00"
//---     
#property indicator_chart_window 
//---        
#property indicator_buffers 2
//---    
#property indicator_plots   2
//+----------------------------------------------+
//|          |
//+----------------------------------------------+
//---   1   
#property indicator_type1   DRAW_ARROW
//---      HotPink 
#property indicator_color1  clrHotPink
//---    1  5
#property indicator_width1  5
//---    
#property indicator_label1  "Down Fractal"
//+----------------------------------------------+
//|           |
//+----------------------------------------------+
//---   2   
#property indicator_type2   DRAW_ARROW
//---      DodgerBlue 
#property indicator_color2  clrDodgerBlue
//---    2  5
#property indicator_width2  5
//---    
#property indicator_label2 "Up Fractal"
//+----------------------------------------------+
//|                            |
//+----------------------------------------------+
#define RESET 0 //        
//+----------------------------------------------+
//|                    |
//+----------------------------------------------+
input uint Fr_Period=6;     //   
input int  UpLabel=176;     //    
input int  DnLabel=176;     //    
//+----------------------------------------------+
//---   ,   
//---      
double DnBuffer[];
double UpBuffer[];
//---
int min_rates_total;
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int OnInit()
  {
//---    
   min_rates_total=int(Fr_Period+1+Fr_Period);
//---      
   SetIndexBuffer(0,DnBuffer,INDICATOR_DATA);
//---       1
   PlotIndexSetInteger(0,PLOT_DRAW_BEGIN,min_rates_total);
//---   
   PlotIndexSetInteger(0,PLOT_ARROW,UpLabel);
//---       
   ArraySetAsSeries(DnBuffer,true);
//---      
   PlotIndexSetDouble(0,PLOT_EMPTY_VALUE,EMPTY_VALUE);
//---      
   SetIndexBuffer(1,UpBuffer,INDICATOR_DATA);
//---       2
   PlotIndexSetInteger(1,PLOT_DRAW_BEGIN,min_rates_total);
//---   
   PlotIndexSetInteger(1,PLOT_ARROW,DnLabel);
//---       
   ArraySetAsSeries(UpBuffer,true);
//---      
   PlotIndexSetDouble(1,PLOT_EMPTY_VALUE,EMPTY_VALUE);
//---     
   IndicatorSetInteger(INDICATOR_DIGITS,_Digits);
//---         
   string short_name="i-FractalsEx";
   IndicatorSetString(INDICATOR_SHORTNAME,short_name);
//---  
   return(INIT_SUCCEEDED);
  }
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int OnCalculate(const int rates_total,
                const int prev_calculated,
                const datetime &time[],
                const double &open[],
                const double &high[],
                const double &low[],
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[])
  {
//---       
   if(rates_total<min_rates_total) return(RESET);
//---    
   int limit;
//---     
//---    limit    
   if(prev_calculated>rates_total || prev_calculated<=0)//      
     {
      limit=rates_total-min_rates_total-1; //      
     }
   else
     {
      limit=rates_total-prev_calculated+int(Fr_Period); //      
     }
//---         
   ArraySetAsSeries(high,true);
   ArraySetAsSeries(low,true);
//---    
   for(int bar=limit; bar>=0 && !IsStopped(); bar--)
     {
      UpBuffer[bar]=EMPTY_VALUE;
      DnBuffer[bar]=EMPTY_VALUE;
      if(is_upper_fr(rates_total,high,Fr_Period,bar)) UpBuffer[bar]=high[bar];
      if(is_lower_fr(rates_total,low,Fr_Period,bar)) DnBuffer[bar]=low[bar];
     }
//---     
   return(rates_total);
  }
//+------------------------------------------------------------------+
//| is_upper_fr                                                      |
//+------------------------------------------------------------------+
bool is_upper_fr(int Rates_Total,const double &High[],int period,int shift)
  {
//---
   if(shift+period >= Rates_Total || shift-period < 0) return (false);
   for(int iii=1; iii<=period; iii++)
     {
      if(High[shift] < High[shift+iii]) return (false);
      if(High[shift] < High[shift-iii]) return (false);
     }
//---
   return (true);
  }
//+------------------------------------------------------------------+
//| is_lower_fr                                                      |
//+------------------------------------------------------------------+
bool is_lower_fr(int Rates_Total,const double &Low[],int period,int shift)
  {
//---
   if(shift+period >= Rates_Total || shift-period < 0) return (false);
   for(int iii=1; iii<=period; iii++)
     {
      if(Low[shift] > Low[shift+iii]) return (false);
      if(Low[shift] > Low[shift-iii]) return (false);
     }
//---
   return (true);
  }
//+------------------------------------------------------------------+
