//+------------------------------------------------------------------+
//|                                            DynamicRS_Channel.mq5 |
//|                                 Copyright  2007, Nick A. Zhilin |
//|                                                  rebus58@mail.ru |
//+------------------------------------------------------------------+
//---  
#property copyright "Copyright  2007, Nick A. Zhilin"
//---    
#property link      "rebus58@mail.ru"
//---   
#property version   "1.00"
#property description ",   " 
//---     
#property indicator_chart_window 
//---       3 
#property indicator_buffers 3
//---     
#property indicator_plots   3
//+----------------------------------------------+ 
//|     1            |
//+----------------------------------------------+
//---     
#property indicator_type1   DRAW_LINE
//---   
#property indicator_label1  "DynamicRS Middle"
//---     
#property indicator_color1 clrDodgerBlue
//---   - 
#property indicator_style1  STYLE_SOLID
//---     2
#property indicator_width1  2
//+----------------------------------------------+ 
//|     2            |
//+----------------------------------------------+
//---     
#property indicator_type2   DRAW_LINE
//---   
#property indicator_label2  "DynamicRS Upper"
//---      
#property indicator_color2 clrRed
//---   - 
#property indicator_style2  STYLE_SOLID
//---     2
#property indicator_width2  2
//+----------------------------------------------+ 
//|    3             |
//+----------------------------------------------+
//---     
#property indicator_type3   DRAW_LINE
//---   
#property indicator_label3  "DynamicRS Lower"
//---      
#property indicator_color3 clrMediumSeaGreen
//---   - 
#property indicator_style3  STYLE_SOLID
//---     2
#property indicator_width3  2
//+----------------------------------------------+ 
//|                            |
//+----------------------------------------------+ 
#define RESET 0 //        
//+----------------------------------------------+ 
//|                    |
//+----------------------------------------------+ 
input uint Filter=150; // 
//+----------------------------------------------+
//---   ,   
//---      
double LowestBuffer[];
double HighestBuffer[];
double MiddleBuffer[];
//---
double dFilter;
//---      
int min_rates_total;
//+------------------------------------------------------------------+ 
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+ 
void OnInit()
  {
//---     
   min_rates_total=2;
   dFilter=Filter*_Point;
//---      
   SetIndexBuffer(0,MiddleBuffer,INDICATOR_DATA);
   SetIndexBuffer(1,LowestBuffer,INDICATOR_DATA);
   SetIndexBuffer(2,HighestBuffer,INDICATOR_DATA);
//---      
   PlotIndexSetDouble(0,PLOT_EMPTY_VALUE,0.0);
   PlotIndexSetDouble(1,PLOT_EMPTY_VALUE,0.0);
   PlotIndexSetDouble(2,PLOT_EMPTY_VALUE,0.0);
//---          
   ArraySetAsSeries(LowestBuffer,true);
   ArraySetAsSeries(HighestBuffer,true);
   ArraySetAsSeries(MiddleBuffer,true);
//---  ,    
   PlotIndexSetInteger(0,PLOT_DRAW_BEGIN,min_rates_total);
   PlotIndexSetInteger(1,PLOT_DRAW_BEGIN,min_rates_total);
   PlotIndexSetInteger(2,PLOT_DRAW_BEGIN,min_rates_total);
//---     
   IndicatorSetInteger(INDICATOR_DIGITS,_Digits);
//---         
   string shortname;
   StringConcatenate(shortname,"DynamicRS_Channel(",Filter,")");
   IndicatorSetString(INDICATOR_SHORTNAME,shortname);
//---   
  }
//+------------------------------------------------------------------+ 
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+ 
int OnCalculate(const int rates_total,
                const int prev_calculated,
                const datetime &time[],
                const double &open[],
                const double &high[],
                const double &low[],
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[])
  {
//---       
   if(rates_total<min_rates_total)return(RESET);
//---    
   int limit,bar;
   double;
//---    limit        
   if(prev_calculated>rates_total || prev_calculated<=0)//      
     {
      limit=rates_total-1-min_rates_total; //      
     }
   else
     {
      limit=rates_total-prev_calculated; //      
     }
//---        
   ArraySetAsSeries(high,true);
   ArraySetAsSeries(low,true);
//---     
   for(bar=limit; bar>=0 && !IsStopped(); bar--)
     {
      if(high[bar]<high[bar+1] &&  high[bar]<MiddleBuffer[bar+1]-dFilter) MiddleBuffer[bar]=high[bar];
      else if(low[bar]>low[bar+1]&& low[bar]>MiddleBuffer[bar+1]+dFilter) MiddleBuffer[bar]=low[bar];
      else MiddleBuffer[bar]=MiddleBuffer[bar+1];
      //---
      HighestBuffer[bar]=MiddleBuffer[bar]+dFilter;
      LowestBuffer[bar]=MiddleBuffer[bar]-dFilter;
     }
//---     
   return(rates_total);
  }
//+------------------------------------------------------------------+
