//+------------------------------------------------------------------+
//|                                                   MACDDouble.mq5 |
//|                   Copyright 2009-2017, MetaQuotes Software Corp. |
//|                                              http://www.mql5.com |
//+------------------------------------------------------------------+
#property copyright   "2009-2017, MetaQuotes Software Corp."
#property link        "http://www.mql5.com"
#property description "Moving Average of Oscillator Double Line"
#property description "MACD Double Line"
#include <MovingAverages.mqh>
//--- indicator settings
#property indicator_separate_window
#property indicator_buffers 7
#property indicator_plots   3
#property indicator_label1  "MACD"
#property indicator_type1   DRAW_COLOR_HISTOGRAM
#property indicator_color1  clrLime,clrRed
#property indicator_width1  3

#property indicator_label2  "DIF"
#property indicator_type2   DRAW_COLOR_LINE
#property indicator_color2  clrDodgerBlue,clrMagenta
#property indicator_style2  STYLE_SOLID
#property indicator_width2  2

#property indicator_label3  "DEA"
#property indicator_type3   DRAW_LINE
#property indicator_color3  clrYellow
#property indicator_style3  STYLE_DOT
#property indicator_width3  1


//--- input parameters
input int                InpFastEMAPeriod=12;         // Fast EMA period
input int                InpSlowEMAPeriod=26;         // Slow EMA period
input int                InpSignalSMAPeriod=9;        // Signal SMA period
input ENUM_APPLIED_PRICE InpAppliedPrice=PRICE_CLOSE; // Applied price
//--- indicator buffers
double                   ExtMACDBuffer[];
double                   ExtMACDColorBuffer[];
double                   ExtDifBuffer[];
double                   ExtDifColorBuffer[];
double                   ExtDeaBuffer[];
double                   ExtSignalBuffer[];
double                   ExtFastMaBuffer[];
double                   ExtSlowMaBuffer[];
//--- MA handles
int                      ExtFastMaHandle;
int                      ExtSlowMaHandle;
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
void OnInit()
  {
//--- indicator buffers mapping
   SetIndexBuffer(0,ExtMACDBuffer,INDICATOR_DATA);
   SetIndexBuffer(1,ExtMACDColorBuffer,INDICATOR_COLOR_INDEX);
   SetIndexBuffer(2,ExtDifBuffer,INDICATOR_DATA);
   SetIndexBuffer(3,ExtDifColorBuffer,INDICATOR_COLOR_INDEX);
   SetIndexBuffer(4,ExtDeaBuffer,INDICATOR_DATA);
   SetIndexBuffer(5,ExtFastMaBuffer,INDICATOR_CALCULATIONS);
   SetIndexBuffer(6,ExtSlowMaBuffer,INDICATOR_CALCULATIONS);
   IndicatorSetInteger(INDICATOR_DIGITS,_Digits+2);
//--- sets first bar from what index will be drawn
   PlotIndexSetInteger(0,PLOT_DRAW_BEGIN,InpSlowEMAPeriod+InpSignalSMAPeriod-2);
//--- name for DataWindow and indicator subwindow label
   IndicatorSetString(INDICATOR_SHORTNAME,"MACD Double Line("+string(InpFastEMAPeriod)+","+string(InpSlowEMAPeriod)+","+string(InpSignalSMAPeriod)+")");
   PlotIndexSetString(0,PLOT_LABEL,"MACD");
   PlotIndexSetString(1,PLOT_LABEL,"DIF");
   PlotIndexSetString(2,PLOT_LABEL,"DEA");
//--- get MAs handles
   ExtFastMaHandle=iMA(NULL,0,InpFastEMAPeriod,0,MODE_EMA,InpAppliedPrice);
   ExtSlowMaHandle=iMA(NULL,0,InpSlowEMAPeriod,0,MODE_EMA,InpAppliedPrice);
//--- initialization done
  }
//+------------------------------------------------------------------+
//|  Moving Average of Oscillator                                    |
//+------------------------------------------------------------------+
int OnCalculate(const int rates_total,
                const int prev_calculated,
                const datetime &time[],
                const double &open[],
                const double &high[],
                const double &low[],
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[])
  {
   if(rates_total<InpSignalSMAPeriod)
      return(0);
//--- not all data may be calculated
   int calculated=BarsCalculated(ExtFastMaHandle);
   if(calculated<rates_total)
     {
      Print("Not all data of ExtFastMaHandle is calculated (",calculated,"bars ). Error",GetLastError());
      return(0);
     }
   calculated=BarsCalculated(ExtSlowMaHandle);
   if(calculated<rates_total)
     {
      Print("Not all data of ExtSlowMaHandle is calculated (",calculated,"bars ). Error",GetLastError());
      return(0);
     }
//--- we can copy not all data
   int to_copy;
   if(prev_calculated>rates_total || prev_calculated<0) to_copy=rates_total;
   else
     {
      to_copy=rates_total-prev_calculated;
      if(prev_calculated>0) to_copy++;
     }
//--- get Fast EMA buffer
   if(IsStopped()) return(0); //Checking for stop flag
   if(CopyBuffer(ExtFastMaHandle,0,0,to_copy,ExtFastMaBuffer)<=0)
     {
      Print("Getting fast EMA is failed! Error",GetLastError());
      return(0);
     }
//--- get SlowSMA buffer
   if(IsStopped()) return(0); //Checking for stop flag
   if(CopyBuffer(ExtSlowMaHandle,0,0,to_copy,ExtSlowMaBuffer)<=0)
     {
      Print("Getting slow SMA is failed! Error",GetLastError());
      return(0);
     }
//---
   int i,limit;
   if(prev_calculated==0)
      limit=0;
   else limit=prev_calculated-1;
//--- the main loop of calculations
   for(i=limit;i<rates_total;i++)
     {
      //--- calculate Dif
      ExtDifBuffer[i]=ExtFastMaBuffer[i]-ExtSlowMaBuffer[i];
     }
//--- calculate Signal
   SimpleMAOnBuffer(rates_total,prev_calculated,0,InpSignalSMAPeriod,ExtDifBuffer,ExtDeaBuffer);

   for(i=limit;i<rates_total;i++)
     {
      if(i==0)
        {
         ExtDifColorBuffer[i]=0;
           }else if(ExtDifBuffer[i]>ExtDeaBuffer[i]){
         ExtDifColorBuffer[i]=0;
           }else{
         ExtDifColorBuffer[i]=1;
        }
     }

//--- calculate MACD
   for(i=limit;i<rates_total && !IsStopped();i++)
     {
      ExtMACDBuffer[i]=(ExtDifBuffer[i]-ExtDeaBuffer[i])*2;
      if(i==0)
        {
         ExtMACDColorBuffer[i]=0;
        }
      else if(ExtMACDBuffer[i]>ExtMACDBuffer[i-1])
        {
         ExtMACDColorBuffer[i]=0;
           }else{
         ExtMACDColorBuffer[i]=1;
        }
     }
//--- OnCalculate done. Return new prev_calculated.
   return(rates_total);
  }
//+------------------------------------------------------------------+
