//+------------------------------------------------------------------+
//|                                                      RPTrade.mqh |
//|                                  Copyright 2014, Remi PASSANELLO |
//|                          https://login.mql5.com/en/users/remulix |
//+------------------------------------------------------------------+
#property copyright "Copyright 2014, Remi PASSANELLO"
#property link      "https://login.mql5.com/en/users/remulix"

bool UseMaximumPercentageRisk=true;
double MaximumPercentageRisk=25;

#include <Trade\SymbolInfo.mqh>
//+------------------------------------------------------------------+
//|  GetLotSize RPTrade                                              |
//+------------------------------------------------------------------+
double GetLotSize(double lotsize)
  {
//--- Gets pair specs  
   CSymbolInfo symInfo;
   int  digits_bn=symInfo.Digits();
   double  points_bn=symInfo.Point();
   string symbol_bn=_Symbol;
//--- adjust lot 
   int tmpdecimal=1;
   double old_lot=lotsize;
//---
   if((NormalizeDouble(AccountInfoDouble(ACCOUNT_FREEMARGIN)*(MaximumPercentageRisk/100)/1000.0,tmpdecimal)<lotsize) && UseMaximumPercentageRisk) //is lot fitting risk ?
     {
      lotsize=NormalizeDouble(AccountInfoDouble(ACCOUNT_FREEMARGIN)*(MaximumPercentageRisk/100)/1000.0,tmpdecimal);  //Claculates new Lotsize 

      if(lotsize<SymbolInfoDouble(symbol_bn,SYMBOL_VOLUME_MIN)) //is LotSize fitting minimum broker LotSize ?
        {
         lotsize=SymbolInfoDouble(symbol_bn,SYMBOL_VOLUME_MIN);   //No! Setting LotSize to minimum's broker LS
         Print(_Symbol," Lot adjusted from ",old_lot," to minimum size allowed by the server of ",lotsize);
        }
      else
        {
         Print(_Symbol," Lot adjusted from ",old_lot," to ",lotsize," to comply with Maximum Risk condition. Each trade can risk only ",MaximumPercentageRisk,"% of free margin.");   //Yes! 
         if(MathAbs(lotsize/SymbolInfoDouble(symbol_bn,SYMBOL_VOLUME_STEP)-MathRound(lotsize/SymbolInfoDouble(symbol_bn,SYMBOL_VOLUME_STEP)))>1.0E-10) //Is LotSize fitting Broker's allowed step ?
           {
            lotsize=SymbolInfoDouble(symbol_bn,SYMBOL_VOLUME_STEP)*NormalizeDouble(lotsize/SymbolInfoDouble(symbol_bn,SYMBOL_VOLUME_STEP),0);   //NO! recalculates LotSize.    
            Print("M-",_Symbol," Warning: Your calculated percentage at risk lot size of was not a multiple of minimal step",SymbolInfoDouble(symbol_bn,SYMBOL_VOLUME_STEP),". Lot size changed to",lotsize);
           }
        }
     }
   return(lotsize);
  }
//+------------------------------------------------------------------+
