//+------------------------------------------------------------------+
//|                                                 TestBarShift.mq5 |
//|                        Copyright 2013, MetaQuotes Software Corp. |
//|                                              http://www.mql5.com |
//+------------------------------------------------------------------+
#property copyright "Copyright 2013, Alain Verleyen."
#property link      "alain@alamga.be"
#property version   "1.00"

#include <iBarShift.mqh>
input datetime          searchDate  = D'2014.10.03 12:00:00';
input bool              exacts      = false;
input int               count       = 100000;
input ENUM_TIMEFRAMES   searchTF    = PERIOD_D1;
input int               searchtf    = 1440;

//+------------------------------------------------------------------+
//| Script program start function                                    |
//+------------------------------------------------------------------+
void OnStart()
  {
//---
   int i,shift0=0,shift1=0,shift2=0,shift3=0,shift4=0;
   uint start=GetTickCount();

   Print("iBarShift benchmark on ",EnumToString(searchTF)," based on ",count," runs.");
   Print("======================================");
   for(i=1;i<=count;i++)
     {
      shift0=iBarShift(_Symbol,searchTF,searchDate,exacts);
     }
   Print("iBarShift for ",TimeToString(searchDate)," is ",shift0," in ",GetTickCount()-start," milliseconds.");
   Print("--------------------------------------------------------");

//--- marketeer version
   start=GetTickCount();
   for(i=1;i<=count;i++)
     {
      shift1=iBarShiftFast(_Symbol,searchTF,searchDate);
     }
   Print("iBarShiftFast (marketeer) for ",TimeToString(searchDate)," is ",shift1," in ",GetTickCount()-start," milliseconds.");
   Print("--------------------------------------------------------");

//--- dc2008 version
   start=GetTickCount();
   for(i=1;i<=count;i++)
     {
      shift2=iBarShiftMQL4(_Symbol,searchtf,searchDate,exacts);
     }
   Print("iBarShiftMQL4 (dc2008) for ",TimeToString(searchDate)," is ",shift2," in ",GetTickCount()-start," milliseconds.");
   Print("--------------------------------------------------------");

//--- circlesquares version
   start=GetTickCount();
   for(i=1;i<=count;i++)
     {
      shift3=iBarShift_circlesquares(_Symbol,searchtf,searchDate,exacts);
     }
   Print("iBarShift (circlesquares) for ",TimeToString(searchDate)," is ",shift3," in ",GetTickCount()-start," milliseconds.");
   Print("--------------------------------------------------------");

//--- komposter version
   start=GetTickCount();
   for(i=1;i<=count;i++)
     {
      shift4=iBarShift_komposter(_Symbol,searchTF,searchDate,exacts);
     }
   Print("iBarShift (komposter) for ",TimeToString(searchDate)," is ",shift4," in ",GetTickCount()-start," milliseconds.");
   Print("--------------------------------------------------------");
  }
bool wait_for_bars=true;
//+--------------------------------------------------------------------------+
//| version from http://www.mql5.com/en/forum/29#comment_446 (circlesquares) |
//+--------------------------------------------------------------------------+
int iBarShift_circlesquares(string symbol,int tf,datetime time,bool exact=false)
  {
   if(time<0) return(-1);
   ENUM_TIMEFRAMES timeframe=TFMigrate(tf);
   if(wait_for_bars==true)
     {
      if(WaitLoop(symbol,timeframe)==false) return(-1);
     }
   datetime Arr[];

   if(CopyTime(symbol,timeframe,iTime(symbol,timeframe,0),time,Arr)>0)
     {
      if(exact==false)
        {
         return(ArraySize(Arr)-1);
        }
      else
        {
         int tmp=ArraySize(Arr)-1;
         if(iTime(symbol,tf,tmp)==time) return(tmp);
        }
     }
   return(-1);
  }
//+------------------------------------------------------------------+
//| TFMigrate                                                        |
//+------------------------------------------------------------------+
ENUM_TIMEFRAMES TFMigrate(int tf)
  {
   switch(tf)
     {
      case 0: return(PERIOD_CURRENT);
      case 1: return(PERIOD_M1);
      case 5: return(PERIOD_M5);
      case 15: return(PERIOD_M15);
      case 30: return(PERIOD_M30);
      case 60: return(PERIOD_H1);
      case 240: return(PERIOD_H4);
      case 1440: return(PERIOD_D1);
      case 10080: return(PERIOD_W1);
      case 43200: return(PERIOD_MN1);

      case 2: return(PERIOD_M2);
      case 3: return(PERIOD_M3);
      case 4: return(PERIOD_M4);
      case 6: return(PERIOD_M6);
      case 10: return(PERIOD_M10);
      case 12: return(PERIOD_M12);
      case 16385: return(PERIOD_H1);
      case 16386: return(PERIOD_H2);
      case 16387: return(PERIOD_H3);
      case 16388: return(PERIOD_H4);
      case 16390: return(PERIOD_H6);
      case 16392: return(PERIOD_H8);
      case 16396: return(PERIOD_H12);
      case 16408: return(PERIOD_D1);
      case 32769: return(PERIOD_W1);
      case 49153: return(PERIOD_MN1);

      default: return(PERIOD_CURRENT);
     }
  }
//+------------------------------------------------------------------+
//| WaitLoop                                                         |
//+------------------------------------------------------------------+
bool WaitLoop(string symbol,ENUM_TIMEFRAMES tf)
  {
   if(MQL5InfoInteger(MQL5_PROGRAM_TYPE)==4) wait_for_bars=false;//can't use sleep with indicators      
   for(int i=0;i<100;i++)
     {
      if(Bars(symbol,tf)>0)
        {
         return(true);
        }
      else
        {
         Sleep(10);
        }
     }
   return(false);//timed out
  }
//+------------------------------------------------------------------+
//| iTime                                                            |
//+------------------------------------------------------------------+
datetime iTime(string symbol,int tf,int shift)
  {
   if(shift<0) return(-1);
   ENUM_TIMEFRAMES timeframe=TFMigrate(tf);
   datetime Arr[];
   if(wait_for_bars==true)
     {
      if(WaitLoop(symbol,timeframe)==false) return(-1);
     }
   if(CopyTime(symbol,timeframe,shift,1,Arr)>0) return(Arr[0]);
   else return(-1);
  }
//+------------------------------------------------------------------+
//| version 1 from http://www.mql5.com/en/code/1008 (komposter)      |
//+------------------------------------------------------------------+
int iBarShift_komposter(datetime time,bool exact=false)
  {
   if(time<0) return(-1);

   datetime array[],time0;
   if(CopyTime(_Symbol,_Period,0,1,array)<0) return(-1);
   time0=array[0]; //Time of opening zero bar

   if(CopyTime(_Symbol,_Period,time0,time,array)<0) return(-1);

   datetime temptime=iTime(_Symbol,_Period,ArraySize(array)-1);
   if(array[0]==temptime && temptime<=time)
     {
      return(ArraySize(array)-1);
     }
   else
     {
      if(exact)
        {
         return(-1);
        }
      else
        {
         return(ArraySize(array)-1);
        }
     }
  }
//+------------------------------------------------------------------+
//| version 2 from http://www.mql5.com/en/code/1008 (komposter)      |
//+------------------------------------------------------------------+
int iBarShift_komposter(string symbol,ENUM_TIMEFRAMES timeframe,datetime time,bool exact=false)
  {
   if(time<0) return(-1);

   datetime array[],time0;
   if(CopyTime(symbol,timeframe,0,1,array)<0) return(-1);
   time0=array[0]; //Time of opening zero bar

   if(CopyTime(symbol,timeframe,time0,time,array)<0) return(-1);

   datetime temptime=iTime(symbol,timeframe,ArraySize(array)-1);
   if(array[0]==temptime && temptime<=time)
     {
      return(ArraySize(array)-1);
     }
   else
     {
      if(exact)
        {
         return(-1);
        }
      else
        {
         return(ArraySize(array)-1);
        }
     }
  }
//+------------------------------------------------------------------+
//| version from http://www.mql5.com/en/articles/81 (dc2008)         |
//+------------------------------------------------------------------+
int iBarShiftMQL4(string symbol,
                  int tf,
                  datetime time,
                  bool exact=false /* Exact doesn't work */)
  {
   if(time<0) return(-1);
   ENUM_TIMEFRAMES timeframe=TFMigrate(tf);
   datetime Arr[],time1;
   CopyTime(symbol,timeframe,0,1,Arr);
   time1=Arr[0];
   if(CopyTime(symbol,timeframe,time,time1,Arr)>0)
     {
      if(ArraySize(Arr)>2) return(ArraySize(Arr)-1);
      if(time<time1) return(1);
      else return(0);
     }
   else return(-1);
  }
//+------------------------------------------------------------------+
//| version http://www.mql5.com/ru/forum/743 (marketeer)             |
//+------------------------------------------------------------------+
int iBarShiftFast(string symbol,ENUM_TIMEFRAMES timeframe,datetime time)
  {
   datetime lastBar;
   SeriesInfoInteger(symbol,timeframe,SERIES_LASTBAR_DATE,lastBar);
   return(Bars(symbol,timeframe,time,lastBar)-1);
  }
//+------------------------------------------------------------------+
