//+------------------------------------------------------------------+
//|                                                    iBarShift.mqh |
//|                        Copyright 2013, MetaQuotes Software Corp. |
//|                                              http://www.mql5.com |
//+------------------------------------------------------------------+
#property copyright "Copyright 2013, Alain Verleyen."
#property link      "alain@alamga.be"
#property version   "1.02"

/*
   v1.00 - Original version
    1.01 - Correction of a bug, see http://www.mql5.com/ru/forum/14844#comment_642036
    1.02 - Bug fixed if requested time is superior to last bar start time
*/

//+---------------------------------------------------------------------------------------------------------------+
//| iBarShift : fast and correct, like mql4 version (http://docs.mql4.com/series/ibarshift)                       |
//| Search for bar on time. The function returns the offset of the bar, which owns the specified time. If there   |
//| is no specified time bar ("hole" in the history), the function returns, depending on the parameter exact,     |
//| -1 or displacement of the nearest bar.                                                                        |
//| Parameters:                                                                                                   |
//|   symbol    - Symbol the data of which should be used to calculate indicator. NULL means the current symbol.  |
//|   timeframe - Timeframe. It can be any of Timeframe enumeration values. 0 means the current chart timeframe.  |
//|   time 	    - value to find.                                                                                  |
//|   exact 	 - Return mode when bar not found. false - iBarShift returns closest. true - iBarShift returns -1. |
//+---------------------------------------------------------------------------------------------------------------+
int iBarShift(string symbol,ENUM_TIMEFRAMES timeframe,datetime time,bool exact=false)
  {
   datetime LastBar;
   if(!SeriesInfoInteger(symbol,timeframe,SERIES_LASTBAR_DATE,LastBar))
     {
      //-- Sometimes SeriesInfoInteger with SERIES_LASTBAR_DATE return an error,
      //-- so we try an other method
      datetime opentimelastbar[1];
      if(CopyTime(symbol,timeframe,0,1,opentimelastbar)==1)
         LastBar=opentimelastbar[0];
      else
         return(-1);
     }
//--- if time > LastBar we always return 0
   if(time>LastBar)
      return(0);
//---
   int shift=Bars(symbol,timeframe,time,LastBar);
   datetime checkcandle[1];

   //-- If time requested doesn't match opening time of a candle, 
   //-- we need a correction of shift value
   if(CopyTime(symbol,timeframe,time,1,checkcandle)==1)
     {
      if(checkcandle[0]==time)
         return(shift-1);
      else if(exact && time>checkcandle[0]+PeriodSeconds(timeframe))
         return(-1);
      else
         return(shift);

      /*
         Can be replaced by the following statement for more concision 
         return(checkcandle[0]==time ? shift-1 : (exact && time>checkcandle[0]+PeriodSeconds(timeframe) ? -1 : shift));
       */
     }
   return(-1);
  }
//+------------------------------------------------------------------+
