//+------------------------------------------------------------------+
//|                                                   i-OneThird.mq5 |
//|                                          Copyright  2007, RickD | 
//|                                                   www.e2e-fx.net | 
//+------------------------------------------------------------------+
#property copyright "Copyright  2007, RickD"
#property link "www.e2e-fx.net"
#property description "   ,   HeikenAshi"
//----   
#property version   "1.00"
//----     
#property indicator_chart_window 
//----        
#property indicator_buffers 5
//----     
#property indicator_plots   1
//+----------------------------------------------+
//|                  |
//+----------------------------------------------+
//----      
#property indicator_type1   DRAW_COLOR_CANDLES
//----     
#property indicator_color1  clrTeal,clrDeepPink
//----   
#property indicator_label1  "open;high;low;close"
//+----------------------------------------------+
//|                    |
//+----------------------------------------------+


//+----------------------------------------------+

//----   ,    
//      
double ExtOpenBuffer[];
double ExtHighBuffer[];
double ExtLowBuffer[];
double ExtCloseBuffer[];
double ExtColorBuffer[];
//----
int min_rates_total;
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
void OnInit()
  {
//----    
   min_rates_total=1;

//----      
   SetIndexBuffer(0,ExtOpenBuffer,INDICATOR_DATA);
   SetIndexBuffer(1,ExtHighBuffer,INDICATOR_DATA);
   SetIndexBuffer(2,ExtLowBuffer,INDICATOR_DATA);
   SetIndexBuffer(3,ExtCloseBuffer,INDICATOR_DATA);
//----     ,     
   SetIndexBuffer(4,ExtColorBuffer,INDICATOR_COLOR_INDEX);
//----       1
   PlotIndexSetInteger(0,PLOT_DRAW_BEGIN,min_rates_total);
//----   ,      
   PlotIndexSetDouble(0,PLOT_EMPTY_VALUE,0.0);

//----     
   IndicatorSetInteger(INDICATOR_DIGITS,_Digits);
//----         
   string short_name="i-OneThird";
   IndicatorSetString(INDICATOR_SHORTNAME,short_name);
//----   
  }
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int OnCalculate(const int rates_total,
                const int prev_calculated,
                const datetime &time[],
                const double &open[],
                const double &high[],
                const double &low[],
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[])
  {
//----       
   if(rates_total<min_rates_total) return(0);

//----    
   int first,bar;

//----    first    
   if(prev_calculated>rates_total || prev_calculated<=0) //      
     {
      first=0; //      
     }
   else first=prev_calculated-1; //      

//----    
   for(bar=first; bar<rates_total && !IsStopped(); bar++)
     {
      ExtLowBuffer[bar]=0.0;
      ExtHighBuffer[bar]=0.0;
      ExtOpenBuffer[bar]=0.0;
      ExtCloseBuffer[bar]=0.0;

      double third=(high[bar]-low[bar])/3;
      //----
      if(close[bar]>high[bar]-third)
        {
         ExtLowBuffer[bar]=low[bar];
         ExtHighBuffer[bar]=high[bar];
         ExtOpenBuffer[bar]=MathMin(open[bar],close[bar]);
         ExtCloseBuffer[bar]=MathMax(open[bar],close[bar]);
        }
      //----
      if(close[bar]<low[bar]+third)
        {
         ExtHighBuffer[bar]=high[bar];
         ExtLowBuffer[bar]=low[bar];
         ExtOpenBuffer[bar]=MathMax(open[bar],close[bar]);
         ExtCloseBuffer[bar]=MathMin(open[bar],close[bar]);
        }

      //---  
      if(ExtOpenBuffer[bar]<ExtCloseBuffer[bar]) ExtColorBuffer[bar]=0.0;
      else ExtColorBuffer[bar]=1.0;

     }
//----     
   return(rates_total);
  }
//+------------------------------------------------------------------+
