//+------------------------------------------------------------------+ 
//|                                                    i4_DRF_v2.mq5 | 
//|                                               goldenlion@ukr.net | 
//|                                      http://GlobeInvestFund.com/ | 
//+------------------------------------------------------------------+ 
#property copyright "Copyright (c) 2005, goldenlion@ukr.net"
#property link      "http://GlobeInvestFund.com/"
#property version   "1.00"
//----     
#property indicator_separate_window
//----        
#property indicator_buffers 2
//----     
#property indicator_plots   1
//+----------------------------------------------+
//|                  |
//+----------------------------------------------+
//----     
#property indicator_type1   DRAW_COLOR_HISTOGRAM
//----    
#property indicator_color1  clrMagenta,clrAqua
//----   -  
#property indicator_style1  STYLE_SOLID
//----     2
#property indicator_width1  2
//----   
#property indicator_label1  "i4_DRF_v2"
//+----------------------------------------------+
//|     |
//+----------------------------------------------+
#property indicator_level1  +100.0
#property indicator_level2  -100.0
#property indicator_levelcolor clrGray
#property indicator_levelstyle STYLE_DASHDOTDOT
//+----------------------------------------------+
//|                    |
//+----------------------------------------------+
input uint iPeriod=11; //                   
input int Shift=0; //      
//+----------------------------------------------+
//----   ,         
double ExtBuffer[],ColorExtBuffer[];
//----      
int min_rates_total;
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+ 
void OnInit()
  {
//----   
   min_rates_total=int(iPeriod);
   
//----    ExtBuffer   
   SetIndexBuffer(0,ExtBuffer,INDICATOR_DATA);
//----       FATLShift
   PlotIndexSetInteger(0,PLOT_SHIFT,Shift);

//----      
   PlotIndexSetInteger(0,PLOT_DRAW_BEGIN,min_rates_total);
//----      
   string shortname;
   StringConcatenate(shortname,"i4_DRF_v2(",iPeriod," ,",Shift,")");
//---      DataWindow
   PlotIndexSetString(0,PLOT_LABEL,shortname);
//---           
   IndicatorSetString(INDICATOR_SHORTNAME,shortname);
//---     
   IndicatorSetInteger(INDICATOR_DIGITS,0);
//---      
   PlotIndexSetDouble(0,PLOT_EMPTY_VALUE,EMPTY_VALUE);

//----     ,     
   SetIndexBuffer(1,ColorExtBuffer,INDICATOR_COLOR_INDEX);
//----
  }
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int OnCalculate(
                const int rates_total,    //       
                const int prev_calculated,//       
                const datetime &time[],
                const double &open[],
                const double &high[],
                const double &low[],
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[]
                )
  {
//----       
   if(rates_total<min_rates_total) return(0);

//----    
   int first,bar;
   double diff,sum;

//----    first    
   if(prev_calculated>rates_total || prev_calculated<=0) //      
     {
      first=min_rates_total; //      
     }
   else first=prev_calculated-1; //      

//----    
   for(bar=first; bar<rates_total && !IsStopped(); bar++)
     {
      sum=0;
      for(int iii=0; iii<int(iPeriod); iii++) 
        {
          diff=close[bar-iii]-close[bar-iii-1];
          if(diff>0) sum++;
          else sum--;
        }
      sum/=int(iPeriod);
      sum*=100;
      ExtBuffer[bar]=sum;
      if(sum>0) ColorExtBuffer[bar]=1;
      else ColorExtBuffer[bar]=0;
     }
//----     
   return(rates_total);
  }
//+------------------------------------------------------------------+
