//+---------------------------------------------------------------------+
//|                                                            XPFE.mq5 | 
//|                     Copyright  2008, giampiero.raschetti@gmail.com |
//|                                               http://www.fxtrade.it |
//+---------------------------------------------------------------------+ 
//|          SmoothAlgorithms.mqh |
//|   (): __\\MQL5\Include        |
//+---------------------------------------------------------------------+
#property copyright "Copyright  2008, giampiero.raschetti@gmail.com"
#property link "http://www.fxtrade.it"
//----   
#property version   "1.10"
//----     
#property indicator_separate_window 
//----   
#property indicator_buffers 1 
//----     
#property indicator_plots   1
//+-----------------------------------+
//|       |
//+-----------------------------------+
//----     
#property indicator_type1   DRAW_LINE
//----       DodgerBlue 
#property indicator_color1 clrDodgerBlue
//----   -  
#property indicator_style1  STYLE_SOLID
//----     1
#property indicator_width1  1
//----   
#property indicator_label1  "XPFE"

//+-----------------------------------+
//|    CXMA             |
//+-----------------------------------+
#include <SmoothAlgorithms.mqh> 
//+-----------------------------------+

//----    CXMA   SmoothAlgorithms.mqh
CXMA XMA1;
//+-----------------------------------+
//|             |
//+-----------------------------------+
enum Applied_price_ // 
  {
   PRICE_CLOSE_ = 1,     //Close
   PRICE_OPEN_,          //Open
   PRICE_HIGH_,          //High
   PRICE_LOW_,           //Low
   PRICE_MEDIAN_,        //Median Price (HL/2)
   PRICE_TYPICAL_,       //Typical Price (HLC/3)
   PRICE_WEIGHTED_,      //Weighted Close (HLCC/4)
   PRICE_SIMPL_,         //Simpl Price (OC/2)
   PRICE_QUARTER_,       //Quarted Price (HLOC/4) 
   PRICE_TRENDFOLLOW0_,  //TrendFollow_1 Price 
   PRICE_TRENDFOLLOW1_,  //TrendFollow_2 Price
   PRICE_DEMARK_         //Demark Price
  };
//+-----------------------------------+
//|             |
//+-----------------------------------+
/*enum Smooth_Method -     SmoothAlgorithms.mqh
  {
   MODE_SMA_,  //SMA
   MODE_EMA_,  //EMA
   MODE_SMMA_, //SMMA
   MODE_LWMA_, //LWMA
   MODE_JJMA,  //JJMA
   MODE_JurX,  //JurX
   MODE_ParMA, //ParMA
   MODE_T3,    //T3
   MODE_VIDYA, //VIDYA
   MODE_AMA,   //AMA
  }; */
//+-----------------------------------+
//|         |
//+-----------------------------------+
input uint PfePeriod=5; // PFE
input Smooth_Method PfeMA_Method=MODE_EMA_; // 
input uint PfeLength=5; //                     
input int PfePhase=15; // ,
                    // JJMA    -100 ... +100,     ;
//  VIDIA   CMO,  AMA    
input Applied_price_ IPC=PRICE_CLOSE_;// 
input int Shift=0; //      
//+-----------------------------------+
//----   ,    
//      
double XPFE[];
//----      
int min_rates_total,min_rates_Pfe;
//+------------------------------------------------------------------+   
//| XPFE indicator initialization function                           | 
//+------------------------------------------------------------------+ 
void OnInit()
  {
//----     
   min_rates_Pfe=int(PfePeriod)+1;
   min_rates_total=min_rates_Pfe+XMA1.GetStartBars(PfeMA_Method,PfeLength,PfePhase);
//----       
   XMA1.XMALengthCheck("PfeLength", PfeLength);
   XMA1.XMAPhaseCheck("PfePhase", PfePhase, PfeMA_Method);

//----      
   SetIndexBuffer(0,XPFE,INDICATOR_DATA);
//----    1  
   PlotIndexSetInteger(0,PLOT_SHIFT,Shift);
//----      
   PlotIndexSetInteger(0,PLOT_DRAW_BEGIN,min_rates_total);
//----   ,      
   PlotIndexSetDouble(0,PLOT_EMPTY_VALUE,PLOT_EMPTY_VALUE);

//----      
   string shortname;
   string Smooth1=XMA1.GetString_MA_Method(PfeMA_Method);
   StringConcatenate(shortname,"XPFE(",PfeLength,", ",Smooth1,")");
//---           
   IndicatorSetString(INDICATOR_SHORTNAME,shortname);

//---     
   IndicatorSetInteger(INDICATOR_DIGITS,_Digits+1);
//----  
  }
//+------------------------------------------------------------------+ 
//| XPFE iteration function                                          | 
//+------------------------------------------------------------------+ 
int OnCalculate(
                const int rates_total,    //       
                const int prev_calculated,//       
                const datetime &time[],
                const double &open[],
                const double &high[],
                const double &low[],
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[]
                )
  {
//----       
   if(rates_total<min_rates_total) return(0);

//----       
   double x1xma,noise,pfe;
//----        
   int first,bar;

//----    first    
   if(prev_calculated>rates_total || prev_calculated<=0) //      
      first=min_rates_Pfe; //      
   else first=prev_calculated-1; //      

//----    
   for(bar=first; bar<rates_total && !IsStopped(); bar++)
     {
      noise=0.000000001;
      for(int k=0; k<int(PfePeriod); k++)
        noise+=MathAbs(PriceSeries(IPC,bar-k,open,low,high,close)-PriceSeries(IPC,bar-k-1,open,low,high,close));
      
      pfe=(PriceSeries(IPC,bar,open,low,high,close)-PriceSeries(IPC,bar-PfePeriod,open,low,high,close))/noise;
      x1xma=XMA1.XMASeries(min_rates_Pfe,prev_calculated,rates_total,PfeMA_Method,PfePhase,PfeLength,pfe,bar,false);     
      XPFE[bar]=x1xma;
     }
//----     
   return(rates_total);
  }
//+------------------------------------------------------------------+
