//+------------------------------------------------------------------+
//|                                          LoginToTradeAccount.mqh |
//|                              Copyright  2016, Vladimir Karputov |
//|                                           http://wmua.ru/slesar/ |
//+------------------------------------------------------------------+
#property copyright "Copyright  2016, Vladimir Karputov"
#property link      "http://wmua.ru/slesar/"
#property version   "1.00"
#property description "Library for clicks on the MetaTrader 5 menu \"File\" item \"Login to trading account\""
#property description "     MetaTrader 5 \"\"  \"   \""

int number_menu=1;   //menu "File";  ""
int item_menu=14;    //item "Login to trading account";  "   "

#define GA_ROOT            0x00000002  // Retrieves the root window by walking the chain of parent windows
#define WM_COMMAND         0x00000111
#define BM_CLICK           0x000000F5

#import "user32.dll"
int  GetLastError();
//+------------------------------------------------------------------+
//| GetAncestor. Retrieves the handle to the ancestor of the         |
//| specified window.              |
//+------------------------------------------------------------------+
//--- x64
long  GetAncestor(long hwnd,int gaFlags);
//--- x86
int  GetAncestor(int hwnd,int gaFlags);
//+------------------------------------------------------------------+
//| GetMenu. Retrieves a handle to the menu assigned to the          |
//| specified window.   ,                         |
//|   .                                    |
//+------------------------------------------------------------------+
//--- x64
long GetMenu(long hWnd);
//--- x86
int GetMenu(int hWnd);
//+------------------------------------------------------------------+
//| GetSubMenu. Retrieves a handle to the drop-down menu or submenu  |
//| activated by the specified menu item.             |
//|      .             |
//+------------------------------------------------------------------+
//--- x64
long GetSubMenu(long hMenu,int nPos);
//--- x86
int GetSubMenu(int hMenu,int nPos);
//+------------------------------------------------------------------+
//| GetMenuItemID. Retrieves the menu item identifier of a menu item |
//| located at the specified position in a menu.           |
//|   ,                        |
//|    .                                        |
//+------------------------------------------------------------------+
//--- x64
int   GetMenuItemID(long hMenu,int nPos);
//--- x86
int   GetMenuItemID(int hMenu,int nPos);
//+------------------------------------------------------------------+
//| PostMessageW. Places (posts) a message in the message queue      |
//| associated with the thread that created the specified window     |
//| and returns without waiting for the thread to process the        |
//| message.  ()    ,    |
//|   ,                  |
//| ,   ,   .   |
//+------------------------------------------------------------------+
//--- x64
bool  PostMessageW(long hWnd,int Msg,int wParam,int lParam);
//--- x86
bool  PostMessageW(int hWnd,int Msg,int wParam,int lParam);
//+------------------------------------------------------------------+
//| GetLastActivePopup. Determines which pop-up window owned by the  |
//| specified window was most recently active. ,      |
//|  ,   ,    |
//|  .                                                   |
//+------------------------------------------------------------------+
//--- x64
long  GetLastActivePopup(long hWnd);
//--- x86
int  GetLastActivePopup(int hWnd);
//+------------------------------------------------------------------+
//| GetDlgItem. Retrieves a handle to a control in the specified     |
//| dialog box.                    |
//|   .                                       |
//+------------------------------------------------------------------+
//--- x64
long  GetDlgItem(long hDlg,int nIDDlgItem);
//--- x86
int  GetDlgItem(int hDlg,int nIDDlgItem);
#import
//+------------------------------------------------------------------+
//| Click on the item "Login to trading account"                     |
//|    "   "                  |
//+------------------------------------------------------------------+
void LoginToTradeAccount()
  {
   long mainChartID=ChartID(); //returns the ID of the current chart;    
   int hdlmainChartID=ChartWindowsHandle(mainChartID); //returns the Chart window handle (HWND);    

   if(_IsX64)
     {
      long hdlRoot=GetAncestor((long)hdlmainChartID,GA_ROOT);
      long hmenu=GetMenu(hdlRoot);
      long hsubmenu=GetSubMenu(hmenu,number_menu);
      int hpos=GetMenuItemID(hsubmenu,item_menu);
      PostMessageW(hdlRoot,WM_COMMAND,hpos,0);
      Sleep(2000);
      long hlastPopup=GetLastActivePopup(hdlRoot);
      long hOK=GetDlgItem(hlastPopup,0x00000001);
      PostMessageW(hOK,BM_CLICK,0,0);
     }
   else
     {
      int hdlRoot=GetAncestor(hdlmainChartID,GA_ROOT);
      int hmenu=GetMenu(hdlRoot);
      int hsubmenu=GetSubMenu(hmenu,number_menu);
      int hpos=GetMenuItemID(hsubmenu,item_menu);
      PostMessageW(hdlRoot,WM_COMMAND,hpos,0);
      Sleep(2000);
      int hlastPopup=GetLastActivePopup(hdlRoot);
      int hOK=GetDlgItem(hlastPopup,0x00000001);
      PostMessageW(hOK,BM_CLICK,0,0);
     }
  }
//+------------------------------------------------------------------+
//| The function gets the handle graphics                            |
//|                                       |
//+------------------------------------------------------------------+
int ChartWindowsHandle(long chart_ID)
  {
//--- prepare the variable to get the property value
//---      
   long result=-1;
//--- reset the error value
//---   
   ResetLastError();
//--- receive the property value
//---   
   if(!ChartGetInteger(chart_ID,CHART_WINDOW_HANDLE,0,result))
     {
      //--- display the error message in Experts journal
      //---       ""
      Print(__FUNCTION__+", Error Code = ",GetLastError());
     }
//--- return the value of the chart property
//---    
   return((int)result);
  }
//+------------------------------------------------------------------+
