//+------------------------------------------------------------------+ 
//|                                          PChannel_System_HTF.mq5 | 
//|                               Copyright  2016, Nikolay Kositsin | 
//|                              Khabarovsk,   farria@mail.redcom.ru | 
//+------------------------------------------------------------------+ 
#property copyright "Copyright  2016, Nikolay Kositsin"
#property link "farria@mail.redcom.ru"
//---   
#property version   "1.00"
//----     
#property indicator_chart_window
//----    7
#property indicator_buffers 7 
//----     
#property indicator_plots   4
//+----------------------------------------------+
//|                            |
//+----------------------------------------------+
#define RESET 0                                      //        
#define INDICATOR_NAME "PChannel_System"             //    
#define SIZE 5                                       //      CountLine
//+----------------------------------------------+
//|     1            |
//+----------------------------------------------+
//----      
#property indicator_type1   DRAW_FILLING
//----      WhiteSmoke 
#property indicator_color1  clrWhiteSmoke
//----   
#property indicator_label1  "PChannel"
//+----------------------------------------------+
//|     2            |
//+----------------------------------------------+
//----   2   
#property indicator_type2   DRAW_LINE
//----        LightSeaGreen 
#property indicator_color2  clrLightSeaGreen
//----   2 -  
#property indicator_style2  STYLE_SOLID
//----    2  2
#property indicator_width2  2
//----    
#property indicator_label2  "Upper PChannel"
//+----------------------------------------------+
//|     3            |
//+----------------------------------------------+
//----   3   
#property indicator_type3   DRAW_LINE
//----        DeepPink 
#property indicator_color3  clrDeepPink
//----   3 -  
#property indicator_style3  STYLE_SOLID
//----    3  2
#property indicator_width3  2
//----    
#property indicator_label3  "Lower PChannel"
//+----------------------------------------------+
//|     4            |
//+----------------------------------------------+
//----      
#property indicator_type4 DRAW_COLOR_HISTOGRAM2
//----      
#property indicator_color4 clrMagenta,clrPurple,clrGray,clrMediumBlue,clrDodgerBlue
//----   - 
#property indicator_style4 STYLE_SOLID
//----     2
#property indicator_width4 2
//----   
#property indicator_label4 "PChannel_BARS"
//+----------------------------------------------+
//|                    |
//+----------------------------------------------+ 
input ENUM_TIMEFRAMES TimeFrame=PERIOD_H4;//  
input uint period=20;  //   
input uint   Shift=2;  //       
//+----------------------------------------------+
//----   ,    
//      
double ExtLineBuffer1[],ExtLineBuffer2[],ExtLineBuffer3[],ExtLineBuffer4[],ExtLineBuffer5[],ExtLineBuffer6[],ExtLineBuffer7[];
//---   
string Symbol_,Word;
//---      
int min_rates_total;
//---      
int Ind_Handle;
//+------------------------------------------------------------------+
//|                                    |
//+------------------------------------------------------------------+
string GetStringTimeframe(ENUM_TIMEFRAMES timeframe)
  {return(StringSubstr(EnumToString(timeframe),7,-1));}
//+------------------------------------------------------------------+    
//| Custom indicator initialization function                         | 
//+------------------------------------------------------------------+  
int OnInit()
  {
//---     
   if(TimeFrame<Period() && TimeFrame!=PERIOD_CURRENT)
     {
      Print("    PChannel_System       ");
      return(INIT_FAILED);
     }
//---   
   min_rates_total=2;
   Symbol_=Symbol();
   Word=INDICATOR_NAME+" : "+Symbol_+StringSubstr(EnumToString(_Period),7,-1);
//---    PChannel_System
   Ind_Handle=iCustom(Symbol_,TimeFrame,"PChannel_System",period,Shift);
   if(Ind_Handle==INVALID_HANDLE)
     {
      Print("      PChannel_System");
      return(INIT_FAILED);
     }
//----      
   SetIndexBuffer(0,ExtLineBuffer1,INDICATOR_DATA);
   SetIndexBuffer(1,ExtLineBuffer2,INDICATOR_DATA);
   SetIndexBuffer(2,ExtLineBuffer3,INDICATOR_DATA);
   SetIndexBuffer(3,ExtLineBuffer4,INDICATOR_DATA);
   SetIndexBuffer(4,ExtLineBuffer5,INDICATOR_DATA);
   SetIndexBuffer(5,ExtLineBuffer6,INDICATOR_DATA);
   SetIndexBuffer(6,ExtLineBuffer7,INDICATOR_DATA);
//----  ,    
   PlotIndexSetInteger(0,PLOT_DRAW_BEGIN,min_rates_total);
   PlotIndexSetInteger(1,PLOT_DRAW_BEGIN,min_rates_total);
   PlotIndexSetInteger(2,PLOT_DRAW_BEGIN,min_rates_total);
   PlotIndexSetInteger(3,PLOT_DRAW_BEGIN,min_rates_total);
//----      
   PlotIndexSetDouble(0,PLOT_EMPTY_VALUE,EMPTY_VALUE);
   PlotIndexSetDouble(1,PLOT_EMPTY_VALUE,EMPTY_VALUE);
   PlotIndexSetDouble(2,PLOT_EMPTY_VALUE,EMPTY_VALUE);
   PlotIndexSetDouble(3,PLOT_EMPTY_VALUE,EMPTY_VALUE);
//----       
   ArraySetAsSeries(ExtLineBuffer1,true);
   ArraySetAsSeries(ExtLineBuffer2,true);
   ArraySetAsSeries(ExtLineBuffer3,true);
   ArraySetAsSeries(ExtLineBuffer4,true);
   ArraySetAsSeries(ExtLineBuffer5,true);
   ArraySetAsSeries(ExtLineBuffer6,true);
   ArraySetAsSeries(ExtLineBuffer7,true);
//---           
   string shortname;
   StringConcatenate(shortname,INDICATOR_NAME"(",GetStringTimeframe(TimeFrame),")");
   IndicatorSetString(INDICATOR_SHORTNAME,shortname);
//---     
   IndicatorSetInteger(INDICATOR_DIGITS,_Digits);
//---  
   return(INIT_SUCCEEDED);
  }
//+------------------------------------------------------------------+  
//| Custom iteration function                                        | 
//+------------------------------------------------------------------+  
int OnCalculate(const int rates_total,    //       
                const int prev_calculated,//       
                const datetime &time[],
                const double &open[],
                const double &high[],
                const double &low[],
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[])
  {
//---       
   if(rates_total<min_rates_total) return(RESET);
   if(BarsCalculated(Ind_Handle)<Bars(Symbol(),TimeFrame)) return(prev_calculated);
//---         
   ArraySetAsSeries(time,true);
   ArraySetAsSeries(high,true);
   ArraySetAsSeries(low,true);
//---    
   if(!CountIndicator(0,NULL,TimeFrame,Ind_Handle,0,ExtLineBuffer1,time,rates_total,prev_calculated,min_rates_total)) return(RESET);
   if(!CountIndicator(1,NULL,TimeFrame,Ind_Handle,1,ExtLineBuffer2,time,rates_total,prev_calculated,min_rates_total)) return(RESET);
   if(!CountIndicator(2,NULL,TimeFrame,Ind_Handle,2,ExtLineBuffer3,time,rates_total,prev_calculated,min_rates_total)) return(RESET);
   if(!CountIndicator(3,NULL,TimeFrame,Ind_Handle,3,ExtLineBuffer4,time,rates_total,prev_calculated,min_rates_total)) return(RESET);
   if(!CountIndicator(4,NULL,TimeFrame,Ind_Handle,8,ExtLineBuffer7,time,rates_total,prev_calculated,min_rates_total)) return(RESET);   
   if(!CountIndicatorBar(NULL,TimeFrame,Ind_Handle,5,ExtLineBuffer5,6,ExtLineBuffer6,time,high,low,rates_total,prev_calculated,min_rates_total)) return(RESET);
//---     
   return(rates_total);
  }
//+------------------------------------------------------------------+
//| CountIndicator                                                   |
//+------------------------------------------------------------------+
bool CountIndicator(uint     Numb,            //   CountLine      (  - 0)
                    string   Symb,            //  
                    ENUM_TIMEFRAMES TFrame,   //  
                    int      IndHandle,       //   
                    uint     BuffNumb,        //    
                    double&  IndBuf[],        //   
                    const datetime& iTime[],  //  
                    const int Rates_Total,    //       
                    const int Prev_Calculated,//       
                    const int Min_Rates_Total)//       
  {
//---
   static int LastCountBar[SIZE];
   datetime IndTime[1];
   int limit;
//---     
//---    limit    
   if(Prev_Calculated>Rates_Total || Prev_Calculated<=0)//      
     {
      limit=Rates_Total-Min_Rates_Total-1; //      
      LastCountBar[Numb]=limit;
     }
   else limit=LastCountBar[Numb]+Rates_Total-Prev_Calculated; //       
//---    
   for(int bar=limit; bar>=0 && !IsStopped(); bar--)
     {
      //---      
      IndBuf[bar]=0.0;
      //---       IndTime
      if(CopyTime(Symbol_,TimeFrame,iTime[bar],1,IndTime)<=0) return(RESET);
      //---
      if(iTime[bar]>=IndTime[0] && iTime[bar+1]<IndTime[0])
        {
         LastCountBar[Numb]=bar;
         double Arr[1];
         //---       Arr
         if(CopyBuffer(IndHandle,BuffNumb,iTime[bar],1,Arr)<=0) return(RESET);
         IndBuf[bar]=Arr[0];
        }
      else IndBuf[bar]=IndBuf[bar+1];
     }
//---     
   return(true);
  }
//+------------------------------------------------------------------+
//| CountIndicatorBar                                                |
//+------------------------------------------------------------------+
bool CountIndicatorBar(string   Symb,            //  
                       ENUM_TIMEFRAMES TFrame,   //  
                       int      IndHandle,       //   
                       uint     HBuffNumb,       //      High
                       double&  HIndBuf[],       //     High
                       uint     LBuffNumb,       //      Low
                       double&  LIndBuf[],       //      Low
                       const datetime& iTime[],  //  
                       const double &High[],     //  iHigh
                       const double &Low[],      //  iLow
                       const int Rates_Total,    //       
                       const int Prev_Calculated,//       
                       const int Min_Rates_Total)//       
  {
//---
   static int LastCountBar;
   datetime IndTime[1];
   int limit;
//---     
//---    limit    
   if(Prev_Calculated>Rates_Total || Prev_Calculated<=0)//      
     {
      limit=Rates_Total-Min_Rates_Total-1; //      
      LastCountBar=limit;
     }
   else limit=LastCountBar+Rates_Total-Prev_Calculated; //       
//---    
   for(int bar=limit; bar>=0 && !IsStopped(); bar--)
     {
      //---      
      HIndBuf[bar]=NULL;
      LIndBuf[bar]=NULL;
      //---       IndTime
      if(CopyTime(Symbol_,TimeFrame,iTime[bar],1,IndTime)<=0) return(RESET);
      //---
      if(iTime[bar]>=IndTime[0] && iTime[bar+1]<IndTime[0])
        {
         LastCountBar=bar;
         double HArr[1],LArr[1];
         //---      
         if(CopyBuffer(IndHandle,HBuffNumb,iTime[bar],1,HArr)<=0) return(RESET);
         if(CopyBuffer(IndHandle,LBuffNumb,iTime[bar],1,LArr)<=0) return(RESET);
         if(HArr[0]) HIndBuf[bar]=High[bar];
         if(LArr[0]) LIndBuf[bar]=Low[bar];
        }
      else
        {
         if(HIndBuf[bar+1]) HIndBuf[bar]=High[bar];
         if(LIndBuf[bar+1]) LIndBuf[bar]=Low[bar];
        }
     }
//---     
   return(true);
  }
//+------------------------------------------------------------------+
