#property copyright "Roffild  2013"
#property link      "http://www.mql5.com/ru/code/1583"
#property version   "1.0"

#include <ObjectEmul.mqh>

MqlRates pr[];

void OnStart()
{
   CopyRates(_Symbol, 0, 0, 15, pr);
   ObjectsDeleteAll(0);
   Print("ObjectEmul_Tester - START");
   DefaultProp();
   SetProp();
   DeleteObjs();
   SaveAndLoad();
   //Memory();
   Print("ObjectEmul_Tester - STOP");
   ObjectsDeleteAll(0);
}

void DefaultProp()
{
   ENUM_OBJECT                  eObjs[] =
   {OBJ_VLINE, OBJ_HLINE, OBJ_TREND, OBJ_TRENDBYANGLE, OBJ_CHANNEL, OBJ_STDDEVCHANNEL, OBJ_REGRESSION,
    OBJ_PITCHFORK, OBJ_GANNLINE, OBJ_GANNFAN, OBJ_GANNGRID, OBJ_FIBO, OBJ_FIBOTIMES, OBJ_FIBOFAN,
    OBJ_FIBOARC, OBJ_FIBOCHANNEL, OBJ_EXPANSION, OBJ_ELLIOTWAVE5, OBJ_ELLIOTWAVE3, OBJ_RECTANGLE,
    OBJ_TRIANGLE, OBJ_ELLIPSE, OBJ_CYCLES, OBJ_ARROW_THUMB_UP, OBJ_ARROW_THUMB_DOWN, OBJ_ARROW_UP,
    OBJ_ARROW_DOWN, OBJ_ARROW_STOP, OBJ_ARROW_CHECK, OBJ_ARROW_LEFT_PRICE, OBJ_ARROW_RIGHT_PRICE,
    OBJ_ARROW_BUY, OBJ_ARROW_SELL, OBJ_ARROW, OBJ_TEXT, OBJ_LABEL, OBJ_BUTTON, OBJ_CHART, OBJ_BITMAP,
    OBJ_BITMAP_LABEL, OBJ_EDIT, OBJ_ARROWED_LINE, OBJ_EVENT, OBJ_RECTANGLE_LABEL};
   ENUM_OBJECT_PROPERTY_INTEGER pInt[] =
   {OBJPROP_COLOR, OBJPROP_STYLE, OBJPROP_WIDTH, OBJPROP_BACK, OBJPROP_ZORDER, OBJPROP_FILL, OBJPROP_HIDDEN,
    OBJPROP_SELECTED, OBJPROP_READONLY, OBJPROP_TYPE, OBJPROP_TIME, OBJPROP_SELECTABLE, OBJPROP_CREATETIME,
    OBJPROP_LEVELS, OBJPROP_LEVELCOLOR, OBJPROP_LEVELSTYLE, OBJPROP_LEVELWIDTH, OBJPROP_ALIGN,
    OBJPROP_FONTSIZE, OBJPROP_RAY_LEFT, OBJPROP_RAY_RIGHT, OBJPROP_RAY, OBJPROP_ELLIPSE, OBJPROP_ARROWCODE,
    OBJPROP_TIMEFRAMES, OBJPROP_ANCHOR, OBJPROP_XDISTANCE, OBJPROP_YDISTANCE, OBJPROP_DIRECTION,
    OBJPROP_DEGREE, OBJPROP_DRAWLINES, OBJPROP_STATE, OBJPROP_CHART_ID, OBJPROP_XSIZE, OBJPROP_YSIZE,
    OBJPROP_XOFFSET, OBJPROP_YOFFSET, OBJPROP_PERIOD, OBJPROP_DATE_SCALE, OBJPROP_PRICE_SCALE,
    OBJPROP_CHART_SCALE, OBJPROP_BGCOLOR, OBJPROP_CORNER, OBJPROP_BORDER_TYPE, OBJPROP_BORDER_COLOR};
   ENUM_OBJECT_PROPERTY_DOUBLE  pDouble[] =
   {OBJPROP_PRICE, OBJPROP_LEVELVALUE, OBJPROP_SCALE, OBJPROP_ANGLE, OBJPROP_DEVIATION};
   ENUM_OBJECT_PROPERTY_STRING  pString[] =
   {OBJPROP_NAME, OBJPROP_TEXT, OBJPROP_TOOLTIP, OBJPROP_LEVELTEXT, OBJPROP_FONT, OBJPROP_BMPFILE,
    OBJPROP_SYMBOL};

   CObjectEmul obj;
   int         counteObjs = ArraySize(eObjs);
   int         countpInt = ArraySize(pInt);
   int         countpDouble = ArraySize(pDouble);
   int         countpString = ArraySize(pString);

   for (int xeObjs = 0; xeObjs < counteObjs; xeObjs++)
   {
      string nameobj = "ObjectEmul_Tester_" + (string)xeObjs;
      ObjectCreate(0, nameobj, eObjs[xeObjs], 0, pr[0].time, pr[0].open, pr[1].time, pr[1].open,
                   pr[2].time, pr[2].open, pr[3].time, pr[3].open);
      obj.ObjctCreate(0, nameobj, eObjs[xeObjs], 0, pr[0].time, pr[0].open, pr[1].time, pr[1].open,
                      pr[2].time, pr[2].open, pr[3].time, pr[3].open);

      for (int xpInt = 0; xpInt < countpInt; xpInt++)
      {
         int  mod, err;
         long origval, testval;

         switch (pInt[xpInt])
         {
            case OBJPROP_CREATETIME:
               break;
            case OBJPROP_TIME:
            case OBJPROP_LEVELCOLOR:
            case OBJPROP_LEVELSTYLE:
            case OBJPROP_LEVELWIDTH:
               for (mod = 0; mod < 15; mod++)
               {
                  origval = ObjectGetInteger(0, nameobj, pInt[xpInt], mod);
                  err = GetLastError();
                  ResetLastError();
                  if (err == ERR_OBJECT_ERROR || err == ERR_OBJECT_WRONG_PROPERTY) break;
                  testval = obj.ObjctGetInteger(0, nameobj, pInt[xpInt], mod);
                  if (origval != testval)
                     Print("type=", EnumToString(eObjs[xeObjs]), " pInt=", EnumToString(pInt[xpInt]),
                           " mod=", mod, " origval=", origval, " testval=", testval, " error=", err);
               }
               break;
            default:
               origval = ObjectGetInteger(0, nameobj, pInt[xpInt]);
               err = GetLastError();
               ResetLastError();
               if (err == ERR_OBJECT_ERROR || err == ERR_OBJECT_WRONG_PROPERTY) break;
               testval = obj.ObjctGetInteger(0, nameobj, pInt[xpInt]);
               if (origval != testval)
                  Print("type=", EnumToString(eObjs[xeObjs]), " pInt=", EnumToString(pInt[xpInt]),
                        " origval=", origval, " testval=", testval, " error=", err);
         }
      }

      for (int xpDouble = 0; xpDouble < countpDouble; xpDouble++)
      {
         int  mod, err;
         long origval, testval;

         switch (pDouble[xpDouble])
         {
            case OBJPROP_PRICE:
            case OBJPROP_LEVELVALUE:
               for (mod = 0; mod < 15; mod++)
               {
                  origval = ObjectGetDouble(0, nameobj, pDouble[xpDouble], mod);
                  err = GetLastError();
                  ResetLastError();
                  if (err == ERR_OBJECT_ERROR || err == ERR_OBJECT_WRONG_PROPERTY) break;
                  testval = obj.ObjctGetDouble(0, nameobj, pDouble[xpDouble], mod);
                  if (origval != testval)
                     Print("type=", EnumToString(eObjs[xeObjs]), " pDouble=", EnumToString(pDouble[xpDouble]),
                           " mod=", mod, " origval=", origval, " testval=", testval, " error=", err);
               }
               break;
            default:
               origval = ObjectGetDouble(0, nameobj, pDouble[xpDouble]);
               err = GetLastError();
               ResetLastError();
               if (err == ERR_OBJECT_ERROR || err == ERR_OBJECT_WRONG_PROPERTY) break;
               testval = obj.ObjctGetDouble(0, nameobj, pDouble[xpDouble]);
               if (origval != testval)
                  Print("type=", EnumToString(eObjs[xeObjs]), " pDouble=", EnumToString(pDouble[xpDouble]),
                        " origval=", origval, " testval=", testval, " error=", err);
         }
      }

      for (int xpString = 0; xpString < countpString; xpString++)
      {
         int  mod, err;
         long origval, testval;

         switch (pString[xpString])
         {
            case OBJPROP_LEVELTEXT:
               for (mod = 0; mod < 15; mod++)
               {
                  origval = ObjectGetString(0, nameobj, pString[xpString], mod);
                  err = GetLastError();
                  ResetLastError();
                  if (err == ERR_OBJECT_ERROR || err == ERR_OBJECT_WRONG_PROPERTY) break;
                  testval = obj.ObjctGetString(0, nameobj, pString[xpString], mod);
                  if (origval != testval)
                     Print("type=", EnumToString(eObjs[xeObjs]), " pString=", EnumToString(pString[xpString]),
                           " mod=", mod, " origval=", origval, " testval=", testval, " error=", err);
               }
               break;
            default:
               origval = ObjectGetString(0, nameobj, pString[xpString]);
               err = GetLastError();
               ResetLastError();
               if (err == ERR_OBJECT_ERROR || err == ERR_OBJECT_WRONG_PROPERTY) break;
               testval = obj.ObjctGetString(0, nameobj, pString[xpString]);
               if (origval != testval)
                  Print("type=", EnumToString(eObjs[xeObjs]), " pString=", EnumToString(pString[xpString]),
                        " origval=", origval, " testval=", testval, " error=", err);
         }
      }
   }
}

void SetProp()
{
   CObjectEmul obj;
   string      nameobj = "ObjectEmul_Tester_FIBO";
   ObjectCreate(0, nameobj, OBJ_FIBO, 0, pr[1].time, pr[1].high, pr[3].time, pr[3].low);
   obj.ObjctCreate(0, nameobj, OBJ_FIBO, 0, pr[1].time, pr[1].high, pr[3].time, pr[3].low);

   if (ObjectGetInteger(0, nameobj, OBJPROP_TYPE) != obj.ObjctGetInteger(0, nameobj, OBJPROP_TYPE))
      Print("SetProp: error TYPE");
   if (ObjectGetInteger(0, nameobj, OBJPROP_TIME, 1) != obj.ObjctGetInteger(0, nameobj, OBJPROP_TIME, 1))
      Print("SetProp: error TIME");
   if (ObjectGetDouble(0, nameobj, OBJPROP_PRICE, 1) != obj.ObjctGetDouble(0, nameobj, OBJPROP_PRICE, 1))
      Print("SetProp: error PRICE");

   ObjectSetInteger(0, nameobj, OBJPROP_TIME, 1, pr[0].time);
   ObjectSetDouble(0, nameobj, OBJPROP_LEVELVALUE, 8, 9);
   ObjectSetString(0, nameobj, OBJPROP_LEVELTEXT, 8, "9");

   obj.ObjctSetInteger(0, nameobj, OBJPROP_TIME, 1, pr[0].time);
   obj.ObjctSetDouble(0, nameobj, OBJPROP_LEVELVALUE, 8, 9);
   obj.ObjctSetString(0, nameobj, OBJPROP_LEVELTEXT, 8, "9");

   if (ObjectGetInteger(0, nameobj, OBJPROP_TIME, 1) !=
       obj.ObjctGetInteger(0, nameobj, OBJPROP_TIME, 1))
      Print("SetProp: error TIME 2");
   if (ObjectGetDouble(0, nameobj, OBJPROP_LEVELVALUE, 8) !=
       obj.ObjctGetDouble(0, nameobj, OBJPROP_LEVELVALUE, 8))
      Print("SetProp: error LEVELVALUE 2");
   if (ObjectGetString(0, nameobj, OBJPROP_LEVELTEXT, 8) !=
       obj.ObjctGetString(0, nameobj, OBJPROP_LEVELTEXT, 8))
      Print("SetProp: error LEVELTEXT 2");

   ObjectMove(0, nameobj, 1, pr[4].time, pr[4].high);
   obj.ObjctMove(0, nameobj, 1, pr[4].time, pr[4].high);
   if (ObjectGetInteger(0, nameobj, OBJPROP_TIME, 1) != obj.ObjctGetInteger(0, nameobj, OBJPROP_TIME, 1))
      Print("SetProp: error ObjectMove TIME");
   if (ObjectGetDouble(0, nameobj, OBJPROP_PRICE, 1) != obj.ObjctGetDouble(0, nameobj, OBJPROP_PRICE, 1))
      Print("SetProp: error ObjectMove PRICE");
}

void DeleteObjs()
{
   CObjectEmul obj;
   string      nameobj = "ObjectEmul_Tester_Delete";
   int         x;

   ObjectsDeleteAll(0);

   for (x = 0; x < 10; x++)
   {
      ObjectCreate(0, nameobj + (string)x, OBJ_TREND, 0, pr[1].time, pr[1].low, pr[5].time, pr[5].high);
      obj.ObjctCreate(0, nameobj + (string)x, OBJ_TREND, 0, pr[1].time, pr[1].low, pr[5].time, pr[5].high);
   }

   ObjectDelete(0, nameobj + "4");
   ObjectDelete(0, nameobj + "6");
   ObjectDelete(0, nameobj + "2");

   obj.ObjctDelete(0, nameobj + "4");
   obj.ObjctDelete(0, nameobj + "6");
   obj.ObjctDelete(0, nameobj + "2");

   int count = ObjectsTotal(0, -1, OBJ_TREND);
   if (count != obj.ObjctsTotal(0, -1, OBJ_TREND)) Print("DeleteObjs: error ObjectsTotal");

   for (x = 0; x < count; x++)
      if (ObjectName(0, x, -1, OBJ_TREND) != obj.ObjctName(0, x, -1, OBJ_TREND))
         Print("DeleteObjs: error ObjectName ", (string)x);
}

void SaveAndLoad()
{
   CObjectEmul obj;
   string      nameobj = "ObjectEmul_Tester_SaveAndLoad";
   int         x;

   ObjectsDeleteAll(0);

   for (x = 0; x < 10; x++)
   {
      ObjectCreate(0, nameobj + (string)x, OBJ_TREND, 0, pr[1].time, pr[1].low, pr[5].time, pr[5].high);
      obj.ObjctCreate(0, nameobj + (string)x, OBJ_TREND, 0, pr[1].time, pr[1].low, pr[5].time, pr[5].high);
   }

   obj.SaveFile();
   obj.LoadFile();

   int count = ObjectsTotal(0, -1, OBJ_TREND);
   if (count != obj.ObjctsTotal(0, -1, OBJ_TREND)) Print("SaveAndLoad: error ObjectsTotal");

   for (x = 0; x < count; x++)
   {
      if (ObjectName(0, x, -1, OBJ_TREND) != obj.ObjctName(0, x, -1, OBJ_TREND))
         Print("SaveAndLoad: error ObjectName ", (string)x);
      if (ObjectGetDouble(0, nameobj + (string)x, OBJPROP_PRICE, 1) !=
          obj.ObjctGetDouble(0, nameobj + (string)x, OBJPROP_PRICE, 1))
         Print("SaveAndLoad: error OBJPROP_PRICE ", (string)x);
   }
}

void Memory()
{
   CObjectEmul obj;

   for (int x = 0; x < 100; x++)
   {
      obj.ObjctCreate(0, (string)x, OBJ_ARROW, 0, 1, 2);
      obj.ObjctSetInteger(0, (string)x, OBJPROP_TIME, 1, 2);
      obj.ObjctSetInteger(0, (string)x, OBJPROP_RAY, 0);
      obj.ObjctSetDouble(0, (string)x, OBJPROP_LEVELVALUE, 5, 5);
      obj.ObjctSetDouble(0, (string)x, OBJPROP_ANGLE, 2);
      obj.ObjctSetString(0, (string)x, OBJPROP_LEVELTEXT, 5, "5");
      obj.ObjctSetString(0, (string)x, OBJPROP_TEXT, "Desc");
      Print("Memory: object #", (string)x);
   }
}
