#property copyright "Roffild  2013"
#property link      "http://www.mql5.com/ru/code/1583"
#property version   "1.0"

#property indicator_chart_window

#include <ObjectEmul.mqh>

int OnCalculate(const int rates_total, const int prev_calculated, const int begin, const double& price[])
{
   static bool finish = false;
   if (finish) return(0);

   CObjectEmul obj;
   obj.SaveAuto = false;
   if (obj.LoadFile("", true)) obj.DrawAll();

   datetime first = TimeCurrent();
   for (int ob = ObjectsTotal(0); ob > -1; ob--)
   {
      datetime temp = (datetime)ObjectGetInteger(0, ObjectName(0, ob), OBJPROP_TIME);
      if (temp > 0 && temp < first) first = temp;
   }
   ChartSetInteger(0, CHART_AUTOSCROLL, false);
   ChartNavigate(0, CHART_END,
                 -1 * (Bars(_Symbol, 0, first, TimeCurrent()) - ChartGetInteger(0, CHART_WIDTH_IN_BARS)));

   ChartRedraw();
   finish = true;
   return(0);
}
