//+------------------------------------------------------------------+
//|                                                 Exp_iWPRSign.mq5 |
//|                               Copyright  2016, Nikolay Kositsin | 
//|                              Khabarovsk,   farria@mail.redcom.ru | 
//+------------------------------------------------------------------+
#property copyright "Copyright  2016, Nikolay Kositsin"
#property link      "farria@mail.redcom.ru"
#property version   "1.10"
//+----------------------------------------------+
//                              | 
//+----------------------------------------------+
#include <TradeAlgorithms.mqh>
//+----------------------------------------------+
//|           |
//+----------------------------------------------+
/*enum MarginMode  -     TradeAlgorithms.mqh
  {
   FREEMARGIN=0,     //MM     
   BALANCE,          //MM     
   LOSSFREEMARGIN,   //MM       
   LOSSBALANCE,      //MM       
   LOT               //  
  }; */
//+----------------------------------------------+
//|            |
//+----------------------------------------------+
input double MM=0.1;              //      
input MarginMode MMMode=LOT;      //   
input int    StopLoss_=1000;      //  
input int    TakeProfit_=2000;    //  
input int    Deviation_=10;       //.    
input bool   BuyPosOpen=true;     //    
input bool   SellPosOpen=true;    //    
input bool   BuyPosClose=true;    //    
input bool   SellPosClose=true;   //    
//+----------------------------------------------+
//|    iWPRSign        |
//+----------------------------------------------+
input ENUM_TIMEFRAMES InpInd_Timeframe=PERIOD_H1; //  iWPRSign
uint ATR_Period=14;
input uint                 WPRPeriod=14;
input int UpLevel=-30; // 
input int DnLevel=-70; // 
input uint SignalBar=1;                           //     
//+----------------------------------------------+

int TimeShiftSec;
//----      
int InpInd_Handle;
//----      
int min_rates_total;
//+------------------------------------------------------------------+
//| Expert initialization function                                   |
//+------------------------------------------------------------------+
int OnInit()
  {
//----    iWPRSign
   InpInd_Handle=iCustom(Symbol(),InpInd_Timeframe,"iWPRSign",ATR_Period,WPRPeriod,UpLevel,DnLevel);
   if(InpInd_Handle==INVALID_HANDLE)
     {
      Print("      iWPRSign");
      return(INIT_FAILED);
     }

//----          
   TimeShiftSec=PeriodSeconds(InpInd_Timeframe);

//----     
   min_rates_total=int(MathMax(WPRPeriod+1,ATR_Period))+1;
   min_rates_total+=int(1+SignalBar);
//---  
   return(INIT_SUCCEEDED);
  }
//+------------------------------------------------------------------+
//| Expert deinitialization function                                 |
//+------------------------------------------------------------------+
void OnDeinit(const int reason)
  {
//----
   GlobalVariableDel_(Symbol());
//----
  }
//+------------------------------------------------------------------+
//| Expert tick function                                             |
//+------------------------------------------------------------------+
void OnTick()
  {
//----       
   if(BarsCalculated(InpInd_Handle)<min_rates_total) return;

//----       IsNewBar()  SeriesInfoInteger()  
   LoadHistory(TimeCurrent()-PeriodSeconds(InpInd_Timeframe)-1,Symbol(),InpInd_Timeframe);

//----   
   double DnValue[1],UpValue[1];
//----   
   static bool Recount=true;
   static bool BUY_Open=false,BUY_Close=false;
   static bool SELL_Open=false,SELL_Close=false;
   static datetime UpSignalTime,DnSignalTime;
   static CIsNewBar NB;
//----    
   if(!SignalBar || NB.IsNewBar(Symbol(),InpInd_Timeframe) || Recount) //     
     {
      //----   
      BUY_Open=false;
      SELL_Open=false;
      BUY_Close=false;
      SELL_Close=false;
      Recount=false;

      //----      
      if(CopyBuffer(InpInd_Handle,1,SignalBar,1,UpValue)<=0) {Recount=true; return;}
      if(CopyBuffer(InpInd_Handle,0,SignalBar,1,DnValue)<=0) {Recount=true; return;}

      //----    
      if(UpValue[0] && UpValue[0]!=EMPTY_VALUE)
        {
         if(BuyPosOpen) BUY_Open=true;
         if(SellPosClose)SELL_Close=true;
         UpSignalTime=datetime(SeriesInfoInteger(Symbol(),InpInd_Timeframe,SERIES_LASTBAR_DATE))+TimeShiftSec;
        }

      //----    
      if(DnValue[0] && DnValue[0]!=EMPTY_VALUE)
        {
         if(SellPosOpen) SELL_Open=true;
         if(BuyPosClose) BUY_Close=true;
         DnSignalTime=datetime(SeriesInfoInteger(Symbol(),InpInd_Timeframe,SERIES_LASTBAR_DATE))+TimeShiftSec;
        }

      //----          
      //if(!MQL5InfoInteger(MQL5_TESTING) && !MQL5InfoInteger(MQL5_OPTIMIZATION)) //     " " 
      if(((BuyPosOpen && BuyPosClose) || (SellPosOpen && SellPosClose)) && (!BUY_Close && !SELL_Close))
        {
         int Bars_=Bars(Symbol(),InpInd_Timeframe);

         for(int bar=int(SignalBar+1); bar<Bars_; bar++)
           {
            if(SellPosClose)
              {
               if(CopyBuffer(InpInd_Handle,1,bar,1,UpValue)<=0) {Recount=true; return;}
               if(UpValue[0]!=0 && UpValue[0]!=EMPTY_VALUE)
                 {
                  SELL_Close=true;
                  break;
                 }
              }

            if(BuyPosClose)
              {
               if(CopyBuffer(InpInd_Handle,0,bar,1,DnValue)<=0) {Recount=true; return;}
               if(DnValue[0]!=0 && DnValue[0]!=EMPTY_VALUE)
                 {
                  BUY_Close=true;
                  break;
                 }
              }
           }
        }
     }
//----  
//----  
   BuyPositionClose(BUY_Close,Symbol(),Deviation_);

//----     
   SellPositionClose(SELL_Close,Symbol(),Deviation_);

//----  
   BuyPositionOpen(BUY_Open,Symbol(),UpSignalTime,MM,MMMode,Deviation_,StopLoss_,TakeProfit_);

//----  
   SellPositionOpen(SELL_Open,Symbol(),DnSignalTime,MM,MMMode,Deviation_,StopLoss_,TakeProfit_);
//----
  }
//+------------------------------------------------------------------+
