//+------------------------------------------------------------------+ 
//|                                   ColorJFatl_Cloud_Digit_HTF.mq5 | 
//|                               Copyright  2016, Nikolay Kositsin | 
//|                              Khabarovsk,   farria@mail.redcom.ru | 
//+------------------------------------------------------------------+ 
#property copyright "Copyright  2016, Nikolay Kositsin"
#property link "farria@mail.redcom.ru"
//---   
#property version   "1.00"
//----     
#property indicator_chart_window 
//----   
#property indicator_buffers 6 
//----     
#property indicator_plots   3
//+----------------------------------------------+
//|                            |
//+----------------------------------------------+
#define RESET 0                                       //        
#define INDICATOR_NAME "ColorJFatl_Cloud_Digit"       //    
#define SIZE 6                                        //      CountLine
//+--------------------------------------------+
//|                      |
//+--------------------------------------------+
//----     
#property indicator_type1   DRAW_FILLING
#property indicator_type2   DRAW_FILLING
//----   
#property indicator_color1  clrPaleTurquoise
#property indicator_color2  clrThistle
//----    
#property indicator_label1  "Upper Cloud"
#property indicator_label2  "Lower Cloud"
//+--------------------------------------------+
//|                |
//+--------------------------------------------+
//----      
#property indicator_type3   DRAW_COLOR_LINE
//----      
#property indicator_color3  clrMagenta,clrGray,clrGold
//----   -  
#property indicator_style3  STYLE_SOLID
//----     5
#property indicator_width3  5
//----   
#property indicator_label3  "ColorJFatl_Cloud_Digit_HTF"
//+------------------------------------------------+
//|                          |
//+------------------------------------------------+
enum Applied_price_ // 
  {
   PRICE_CLOSE_ = 1,     //PRICE_CLOSE
   PRICE_OPEN_,          //PRICE_OPEN
   PRICE_HIGH_,          //PRICE_HIGH
   PRICE_LOW_,           //PRICE_LOW
   PRICE_MEDIAN_,        //PRICE_MEDIAN
   PRICE_TYPICAL_,       //PRICE_TYPICAL
   PRICE_WEIGHTED_,      //PRICE_WEIGHTED
   PRICE_SIMPL_,         //PRICE_SIMPL_
   PRICE_QUARTER_,       //PRICE_QUARTER_
   PRICE_TRENDFOLLOW0_,  //TrendFollow_1 Price 
   PRICE_TRENDFOLLOW1_,  //TrendFollow_2 Price 
   PRICE_DEMARK_         //Demark Price
  };
//+----------------------------------------------+
//|                    |
//+----------------------------------------------+ 
input ENUM_TIMEFRAMES TimeFrame=PERIOD_H4;           //  
input string  SirName="ColorJFatl_Cloud_Digit";     //    
input int JLength=5; //  JMA                    
input int JPhase=-100; //  JMA ,
//----    -100 ... +100,
//----     ;
input Applied_price_ IPC=PRICE_CLOSE_;// 
input int Shift=0; //      
input int PriceFATLShift=0; // c     
input uint Dev=20; //   
input uint Digit=2;                       //  
input bool ShowPrice=true; //  
//----   
input color  Price_color=clrGray;
//+----------------------------------------------+
//----   ,    
//      
double ExtLineBuffer1[],ExtLineBuffer2[],ExtLineBuffer3[],ExtLineBuffer4[],ExtLineBuffer5[],ExtLineBuffer6[];
//---   
string Symbol_,Word;
//---      
int min_rates_total;
//---      
int Ind_Handle;
//+------------------------------------------------------------------+
//|                                    |
//+------------------------------------------------------------------+
string GetStringTimeframe(ENUM_TIMEFRAMES timeframe)
  {return(StringSubstr(EnumToString(timeframe),7,-1));}
//+------------------------------------------------------------------+    
//| Custom indicator initialization function                         | 
//+------------------------------------------------------------------+  
int OnInit()
  {
//---     
   if(TimeFrame<Period() && TimeFrame!=PERIOD_CURRENT)
     {
      Print("    ColorJFatl_Cloud_Digit       ");
      return(INIT_FAILED);
     }
//---   
   min_rates_total=2;
   Symbol_=Symbol();
   Word=INDICATOR_NAME+" : "+Symbol_+StringSubstr(EnumToString(_Period),7,-1);
//---    ColorJFatl_Cloud_Digit
   Ind_Handle=iCustom(Symbol_,TimeFrame,"ColorJFatl_Cloud_Digit",SirName,JLength,JPhase,IPC,0,PriceFATLShift,Dev,Digit,ShowPrice,Price_color);
   if(Ind_Handle==INVALID_HANDLE)
     {
      Print("      ColorJFatl_Cloud_Digit");
      return(INIT_FAILED);
     }
//----         
   SetIndexBuffer(0,ExtLineBuffer1,INDICATOR_DATA);
   SetIndexBuffer(1,ExtLineBuffer2,INDICATOR_DATA);
   SetIndexBuffer(2,ExtLineBuffer3,INDICATOR_DATA);
   SetIndexBuffer(3,ExtLineBuffer4,INDICATOR_DATA);
   SetIndexBuffer(4,ExtLineBuffer5,INDICATOR_DATA);
//----     ,     
   SetIndexBuffer(5,ExtLineBuffer6,INDICATOR_COLOR_INDEX);
   
//----       
   ArraySetAsSeries(ExtLineBuffer1,true);
   ArraySetAsSeries(ExtLineBuffer2,true);
   ArraySetAsSeries(ExtLineBuffer3,true);
   ArraySetAsSeries(ExtLineBuffer4,true);
   ArraySetAsSeries(ExtLineBuffer5,true);
   ArraySetAsSeries(ExtLineBuffer6,true);
   
//----    1  
   PlotIndexSetInteger(0,PLOT_SHIFT,Shift);
//----      
   PlotIndexSetInteger(0,PLOT_DRAW_BEGIN,min_rates_total);
//----   ,      
   PlotIndexSetDouble(0,PLOT_EMPTY_VALUE,0.0);
   
//----    2  
   PlotIndexSetInteger(1,PLOT_SHIFT,Shift);
//----      
   PlotIndexSetInteger(1,PLOT_DRAW_BEGIN,min_rates_total);
//----   ,      
   PlotIndexSetDouble(1,PLOT_EMPTY_VALUE,0.0);
   
//----    3  
   PlotIndexSetInteger(2,PLOT_SHIFT,Shift);
//----      
   PlotIndexSetInteger(2,PLOT_DRAW_BEGIN,min_rates_total);
//----   ,      
   PlotIndexSetDouble(2,PLOT_EMPTY_VALUE,0.0);
   
//---           
   string shortname;
   StringConcatenate(shortname,INDICATOR_NAME"(",GetStringTimeframe(TimeFrame),")");
   IndicatorSetString(INDICATOR_SHORTNAME,shortname);
//---     
   IndicatorSetInteger(INDICATOR_DIGITS,_Digits);
//---  
   return(INIT_SUCCEEDED);
  }
//+------------------------------------------------------------------+  
//| Custom iteration function                                        | 
//+------------------------------------------------------------------+  
int OnCalculate(const int rates_total,    //       
                const int prev_calculated,//       
                const datetime &time[],
                const double &open[],
                const double &high[],
                const double &low[],
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[])
  {
//---       
   if(rates_total<min_rates_total) return(RESET);
//---         
   ArraySetAsSeries(time,true);
//---    
   if(!CountIndicator(0,NULL,TimeFrame,Ind_Handle,0,ExtLineBuffer1,time,rates_total,prev_calculated,min_rates_total)) return(RESET);
   if(!CountIndicator(1,NULL,TimeFrame,Ind_Handle,1,ExtLineBuffer2,time,rates_total,prev_calculated,min_rates_total)) return(RESET);
   if(!CountIndicator(2,NULL,TimeFrame,Ind_Handle,2,ExtLineBuffer3,time,rates_total,prev_calculated,min_rates_total)) return(RESET);
   if(!CountIndicator(3,NULL,TimeFrame,Ind_Handle,3,ExtLineBuffer4,time,rates_total,prev_calculated,min_rates_total)) return(RESET);
   if(!CountIndicator(4,NULL,TimeFrame,Ind_Handle,4,ExtLineBuffer5,time,rates_total,prev_calculated,min_rates_total)) return(RESET);
   if(!CountIndicator(5,NULL,TimeFrame,Ind_Handle,5,ExtLineBuffer6,time,rates_total,prev_calculated,min_rates_total)) return(RESET);
//---     
   return(rates_total);
  }
//+------------------------------------------------------------------+
//| CountLine                                                        |
//+------------------------------------------------------------------+
bool CountIndicator(uint     Numb,            //   CountLine      (  - 0)
                    string   Symb,            //  
                    ENUM_TIMEFRAMES TFrame,   //  
                    int      IndHandle,       //   
                    uint     BuffNumb,        //    
                    double&  IndBuf[],        //   
                    const datetime& iTime[],  //  
                    const int Rates_Total,    //       
                    const int Prev_Calculated,//       
                    const int Min_Rates_Total)//       
  {
//---
   static int LastCountBar[SIZE];
   datetime IndTime[1];
   int limit;
//---     
//---    limit    
   if(Prev_Calculated>Rates_Total || Prev_Calculated<=0)//      
     {
      limit=Rates_Total-Min_Rates_Total-1; //      
      LastCountBar[Numb]=limit;
     }
   else limit=LastCountBar[Numb]+Rates_Total-Prev_Calculated; //       
//---    
   for(int bar=limit; bar>=0 && !IsStopped(); bar--)
     {
      //---      
      IndBuf[bar]=0.0;
      //---       IndTime
      if(CopyTime(Symbol_,TimeFrame,iTime[bar],1,IndTime)<=0) return(RESET);
      //---
      if(iTime[bar]>=IndTime[0] && iTime[bar+1]<IndTime[0])
        {
         LastCountBar[Numb]=bar;
         double Arr[1];
         //---       Arr
         if(CopyBuffer(IndHandle,BuffNumb,iTime[bar],1,Arr)<=0) return(RESET);
         IndBuf[bar]=Arr[0];
        }
      else IndBuf[bar]=IndBuf[bar+1];
     }
//---     
   return(true);
  }
//+------------------------------------------------------------------+