//+---------------------------------------------------------------------+
//|                                      ColorX2MA_Cloud_Digit_Grid.mq5 | 
//|                                  Copyright  2016, Nikolay Kositsin | 
//|                                 Khabarovsk,   farria@mail.redcom.ru | 
//+---------------------------------------------------------------------+ 
//|          SmoothAlgorithms.mqh |
//|   (): __\\MQL5\Include        |
//+---------------------------------------------------------------------+
#property copyright "Copyright  2016, Nikolay Kositsin"
#property link "farria@mail.redcom.ru"
//----   
#property version   "1.00"
//----     
#property indicator_chart_window 
//----   
#property indicator_buffers 6 
//----     
#property indicator_plots   3
//+--------------------------------------------+
//|                      |
//+--------------------------------------------+
//----     
#property indicator_type1   DRAW_FILLING
#property indicator_type2   DRAW_FILLING
//----   
#property indicator_color1  clrAquamarine
#property indicator_color2  clrPlum
//----   
#property indicator_label1  "Upper Cloud"
#property indicator_label2  "Lower Cloud"
//+--------------------------------------------+
//|                |
//+--------------------------------------------+
//----      
#property indicator_type3   DRAW_COLOR_LINE
//----      
#property indicator_color3  clrBlueViolet,clrGray,clrMagenta
//----   -  
#property indicator_style3  STYLE_SOLID
//----     5
#property indicator_width3  5
//----   
#property indicator_label3  "X2MA"
//+--------------------------------------------+
//|    CXMA                      |
//+--------------------------------------------+
#include <SmoothAlgorithms.mqh> 
//+--------------------------------------------+

//----    CXMA   SmoothAlgorithms.mqh
CXMA XMA1,XMA2;
//+--------------------------------------------+
//|                      |
//+--------------------------------------------+
enum Applied_price_ // 
  {
   PRICE_CLOSE_ = 1,     //Close
   PRICE_OPEN_,          //Open
   PRICE_HIGH_,          //High
   PRICE_LOW_,           //Low
   PRICE_MEDIAN_,        //Median Price (HL/2)
   PRICE_TYPICAL_,       //Typical Price (HLC/3)
   PRICE_WEIGHTED_,      //Weighted Close (HLCC/4)
   PRICE_SIMPL_,         //Simpl Price (OC/2)
   PRICE_QUARTER_,       //Quarted Price (HLOC/4) 
   PRICE_TRENDFOLLOW0_,  //TrendFollow_1 Price 
   PRICE_TRENDFOLLOW1_,  //TrendFollow_2 Price
   PRICE_DEMARK_         //Demark Price
  };
//+--------------------------------------------+
//|                      |
//+--------------------------------------------+
/*enum Smooth_Method -     SmoothAlgorithms.mqh
  {
   MODE_SMA_,  //SMA
   MODE_EMA_,  //EMA
   MODE_SMMA_, //SMMA
   MODE_LWMA_, //LWMA
   MODE_JJMA,  //JJMA
   MODE_JurX,  //JurX
   MODE_ParMA, //ParMA
   MODE_T3,    //T3
   MODE_VIDYA, //VIDYA
   MODE_AMA,   //AMA
  }; */
//+--------------------------------------------+
//|                      |
//+--------------------------------------------+  
enum WIDTH
  {
   Width_1=1, //1
   Width_2,   //2
   Width_3,   //3
   Width_4,   //4
   Width_5    //5
  };
//+--------------------------------------------+
//|                      |
//+--------------------------------------------+
enum STYLE
  {
   SOLID_,// 
   DASH_,// 
   DOT_,// 
   DASHDOT_,//- 
   DASHDOTDOT_   //-    
  };
//+--------------------------------------------+
//|                  |
//+--------------------------------------------+
input string  SirName="ColorX2MA_Cloud_Digit_Grid";     //    
input Smooth_Method MA_Method1=MODE_SMA_; //    
input int Length1=12; //                       
input int Phase1=15; //  ,
  // JJMA    -100 ... +100,     ;
  //  VIDIA   CMO,  AMA    
input Smooth_Method MA_Method2=MODE_JJMA; //    
input int Length2 = 5; //    
input int Phase2=15;  //  ,
  // JJMA    -100 ... +100,     ;
  //  VIDIA   CMO,  AMA    
input Applied_price_ IPC=PRICE_CLOSE_;// 
input int Shift=0; //      
input int PriceShift=0; //      
input uint Dev=20; //   
input uint Digit=2;                       //  
input bool ShowPrice=true; //  
//----   
input color  Price_color=clrGray;
//----   
input uint  Total=200;                       //       
//----
input color  Color_A = clrSlateBlue;         //  1 
input STYLE  Style_A = DASHDOTDOT_;          //   1
input WIDTH  Width_A = Width_1;              //   1
//----
input color  Color_B = clrDarkOrange;        //  2
input STYLE  Style_B = DASH_;                //   2
input WIDTH  Width_B = Width_1;              //   2
//----
input color  Color_C = clrMagenta;           //  3
input STYLE  Style_C = SOLID_;               //   3
input WIDTH  Width_C = Width_1;              //   3
//----
input color  Color_D = clrRed;               //  4
input STYLE  Style_D = SOLID_;               //   4
input WIDTH  Width_D = Width_1;              //   4
//----
input color  Color_E = clrLime;              //  5
input STYLE  Style_E = SOLID_;               //   5
input WIDTH  Width_E = Width_1;              //   5
//----
input bool ShowLineInfo = true;              //     
//+--------------------------------------------+

//----   ,    
//      
double LineBuffer[];
double ColorLineBuffer[];

double UpCloudBuffer1[],UpCloudBuffer2[];
double DnCloudBuffer1[],DnCloudBuffer2[];

//----      
double dPriceShift;
//----      
int min_rates_total,min_rates_1,min_rates_2;
//----     
string Price_name;
//----    
color clr;
STYLE Style;
WIDTH Width;
bool ShowPriceLable;
int middle,sizex,Normalize,Count;
string ObjectNames[];
double PointPow10,PointPow100,PointPow1000,PointPow10000,PointPow100000,PriceGrid[],Price[];
//+------------------------------------------------------------------+   
//| X2MA indicator initialization function                           | 
//+------------------------------------------------------------------+ 
void OnInit()
  {
//----     
   min_rates_1=XMA1.GetStartBars(MA_Method1, Length1, Phase1);
   min_rates_2=XMA2.GetStartBars(MA_Method2, Length2, Phase2);
   min_rates_total=min_rates_1+min_rates_2+1;
//----       
   XMA1.XMALengthCheck("Length1", Length1);
   XMA2.XMALengthCheck("Length2", Length2);
//----       
   XMA1.XMAPhaseCheck("Phase1", Phase1, MA_Method1);
   XMA2.XMAPhaseCheck("Phase2", Phase2, MA_Method2);
   
//----    
   dPriceShift=_Point*PriceShift;
//----  
   Price_name=SirName+"Price";
//----        
   sizex=int(Total*2);
   ArrayResize(ObjectNames,sizex);
   ArrayResize(PriceGrid,sizex);
   ArrayResize(Price,sizex);
//----  
   for(Count=0; Count<sizex; Count++) ObjectNames[Count]=SirName+" PriceLine "+string(Count);
//----           
   PointPow10=_Point*MathPow(10,Digit);
   PointPow100=PointPow10*10;
   PointPow1000=PointPow10*100;
   PointPow10000=PointPow10*1000;
   PointPow100000=PointPow10*10000;
   middle=(sizex/2)-1;
   Normalize=int(_Digits-Digit);
//----           
   for(Count=middle; Count<sizex; Count++) PriceGrid[Count]=+NormalizeDouble(PointPow10*(Count-middle),Normalize);
   for(Count=middle-1; Count>=0; Count--) PriceGrid[Count]=-NormalizeDouble(PointPow10*(middle-Count),Normalize);
   
//----         
   SetIndexBuffer(0,UpCloudBuffer1,INDICATOR_DATA);
   SetIndexBuffer(1,UpCloudBuffer2,INDICATOR_DATA);
   SetIndexBuffer(2,DnCloudBuffer1,INDICATOR_DATA);
   SetIndexBuffer(3,DnCloudBuffer2,INDICATOR_DATA);
   SetIndexBuffer(4,LineBuffer,INDICATOR_DATA);
//----     ,     
   SetIndexBuffer(5,ColorLineBuffer,INDICATOR_COLOR_INDEX);
   
//----    1  
   PlotIndexSetInteger(0,PLOT_SHIFT,Shift);
//----      
   PlotIndexSetInteger(0,PLOT_DRAW_BEGIN,min_rates_total);
//----   ,      
   PlotIndexSetDouble(0,PLOT_EMPTY_VALUE,0.0);
   
//----    2  
   PlotIndexSetInteger(1,PLOT_SHIFT,Shift);
//----      
   PlotIndexSetInteger(1,PLOT_DRAW_BEGIN,min_rates_total);
//----   ,      
   PlotIndexSetDouble(1,PLOT_EMPTY_VALUE,0.0);
   
//----    3  
   PlotIndexSetInteger(2,PLOT_SHIFT,Shift);
//----      
   PlotIndexSetInteger(2,PLOT_DRAW_BEGIN,min_rates_total);
//----   ,      
   PlotIndexSetDouble(2,PLOT_EMPTY_VALUE,0.0);
      
//----      
   string shortname;
   string Smooth1=XMA1.GetString_MA_Method(MA_Method1);
   string Smooth2=XMA1.GetString_MA_Method(MA_Method2);
   StringConcatenate(shortname,"ColorX2MA_Cloud_Digit_Grid(",Length1,", ",Length2,", ",Smooth1,", ",Smooth2,")");
//----           
   IndicatorSetString(INDICATOR_SHORTNAME,shortname);
   
//----     
   IndicatorSetInteger(INDICATOR_DIGITS,_Digits+1);
//----  
  }
//+------------------------------------------------------------------+
//| Custom indicator deinitialization function                       |
//+------------------------------------------------------------------+    
void OnDeinit(const int reason)
  {
//----
   ObjectDelete(0,Price_name);
   for(Count=0; Count<sizex; Count++) ObjectDelete(0,ObjectNames[Count]);
//----
   ChartRedraw(0);
  }
//+------------------------------------------------------------------+ 
//| X2MA iteration function                                          | 
//+------------------------------------------------------------------+ 
int OnCalculate(const int rates_total,    //       
                const int prev_calculated,//       
                const datetime &time[],
                const double &open[],
                const double &high[],
                const double &low[],
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[])
  {
//----       
   if(rates_total<min_rates_total) return(0);
//----       
   ArraySetAsSeries(close,false);
   ArraySetAsSeries(time,false);

   double res=NormalizeDouble(PointPow10*MathCeil(close[rates_total-1]/PointPow10),Normalize);
   if(prev_calculated!=rates_total)
     {
      for(Count=0; Count<sizex; Count++) ObjectDelete(0,ObjectNames[Count]);
     }
   for(Count=0; Count<sizex; Count++) Price[Count]=NormalizeDouble(res+PriceGrid[Count],Normalize);
   datetime time0=time[rates_total-1]+PeriodSeconds()*Shift;
   datetime timeX=time[0];
   for(Count=0; Count<sizex; Count++)
     {
      string info="";
      if(ShowLineInfo) info=ObjectNames[Count]+" "+DoubleToString(Price[Count],Normalize);
      
      if(!NormalizeDouble(Price[Count]-PointPow100000*MathCeil(Price[Count]/PointPow100000),Normalize))
        {
         SetTline(0,ObjectNames[Count],0,timeX,Price[Count],time0,Price[Count],Color_E,Style_E,Width_E,info);
        }
      else if(!NormalizeDouble(Price[Count]-PointPow10000*MathCeil(Price[Count]/PointPow10000),Normalize))
        {
         SetTline(0,ObjectNames[Count],0,timeX,Price[Count],time0,Price[Count],Color_D,Style_D,Width_D,info);
        }
      else if(!NormalizeDouble(Price[Count]-PointPow1000*MathCeil(Price[Count]/PointPow1000),Normalize))
        {
         SetTline(0,ObjectNames[Count],0,timeX,Price[Count],time0,Price[Count],Color_C,Style_C,Width_C,info);
        }
      else  if(!NormalizeDouble(Price[Count]-PointPow100*MathCeil(Price[Count]/PointPow100),Normalize))
        {
         SetTline(0,ObjectNames[Count],0,timeX,Price[Count],time0,Price[Count],Color_B,Style_B,Width_B,info);
        }
      else
        {
         SetTline(0,ObjectNames[Count],0,timeX,Price[Count],time0,Price[Count],Color_A,Style_A,Width_A,info);
        }
     }

//----        
   ArraySetAsSeries(close,false);
   ArraySetAsSeries(time,false);

//----       
   double price,x1xma,x2xma,trend;
//----        
   int first,bar;

//----    first    
   if(prev_calculated>rates_total || prev_calculated<=0) //      
      first=0; //      
   else first=prev_calculated-1; //      

//----    
   for(bar=first; bar<rates_total && !IsStopped(); bar++)
     {
      price=PriceSeries(IPC,bar,open,low,high,close);
      x1xma = XMA1.XMASeries(0,prev_calculated,rates_total,MA_Method1,Phase1,Length1,price,bar,false);
      x2xma = XMA2.XMASeries(min_rates_1,prev_calculated,rates_total,MA_Method2, Phase2, Length2,x1xma,bar,false);
      LineBuffer[bar]=UpCloudBuffer2[bar]=DnCloudBuffer1[bar]=x2xma+dPriceShift;
      LineBuffer[bar]=PointPow10*MathRound(LineBuffer[bar]/PointPow10);
      UpCloudBuffer1[bar]=LineBuffer[bar]*Dev;
      DnCloudBuffer2[bar]=LineBuffer[bar]/Dev;      
     }
   if(ShowPrice)
     {
      int bar0=rates_total-1;
      time0=time[bar0]+1*PeriodSeconds();
      SetRightPrice(0,Price_name,0,time0,LineBuffer[bar0],Price_color);
     }

//----    first
   if(prev_calculated>rates_total || prev_calculated<=0) //      
      first=min_rates_total; //      

//----     
   for(bar=first; bar<rates_total && !IsStopped(); bar++)
     {
      double Clr=1;
      trend=LineBuffer[bar]-LineBuffer[bar-1];
      if(!trend) Clr=ColorLineBuffer[bar-1];
      else
        {
         if(trend>0) Clr=0;
         if(trend<0) Clr=2;
        }
      ColorLineBuffer[bar]=Clr;
     }
//----
   ChartRedraw(0);
   return(rates_total);
  }
//+------------------------------------------------------------------+
//|  RightPrice creation                                             |
//+------------------------------------------------------------------+
void CreateRightPrice(long chart_id,// chart ID
                      string   name,              // object name
                      int      nwin,              // window index
                      datetime time,              // price level time
                      double   price,             // price level
                      color    Color              // Text color
                      )
//---- 
  {
//----
   ObjectCreate(chart_id,name,OBJ_ARROW_RIGHT_PRICE,nwin,time,price);
   ObjectSetInteger(chart_id,name,OBJPROP_COLOR,Color);
   ObjectSetInteger(chart_id,name,OBJPROP_BACK,true);
   ObjectSetInteger(chart_id,name,OBJPROP_WIDTH,2);
//----
  }
//+------------------------------------------------------------------+
//|  RightPrice reinstallation                                       |
//+------------------------------------------------------------------+
void SetRightPrice(long chart_id,// chart ID
                   string   name,              // object name
                   int      nwin,              // window index
                   datetime time,              // price level time
                   double   price,             // price level
                   color    Color              // Text color
                   )
//---- 
  {
//----
   if(ObjectFind(chart_id,name)==-1) CreateRightPrice(chart_id,name,nwin,time,price,Color);
   else ObjectMove(chart_id,name,0,time,price);
//----
  }
//+------------------------------------------------------------------+
//|                                            |
//+------------------------------------------------------------------+
void CreateTline(
                 long     chart_id,      //  
                 string   name,          //  
                 int      nwin,          //  
                 datetime time1,         //  1  
                 double   price1,        // 1  
                 datetime time2,         //  2  
                 double   price2,        // 2  
                 color    Color,         //  
                 int      style,         //  
                 int      width,         //  
                 string   text           // 
                 )
//---- 
  {
//----
   ObjectCreate(chart_id,name,OBJ_TREND,nwin,time1,price1,time2,price2);
   ObjectSetInteger(chart_id,name,OBJPROP_COLOR,Color);
   ObjectSetInteger(chart_id,name,OBJPROP_STYLE,style);
   ObjectSetInteger(chart_id,name,OBJPROP_WIDTH,width);
   ObjectSetString(chart_id,name,OBJPROP_TEXT,text);
   ObjectSetInteger(chart_id,name,OBJPROP_BACK,true);
   ObjectSetInteger(chart_id,name,OBJPROP_RAY_RIGHT,false);
   ObjectSetInteger(chart_id,name,OBJPROP_SELECTED,false);
   ObjectSetInteger(chart_id,name,OBJPROP_SELECTABLE,false);
   ObjectSetInteger(chart_id,name,OBJPROP_ZORDER,true);
//----
  }
//+------------------------------------------------------------------+
//|                                       |
//+------------------------------------------------------------------+
void SetTline(
              long     chart_id,      //  
              string   name,          //  
              int      nwin,          //  
              datetime time1,         //  1  
              double   price1,        // 1  
              datetime time2,         //  2  
              double   price2,        // 2  
              color    Color,         //  
              int      style,         //  
              int      width,         //  
              string   text           // 
              )
//---- 
  {
//----
   if(ObjectFind(chart_id,name)==-1) CreateTline(chart_id,name,nwin,time1,price1,time2,price2,Color,style,width,text);
   else
     {
      ObjectSetString(chart_id,name,OBJPROP_TEXT,text);
      ObjectMove(chart_id,name,0,time1,price1);
      ObjectMove(chart_id,name,1,time2,price2);
      ObjectSetInteger(chart_id,name,OBJPROP_COLOR,Color);
      ObjectSetInteger(chart_id,name,OBJPROP_STYLE,style);
      ObjectSetInteger(chart_id,name,OBJPROP_WIDTH,width);
     }
//----
  }
//+------------------------------------------------------------------+
