//+------------------------------------------------------------------+ 
//|                                  AsymmetricStochNR_Cloud_HTF.mq5 | 
//|                               Copyright  2016, Nikolay Kositsin | 
//|                              Khabarovsk,   farria@mail.redcom.ru | 
//+------------------------------------------------------------------+ 
#property copyright "Copyright  2016, Nikolay Kositsin"
#property link "farria@mail.redcom.ru"
//---   
#property version   "1.60"
#property description "AsymmetricStochNR_Cloud       "
//----     
#property indicator_separate_window
//----    2
#property indicator_buffers 2 
//----    
#property indicator_plots   1
//+----------------------------------------------+
//|                            |
//+----------------------------------------------+
#define RESET 0                                           //        
#define INDICATOR_NAME "AsymmetricStochNR_Cloud"          //    
#define SIZE 1                                            //      CountIndicator 
//+----------------------------------------------+
//|     1            |
//+----------------------------------------------+
//----   1   
#property indicator_type1   DRAW_FILLING
//----    
#property indicator_color1  clrDeepSkyBlue,clrPlum
//----   
#property indicator_label1  "AsymmetricStochNR_Cloud"
//+----------------------------------------------+
//|                        |
//+----------------------------------------------+
enum Smooth_Method
  {
   MODE_SMA_,  // SMA
   MODE_EMA_,  // EMA
   MODE_SMMA_, // SMMA
   MODE_LWMA_, // LWMA
   MODE_JJMA,  // JJMA
   MODE_JurX,  // JurX
   MODE_ParMA, // ParMA
   MODE_T3,    // T3
   MODE_VIDYA, // VIDYA
   MODE_AMA,   // AMA
  };
//+----------------------------------------------+
//|                        |
//+----------------------------------------------+  
enum WIDTH
  {
   Width_1=1, // 1
   Width_2,   // 2
   Width_3,   // 3
   Width_4,   // 4
   Width_5    // 5
  };
//+----------------------------------------------+
//|                        |
//+----------------------------------------------+
enum STYLE
  {
   SOLID_,       //  
   DASH_,        //  
   DOT_,         //  
   DASHDOT_,     // - 
   DASHDOTDOT_   // -    
  };
//+----------------------------------------------+
//|                    |
//+----------------------------------------------+ 
input ENUM_TIMEFRAMES TimeFrame=PERIOD_H4;            //    ()
input uint KperiodShort=5;                   //  %K
input uint KperiodLong=12;                   //  %K
input Smooth_Method DMethod=MODE_SMA_;       //     
input uint Dperiod=7;                        //    %D
input int DPhase=15;                         //    
input uint Slowing=3;                        // 
input ENUM_STO_PRICE PriceField=STO_LOWHIGH; //     
input uint Sens=7;                           //   
input uint OverBought=80;                    //    %%
input uint OverSold=20;                      //    %%
input color UpLevelsColor=clrBlue;           //   
input color DnLevelsColor=clrMagenta;        //   
input STYLE Levelstyle=DASH_;                //  
input WIDTH  LevelsWidth=Width_1;            //  
input int Shift=0;                           //       
//+----------------------------------------------+
//---   ,   
//---      
double UpIndBuffer[];
double DnIndBuffer[];
//---      
int min_rates_total;
//---      
int Ind_Handle;
//+------------------------------------------------------------------+
//|                                    |
//+------------------------------------------------------------------+
string GetStringTimeframe(ENUM_TIMEFRAMES timeframe)
  {return(StringSubstr(EnumToString(timeframe),7,-1));}
//+------------------------------------------------------------------+    
//| Custom indicator initialization function                         | 
//+------------------------------------------------------------------+  
int OnInit()
  {
//---     
   if(!TimeFramesCheck(INDICATOR_NAME,TimeFrame)) return(INIT_FAILED);
//---   
   min_rates_total=2;
//---    AsymmetricStochNR_Cloud
   Ind_Handle=iCustom(Symbol(),TimeFrame,"AsymmetricStochNR_Cloud",
          KperiodShort,KperiodLong,DMethod,Dperiod,DPhase,Slowing,PriceField,Sens,OverBought,OverSold,0,0,0,0,0);
   if(Ind_Handle==INVALID_HANDLE)
     {
      Print("      AsymmetricStochNR_Cloud");
      return(INIT_FAILED);
     }
//---   
   IndInit(0,UpIndBuffer,INDICATOR_DATA);
   IndInit(1,DnIndBuffer,INDICATOR_DATA);
//---  
   PlotInit(0,EMPTY_VALUE,0,Shift);
//---           
   string shortname;
   StringConcatenate(shortname,INDICATOR_NAME,"(",GetStringTimeframe(TimeFrame),")");
   IndicatorSetString(INDICATOR_SHORTNAME,shortname);
//---     
   IndicatorSetInteger(INDICATOR_DIGITS,0);
//----     
   IndicatorSetInteger(INDICATOR_LEVELS,2);

   IndicatorSetDouble(INDICATOR_LEVELVALUE,0,OverSold);
   IndicatorSetInteger(INDICATOR_LEVELCOLOR,0,DnLevelsColor);
   IndicatorSetInteger(INDICATOR_LEVELSTYLE,0,Levelstyle);
   IndicatorSetInteger(INDICATOR_LEVELWIDTH,0,LevelsWidth);

   IndicatorSetDouble(INDICATOR_LEVELVALUE,1,OverBought);
   IndicatorSetInteger(INDICATOR_LEVELCOLOR,1,UpLevelsColor);
   IndicatorSetInteger(INDICATOR_LEVELSTYLE,1,Levelstyle);
   IndicatorSetInteger(INDICATOR_LEVELWIDTH,1,LevelsWidth);

//---  
   return(INIT_SUCCEEDED);
  }
//+------------------------------------------------------------------+  
//| Custom iteration function                                        | 
//+------------------------------------------------------------------+  
int OnCalculate(const int rates_total,    //       
                const int prev_calculated,//       
                const datetime &time[],
                const double &open[],
                const double &high[],
                const double &low[],
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[])
  {
//---       
   if(rates_total<min_rates_total) return(RESET);
   if(BarsCalculated(Ind_Handle)<Bars(Symbol(),TimeFrame)) return(prev_calculated);
//---         
   ArraySetAsSeries(time,true);
//---
   if(!CountIndicator(0,NULL,TimeFrame,Ind_Handle,0,UpIndBuffer,1,DnIndBuffer,time,rates_total,prev_calculated,min_rates_total))
      return(RESET);
//---     
   return(rates_total);
  }
//---
//+------------------------------------------------------------------+
//|                                  |
//+------------------------------------------------------------------+    
void IndInit(int Number,double &Buffer[],ENUM_INDEXBUFFER_TYPE Type)
  {
//---      
   SetIndexBuffer(Number,Buffer,Type);
//---       
   ArraySetAsSeries(Buffer,true);
//---
  }
//+------------------------------------------------------------------+
//|                                           |
//+------------------------------------------------------------------+    
void PlotInit(int Number,double Empty_Value,int Draw_Begin,int nShift)
  {
//---      
   PlotIndexSetInteger(Number,PLOT_DRAW_BEGIN,Draw_Begin);
//---   ,      
   PlotIndexSetDouble(Number,PLOT_EMPTY_VALUE,Empty_Value);
//---       Shift
   PlotIndexSetInteger(Number,PLOT_SHIFT,nShift);
//---
  }
//+------------------------------------------------------------------+
//| CountLine                                                        |
//+------------------------------------------------------------------+
bool CountIndicator(uint     Numb,            //   CountLine      (  - 0)
                    string   Symb,            //  
                    ENUM_TIMEFRAMES TFrame,   //  
                    int      IndHandle,       //   
                    uint     UpBuffNumb,      //       
                    double&  UpIndBuf[],      //      
                    uint     DnBuffNumb,      //       
                    double&  DnIndBuf[],      //      
                    const datetime& iTime[],  //  
                    const int Rates_Total,    //       
                    const int Prev_Calculated,//       
                    const int Min_Rates_Total)//       
  {
//---
   static int LastCountBar[SIZE];
   datetime IndTime[1];
   int limit;
//---     
//---    limit    
   if(Prev_Calculated>Rates_Total || Prev_Calculated<=0)//      
     {
      limit=Rates_Total-Min_Rates_Total-1; //      
      LastCountBar[Numb]=limit;
     }
   else limit=LastCountBar[Numb]+Rates_Total-Prev_Calculated; //       
//---    
   for(int bar=limit; bar>=0 && !IsStopped(); bar--)
     {
      //---       IndTime
      if(CopyTime(Symbol(),TFrame,iTime[bar],1,IndTime)<=0) return(RESET);

      if(iTime[bar]>=IndTime[0] && iTime[bar+1]<IndTime[0])
        {
         LastCountBar[Numb]=bar;
         double UpArr[1],DnArr[1];
         //---      
         if(CopyBuffer(IndHandle,UpBuffNumb,iTime[bar],1,UpArr)<=0) return(RESET);
         if(CopyBuffer(IndHandle,DnBuffNumb,iTime[bar],1,DnArr)<=0) return(RESET);
         
         UpIndBuf[bar]=UpArr[0]; 
         DnIndBuf[bar]=DnArr[0];
        }
      else
        {
         UpIndBuf[bar]=UpIndBuf[bar+1];
         DnIndBuf[bar]=DnIndBuf[bar+1];
        }
     }
//---     
   return(true);
  }
//+------------------------------------------------------------------+
//| TimeFramesCheck()                                                |
//+------------------------------------------------------------------+    
bool TimeFramesCheck(string IndName,
                     ENUM_TIMEFRAMES TFrame) //   ()
  {
//---     
   if(TFrame<Period() && TFrame!=PERIOD_CURRENT)
     {
      Print("    "+IndName+"       !");
      Print("    !");
      return(RESET);
     }
//---
   return(true);
  }
//+------------------------------------------------------------------+
