//+---------------------------------------------------------------------+
//|                                                              MC.mq5 |
//|                         Copyright  2005, MetaQuotes Software Corp. | 
//|                                           http://www.metaquotes.net | 
//+---------------------------------------------------------------------+ 
//|          SmoothAlgorithms.mqh |
//|   (): __\\MQL5\Include        |
//+---------------------------------------------------------------------+
#property copyright "Copyright  2005, MetaQuotes Software Corp."
#property link      "http://www.metaquotes.net"
//----   
#property version   "1.00"
//----     
#property indicator_separate_window 
//----    2
#property indicator_buffers 2 
//----     
#property indicator_plots   2
//+-----------------------------------+
//|       |
//+-----------------------------------+
//----        
#property indicator_type1   DRAW_FILLING
//----        SteelBlue  HotPink 
#property indicator_color1  clrSteelBlue,clrHotPink
//---   
#property indicator_label1  "XMACD Cloud"
//+-----------------------------------+
//|          |
//+-----------------------------------+
#include <SmoothAlgorithms.mqh> 
//+-----------------------------------+
//----    CXMA   SmoothAlgorithms.mqh
CXMA XMA1,XMA2,XMA3;
//+-----------------------------------+
//|             |
//+-----------------------------------+
enum Applied_price_ // 
  {
   PRICE_CLOSE_ = 1,     //Close
   PRICE_OPEN_,          //Open
   PRICE_HIGH_,          //High
   PRICE_LOW_,           //Low
   PRICE_MEDIAN_,        //Median Price (HL/2)
   PRICE_TYPICAL_,       //Typical Price (HLC/3)
   PRICE_WEIGHTED_,      //Weighted Close (HLCC/4)
   PRICE_SIMPL_,         //Simpl Price (OC/2)
   PRICE_QUARTER_,       //Quarted Price (HLOC/4) 
   PRICE_TRENDFOLLOW0_,  //TrendFollow_1 Price 
   PRICE_TRENDFOLLOW1_,  //TrendFollow_2 Price 
   PRICE_DEMARK_         //Demark Price 
  };
//+-----------------------------------+
//|             |
//+-----------------------------------+
/*enum Smooth_Method -     SmoothAlgorithms.mqh
  {
   MODE_SMA_,  //SMA
   MODE_EMA_,  //EMA
   MODE_SMMA_, //SMMA
   MODE_LWMA_, //LWMA
   MODE_JJMA,  //JJMA
   MODE_JurX,  //JurX
   MODE_ParMA, //ParMA
   MODE_T3,    //T3
   MODE_VIDYA, //VIDYA
   MODE_AMA,   //AMA
  }; */
//+-----------------------------------+
//|         |
//+-----------------------------------+
input Smooth_Method XMA_Method=MODE_T3; //  
input int Fast_XMA = 12; //  
input int Slow_XMA = 26; //  
input int XPhase = 100;  //  ,
//----  JJMA    -100 ... +100,     ;
//----  VIDIA   CMO,  AMA    
input Smooth_Method Signal_Method=MODE_JJMA; //   
input int Signal_XMA=9; //   
input int Signal_Phase=100; //   ,
//----    -100 ... +100,
//----     ;
input Applied_price_ AppliedPrice=PRICE_CLOSE_;// 
//+-----------------------------------+
//----      
int min_rates_total,min_rates_1;
//----   ,    
//      
double XMACDBuffer[],SignBuffer[];
//+------------------------------------------------------------------+    
//| XMACD indicator initialization function                          | 
//+------------------------------------------------------------------+  
void OnInit()
  {
//----     
   min_rates_1=MathMax(GetStartBars(XMA_Method,Fast_XMA,XPhase),GetStartBars(XMA_Method,Slow_XMA,XPhase));
   min_rates_total=min_rates_1+GetStartBars(Signal_Method,Signal_XMA,Signal_Phase)+2;

//----    XMACDBuffer   
   SetIndexBuffer(0,XMACDBuffer,INDICATOR_DATA); 
//----    SignBuffer   
   SetIndexBuffer(1,SignBuffer,INDICATOR_DATA);
   
//----      
   PlotIndexSetInteger(0,PLOT_DRAW_BEGIN,min_rates_total);
//----   ,      
   PlotIndexSetDouble(0,PLOT_EMPTY_VALUE,EMPTY_VALUE);

//----       
   XMA1.XMALengthCheck("Fast_XMA", Fast_XMA);
   XMA1.XMALengthCheck("Slow_XMA", Slow_XMA);
   XMA1.XMALengthCheck("Signal_XMA", Signal_XMA);
//----       
   XMA1.XMAPhaseCheck("XPhase", XPhase, XMA_Method);
   XMA1.XMAPhaseCheck("Signal_Phase", Signal_Phase, Signal_Method);

//----      
   string shortname;
   string Smooth1=XMA1.GetString_MA_Method(XMA_Method);
   string Smooth2=XMA1.GetString_MA_Method(Signal_Method);
   StringConcatenate(shortname,
                     "XMACD( ",Fast_XMA,", ",Slow_XMA,", ",Signal_XMA,", ",Smooth1,", ",Smooth2," )");
//---           
   IndicatorSetString(INDICATOR_SHORTNAME,shortname);
//---     
   IndicatorSetInteger(INDICATOR_DIGITS,0);
//----  
  }
//+------------------------------------------------------------------+  
//| XMACD iteration function                                         | 
//+------------------------------------------------------------------+  
int OnCalculate(
                const int rates_total,    //       
                const int prev_calculated,//       
                const datetime &time[],
                const double &open[],
                const double &high[],
                const double &low[],
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[]
                )
  {
//----       
   if(rates_total<min_rates_total) return(0);

//----   
   int first,bar;
//----       
   double price,fast_xma,slow_xma,xmacd,sign_xma;

//----     OnCalculate()
   if(prev_calculated>rates_total || prev_calculated<=0)//      
     {
      first=0; //        
     }
   else //      
     {
      first=prev_calculated-1;
     }

//----    
   for(bar=first; bar<rates_total; bar++)
     {
      price=PriceSeries(AppliedPrice,bar,open,low,high,close);;
      fast_xma=XMA1.XMASeries(0,prev_calculated,rates_total,XMA_Method,XPhase,Fast_XMA,price,bar,false);
      slow_xma=XMA2.XMASeries(0,prev_calculated,rates_total,XMA_Method,XPhase,Slow_XMA,price,bar,false);
      xmacd=fast_xma-slow_xma;
      sign_xma=XMA3.XMASeries(min_rates_1,prev_calculated,rates_total,Signal_Method,Signal_Phase,Signal_XMA,xmacd,bar,false);
      //----            
      XMACDBuffer[bar]= xmacd/_Point;
      SignBuffer[bar] = sign_xma/_Point;
     }
//----     
   return(rates_total);
  }
//+------------------------------------------------------------------+
