//+------------------------------------------------------------------+
//|                                                   ResSupFibo.mq5 |
//|                               Copyright  2016, Nikolay Kositsin | 
//|                              Khabarovsk,   farria@mail.redcom.ru | 
//+------------------------------------------------------------------+
//----  
#property copyright "Copyright  2016, Nikolay Kositsin"
//----    
#property link      "farria@mail.redcom.ru"
//----   
#property version   "1.00"
//----     
#property indicator_chart_window 
//----        
#property indicator_buffers 0
//----    
#property indicator_plots  0
//+----------------------------------------------+
//|                            |
//+----------------------------------------------+
#define RESET 0       //        
//+----------------------------------------------+
//|                        |
//+----------------------------------------------+
enum Number
  {
   Number_0,
   Number_1,
   Number_2,
   Number_3
  };
//+----------------------------------------------+
//|                        |
//+----------------------------------------------+  
enum Width
  {
   width_1=1, //1
   width_2,   //2
   width_3,   //3
   width_4,   //4
   width_5    //5
  };
//+----------------------------------------------+
//|                        |
//+----------------------------------------------+
enum STYLE
  {
   SOLID_,// 
   DASH_,// 
   DOT_,// 
   DASHDOT_,//- 
   DASHDOTDOT_   //-    
  };
//+----------------------------------------------+
//|                    |
//+----------------------------------------------+
input string  SirName="ResSup";             //    
input ENUM_TIMEFRAMES TimeFrame=PERIOD_H1;  //    
input uint SignalBar=1;                     //    
input uint  iPeriod=24;                     //   
input uint  iSize=15;                       //     
input uint  Digits_=0;                      //  
input color  Color_Bg = clrLavender;        // 
//----
input color  Color_Up = clrDodgerBlue;      //  
input STYLE  Style_Up = SOLID_;             //  
input Width  Width_Up = width_4;            //  
//----
input color  Color_1 = clrBlueViolet;       // - 0.764
input STYLE  Style_1 = DASHDOTDOT_;         // - 0.764
input Width  Width_1 = width_1;             // - 0.764
//----
input color  Color_2 = clrDarkOrange;       // - 0.618
input STYLE  Style_2 = DASH_;               // - 0.618
input Width  Width_2 = width_1;             // - 0.618
//----
input color  Color_3= clrGray;              // - 0.5
input STYLE  Style_3 = SOLID_;              //  - 0.5
input Width  Width_3 = width_1;             //  - 0.5
//----
input color  Color_4 = clrDarkOrange;       //  - 0.382
input STYLE  Style_4 = DASH_;               // - 0.382
input Width  Width_4 = width_1;             // - 0.382
//----
input color  Color_5 = clrBlueViolet;       // - 0.236
input STYLE  Style_5 = DASHDOTDOT_;         // - 0.236
input Width  Width_5 = width_1;             // - 0.236
//----
input color  Color_Dn = clrMagenta;         //  
input STYLE  Style_Dn = SOLID_;             //  
input Width  Width_Dn = width_4;            //  
//----
input uint FontSize=2;                    //  
//+----------------------------------------------+
double iLow[],iHigh[],PointPow10;
int min_rates_total1,min_rates_total2;
string UpLinesName,UpPriceName,DnLinesName,DnPriceName,BgName,LinesName1,PriceName1;
string LinesName2,PriceName2,LinesName3,PriceName3,LinesName4,PriceName4,LinesName5,PriceName5;
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+  
void OnInit()
  {
//----      
   ArrayResize(iLow,iPeriod);
   ArrayResize(iHigh,iPeriod);
//----    
   UpLinesName=SirName+" UpLine";
   UpPriceName=SirName+" UpPrice";
   LinesName1=SirName+" Line1";
   LinesName2=SirName+" Line2";
   LinesName3=SirName+" Line3";
   LinesName4=SirName+" Line4";
   LinesName5=SirName+" Line5";
   DnLinesName=SirName+" DnLine";
   DnPriceName=SirName+" DnPrice";
   BgName=SirName+" Bg";
//----    
   min_rates_total1=int(iPeriod+SignalBar);
   min_rates_total2=int(iSize);
   double Pow10=MathPow(10,Digits_);
   PointPow10=_Point*Pow10;
//----
  }
//+------------------------------------------------------------------+
//| Custom indicator deinitialization function                       |
//+------------------------------------------------------------------+    
void OnDeinit(const int reason)
  {
//----
   ObjectDelete(0,UpLinesName);
   ObjectDelete(0,UpPriceName);
   ObjectDelete(0,LinesName1);
   ObjectDelete(0,LinesName2);
   ObjectDelete(0,LinesName3);
   ObjectDelete(0,LinesName4);
   ObjectDelete(0,LinesName5);
   ObjectDelete(0,DnLinesName);
   ObjectDelete(0,DnPriceName);
   ObjectDelete(0,BgName);
//----
   ChartRedraw(0);
  }
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int OnCalculate(
                const int rates_total,    //       
                const int prev_calculated,//       
                const datetime &time[],
                const double &open[],
                const double& high[],     //       
                const double& low[],      //        
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[]
                )
  {
//----       
   if(Bars(Symbol(),TimeFrame)<min_rates_total1 || rates_total<min_rates_total2) return(RESET);
//----        
   if(CopyLow(Symbol(),TimeFrame,SignalBar,iPeriod,iLow)<=0) return(RESET);
   if(CopyHigh(Symbol(),TimeFrame,SignalBar,iPeriod,iHigh)<=0) return(RESET);
   double Min=PointPow10*MathRound(iLow[ArrayMinimum(iLow,0,WHOLE_ARRAY)]/PointPow10);
   double Max=PointPow10*MathRound(iHigh[ArrayMaximum(iHigh,0,WHOLE_ARRAY)]/PointPow10);
   datetime time1=time[rates_total-iSize];
   datetime time2=time[rates_total-1];
   double Range=Max-Min;
   double Level1=Min+Range*0.764;
   double Level2=Min+Range*0.618;
   double Level3=Min+Range*0.500;
   double Level4=Min+Range*0.382;
   double Level5=Min+Range*0.236;
   SetRectangle(0,BgName,0,time1,Min,time2,Max,Color_Bg,SOLID_,Width_1,"");
   SetTline(0,UpLinesName,0,time1,Min,time2,Min,Color_Dn,Style_Dn,Width_Dn,DoubleToString(Min,_Digits));
   SetTline(0,LinesName1,0,time1,Level1,time2,Level1,Color_1,Style_1,Width_1,DoubleToString(Level1,_Digits));
   SetTline(0,LinesName2,0,time1,Level2,time2,Level2,Color_2,Style_2,Width_2,DoubleToString(Level2,_Digits));
   SetTline(0,LinesName3,0,time1,Level3,time2,Level3,Color_3,Style_3,Width_3,DoubleToString(Level3,_Digits));
   SetTline(0,LinesName4,0,time1,Level4,time2,Level4,Color_4,Style_4,Width_4,DoubleToString(Level4,_Digits));
   SetTline(0,LinesName5,0,time1,Level5,time2,Level5,Color_5,Style_5,Width_5,DoubleToString(Level5,_Digits));
   SetTline(0,DnLinesName,0,time1,Max,time2,Max,Color_Up,Style_Up,Width_Up,DoubleToString(Max,_Digits));
   SetRightPrice(0,DnPriceName,0,time2,Min,Color_Dn,FontSize);
   SetRightPrice(0,UpPriceName,0,time2,Max,Color_Up,FontSize);
//----
   ChartRedraw(0);
   return(rates_total);
  }
//+------------------------------------------------------------------+
//|                                            |
//+------------------------------------------------------------------+
void CreateRectangle(long     chart_id,      //  
                     string   name,          //  
                     int      nwin,          //  
                     datetime time1,         //  1  
                     double   price1,        // 1  
                     datetime time2,         //  2  
                     double   price2,        // 2  
                     color    Color,         //  
                     int      style,         //  
                     int      width,         //  
                     string   text)          // 
  {
//----
   ObjectCreate(chart_id,name,OBJ_RECTANGLE,nwin,time1,price1,time2,price2);
   ObjectSetInteger(chart_id,name,OBJPROP_COLOR,Color);
   ObjectSetInteger(chart_id,name,OBJPROP_STYLE,style);
   ObjectSetInteger(chart_id,name,OBJPROP_WIDTH,width);
   ObjectSetString(chart_id,name,OBJPROP_TEXT,text);
   ObjectSetInteger(chart_id,name,OBJPROP_BACK,true);
   ObjectSetInteger(chart_id,name,OBJPROP_FILL,true);
   ObjectSetInteger(chart_id,name,OBJPROP_SELECTED,false);
   ObjectSetInteger(chart_id,name,OBJPROP_SELECTABLE,true);
   ObjectSetInteger(chart_id,name,OBJPROP_ZORDER,true);
//----
  }
//+------------------------------------------------------------------+
//|                                       |
//+------------------------------------------------------------------+
void SetRectangle(long     chart_id,      //  
                  string   name,          //  
                  int      nwin,          //  
                  datetime time1,         //  1  
                  double   price1,        // 1  
                  datetime time2,         //  2  
                  double   price2,        // 2  
                  color    Color,         //  
                  int      style,         //  
                  int      width,         //  
                  string   text)          // 
  {
//----
   if(ObjectFind(chart_id,name)==-1) CreateRectangle(chart_id,name,nwin,time1,price1,time2,price2,Color,style,width,text);
   else
     {
      ObjectSetString(chart_id,name,OBJPROP_TEXT,text);
      ObjectMove(chart_id,name,0,time1,price1);
      ObjectMove(chart_id,name,1,time2,price2);
      ObjectSetInteger(chart_id,name,OBJPROP_COLOR,Color);
     }
//----
  }
//+------------------------------------------------------------------+
//|                                            |
//+------------------------------------------------------------------+
void CreateTline(long     chart_id,      //  
                 string   name,          //  
                 int      nwin,          //  
                 datetime time1,         //  1  
                 double   price1,        // 1  
                 datetime time2,         //  2  
                 double   price2,        // 2  
                 color    Color,         //  
                 int      style,         //  
                 int      width,         //  
                 string   text)          // 
  {
//----
   ObjectCreate(chart_id,name,OBJ_TREND,nwin,time1,price1,time2,price2);
   ObjectSetInteger(chart_id,name,OBJPROP_COLOR,Color);
   ObjectSetInteger(chart_id,name,OBJPROP_STYLE,style);
   ObjectSetInteger(chart_id,name,OBJPROP_WIDTH,width);
   ObjectSetString(chart_id,name,OBJPROP_TEXT,text);
   ObjectSetInteger(chart_id,name,OBJPROP_BACK,true);
//ObjectSetInteger(chart_id,name,OBJPROP_RAY_RIGHT,true);
   ObjectSetInteger(chart_id,name,OBJPROP_RAY,true);
//ObjectSetInteger(chart_id,name,OBJPROP_SELECTED,true);
//ObjectSetInteger(chart_id,name,OBJPROP_SELECTABLE,true);
   ObjectSetInteger(chart_id,name,OBJPROP_ZORDER,true);
//----
  }
//+------------------------------------------------------------------+
//|                                       |
//+------------------------------------------------------------------+
void SetTline(long     chart_id,      //  
              string   name,          //  
              int      nwin,          //  
              datetime time1,         //  1  
              double   price1,        // 1  
              datetime time2,         //  2  
              double   price2,        // 2  
              color    Color,         //  
              int      style,         //  
              int      width,         //  
              string   text)          // 
  {
//----
   if(ObjectFind(chart_id,name)==-1) CreateTline(chart_id,name,nwin,time1,price1,time2,price2,Color,style,width,text);
   else
     {
      ObjectSetString(chart_id,name,OBJPROP_TEXT,text);
      ObjectMove(chart_id,name,0,time1,price1);
      ObjectMove(chart_id,name,1,time2,price2);
      ObjectSetInteger(chart_id,name,OBJPROP_COLOR,Color);
     }
//----
  }
//+------------------------------------------------------------------+
//|  RightPrice creation                                             |
//+------------------------------------------------------------------+
void CreateRightPrice(long chart_id,// chart ID
                      string   name,              // object name
                      int      nwin,              // window index
                      datetime time,              // price level time
                      double   price,             // price level
                      color    Color,             // Text color
                      int      fontsize           // Text font
                      )
//---- 
  {
//----
   ObjectCreate(chart_id,name,OBJ_ARROW_RIGHT_PRICE,nwin,time,price);
   ObjectSetInteger(chart_id,name,OBJPROP_COLOR,Color);
   ObjectSetInteger(chart_id,name,OBJPROP_BACK,true);
   ObjectSetInteger(chart_id,name,OBJPROP_WIDTH,fontsize);
//----
  }
//+------------------------------------------------------------------+
//|  RightPrice reinstallation                                       |
//+------------------------------------------------------------------+
void SetRightPrice(long chart_id,// chart ID
                   string   name,              // object name
                   int      nwin,              // window index
                   datetime time,              // price level time
                   double   price,             // price level
                   color    Color,             // Text color
                   int      fontsize           // Text font
                   )
//---- 
  {
//----
   if(ObjectFind(chart_id,name)==-1) CreateRightPrice(chart_id,name,nwin,time,price,Color,fontsize);
   else ObjectMove(chart_id,name,0,time,price);
//----
  }
//+------------------------------------------------------------------+
