//+------------------------------------------------------------------+
//|                                                  AdaptiveRVI.mq5 |
//|                                                                  |
//| Adaptive RVI                                                     |
//|                                                                  |
//| Algorithm taken from book                                        |
//|     "Cybernetics Analysis for Stock and Futures"                 |
//| by John F. Ehlers                                                |
//|                                                                  |
//|                                              contact@mqlsoft.com |
//|                                          http://www.mqlsoft.com/ |
//+------------------------------------------------------------------+
//----  
#property copyright "Coded by Witold Wozniak"
//----  
#property link      "www.mqlsoft.com"
//----   
#property version   "1.00"
//----     
#property indicator_separate_window
//----        
#property indicator_buffers 2
//----    
#property indicator_plots   2
//+----------------------------------------------+
//|    Adaptive RVI  |
//+----------------------------------------------+
//----   1   
#property indicator_type1   DRAW_LINE
//----         Red
#property indicator_color1  Red
//----   1 -  
#property indicator_style1  STYLE_SOLID
//----    1  1
#property indicator_width1  1
//----    
#property indicator_label1  "Adaptive RVI"
//+----------------------------------------------+
//|    Trigger       |
//+----------------------------------------------+
//----   2   
#property indicator_type2   DRAW_LINE
//----         Blue
#property indicator_color2  Blue
//----   2 -  
#property indicator_style2  STYLE_SOLID
//----    2  1
#property indicator_width2  1
//----    
#property indicator_label2  "Trigger"
//+----------------------------------------------+
//|     |
//+----------------------------------------------+
#property indicator_level1 0.0
#property indicator_levelcolor Gray
#property indicator_levelstyle STYLE_DASHDOTDOT
//+----------------------------------------------+
//|                            |
//+----------------------------------------------+
#define RESET 0       //        
#define MAXPERIOD 100 //     
//+----------------------------------------------+
//|                    |
//+----------------------------------------------+
input double Alpha=0.07;  //    
input int Shift=0;        //       
//+----------------------------------------------+
//----   ,   
//----      
double ARVIBuffer[];
double TriggerBuffer[];
//----      
int CP_Handle;
//----      
int min_rates_total;
//----   
int Count[];
double Value1[],Value2[];
//+------------------------------------------------------------------+
//|                       |
//+------------------------------------------------------------------+   
void Recount_ArrayZeroPos(int &CoArr[],//        
                          int Size)
  {
//----
   int numb,Max1,Max2;
   static int count=1;

   Max2=Size;
   Max1=Max2-1;

   count--;
   if(count<0) count=Max1;

   for(int iii=0; iii<Max2; iii++)
     {
      numb=iii+count;
      if(numb>Max1) numb-=Max2;
      CoArr[iii]=numb;
     }
//----
  }
//+------------------------------------------------------------------+
//|                          |
//+------------------------------------------------------------------+   
double Get_dPrice(const double  &Price1[],const double  &Price2[],int bar)
  {
//----
   return(Price1[bar]-Price2[bar]);
  }
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+  
int OnInit()
  {
//----     
   min_rates_total=4;

//----    CyclePeriod
   CP_Handle=iCustom(NULL,0,"CyclePeriod",Alpha);
   if(CP_Handle==INVALID_HANDLE)
     {
      Print("      CyclePeriod");
      return(1);
     }

//----       
   ArrayResize(Count,MAXPERIOD);
   ArrayResize(Value1,MAXPERIOD);
   ArrayResize(Value2,MAXPERIOD);
   
   ArrayInitialize(Count,0);
   ArrayInitialize(Value1,0.0);
   ArrayInitialize(Value2,0.0);

//----    ARVIBuffer[]   
   SetIndexBuffer(0,ARVIBuffer,INDICATOR_DATA);
//----    1    Shift
   PlotIndexSetInteger(0,PLOT_SHIFT,Shift);
//----       1  min_rates_total
   PlotIndexSetInteger(0,PLOT_DRAW_BEGIN,min_rates_total);
//----   ,      
   PlotIndexSetDouble(0,PLOT_EMPTY_VALUE,EMPTY_VALUE);

//----    TriggerBuffer[]   
   SetIndexBuffer(1,TriggerBuffer,INDICATOR_DATA);
//----    2    Shift
   PlotIndexSetInteger(1,PLOT_SHIFT,Shift);
//----       2  min_rates_total+1
   PlotIndexSetInteger(1,PLOT_DRAW_BEGIN,min_rates_total+1);
//----   ,      
   PlotIndexSetDouble(1,PLOT_EMPTY_VALUE,EMPTY_VALUE);

//----      
   string shortname;
   StringConcatenate(shortname,"Adaptive RVI(",DoubleToString(Alpha,4),", ",Shift,")");
//----           
   IndicatorSetString(INDICATOR_SHORTNAME,shortname);
//----     
   IndicatorSetInteger(INDICATOR_DIGITS,2);
   
   return(0);
//----
  }
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int OnCalculate(const int rates_total,    //       
                const int prev_calculated,//       
                const datetime &time[],
                const double &open[],
                const double& high[],     //       
                const double& low[],      //        
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[])
  {
//----       
   if(BarsCalculated(CP_Handle)<rates_total || rates_total<min_rates_total) return(RESET);

//----    
   int first,bar,Length;
   double Num,Denom,rvi,period[4];

//----    first    
   if(prev_calculated>rates_total || prev_calculated<=0) //      
      first=3;                   //      
   else first=prev_calculated-1; //      

//----    
   for(bar=first; bar<rates_total && !IsStopped(); bar++)
     {
      //----      
      if(CopyBuffer(CP_Handle,0,rates_total-1-bar,4,period)<=0) return(RESET);

      Length=int(MathFloor((4.0*period[3]+3.0*period[2]+2.0*period[1]+period[0])/20.0));
      if(bar<Length) Length=bar; //      

      Value1[Count[0]]=(Get_dPrice(close,open,bar)
                        +2.0*Get_dPrice(close,open,bar-1)
                        +2.0*Get_dPrice(close,open,bar-2)
                        +Get_dPrice(close,open,bar-3))/6.0;

      Value2[Count[0]]=(Get_dPrice(high,low,bar)
                        +2.0*Get_dPrice(high,low,bar-1)
                        +2.0*Get_dPrice(high,low,bar-2)
                        +Get_dPrice(high,low,bar-3))/6.0;

      Num=0.0;
      Denom=0.0;

      for(int iii=0; iii<Length; iii++)
        {
         Num+=Value1[Count[iii]];
         Denom+=Value2[Count[iii]];
        }

      if(Denom!=0.0) rvi=Num/Denom;
      else rvi=EMPTY_VALUE;

      ARVIBuffer[bar]=rvi;
      TriggerBuffer[bar]=ARVIBuffer[bar-1];

      if(bar<rates_total-1) Recount_ArrayZeroPos(Count,MAXPERIOD);
     }
//----     
   return(rates_total);
  }
//+------------------------------------------------------------------+
