//+---------------------------------------------------------------------+
//|                                               ColorXdinMA_StDev.mq5 | 
//|                                          Copyright  2011,   dimeon | 
//|                                                                     | 
//+---------------------------------------------------------------------+ 
//|          SmoothAlgorithms.mqh |
//|   (): __\\MQL5\Include        |
//+---------------------------------------------------------------------+
#property copyright "Copyright  2011, dimeon"
#property link ""
//----   
#property version   "1.03"
//----     
#property indicator_chart_window
//----        
#property indicator_buffers 6
//----     
#property indicator_plots   5
//+-----------------------------------+
//|       |
//+-----------------------------------+
//----      
#property indicator_type1   DRAW_COLOR_LINE
//----      
#property indicator_color1  clrYellow,clrBlue,clrRed
//----   -  
#property indicator_style1  STYLE_SOLID
//----     2
#property indicator_width1  2
//----   
#property indicator_label1  "XdinMA"
//+----------------------------------------------+
//|        |
//+----------------------------------------------+
//----   2   
#property indicator_type2   DRAW_ARROW
//----        
#property indicator_color2  clrMagenta
//----    2  2
#property indicator_width2  2
//----    
#property indicator_label2  "Dn_Signal 1"
//+----------------------------------------------+
//|            |
//+----------------------------------------------+
//----   3   
#property indicator_type3   DRAW_ARROW
//----        
#property indicator_color3  clrDeepSkyBlue
//----    3  2
#property indicator_width3  2
//----    
#property indicator_label3  "Up_Signal 1"
//+----------------------------------------------+
//|        |
//+----------------------------------------------+
//----   4   
#property indicator_type4   DRAW_ARROW
//----        
#property indicator_color4  clrMagenta
//----    4  4
#property indicator_width4  4
//----    
#property indicator_label4  "Dn_Signal 2"
//+----------------------------------------------+
//|            |
//+----------------------------------------------+
//----   5   
#property indicator_type5   DRAW_ARROW
//----        
#property indicator_color5  clrDeepSkyBlue
//----    5  4
#property indicator_width5  4
//----    
#property indicator_label5  "Up_Signal 2"
//+-----------------------------------+
//|    CXMA             |
//+-----------------------------------+
#include <SmoothAlgorithms.mqh> 
//+-----------------------------------+

//----    CXMA   SmoothAlgorithms.mqh
CXMA XMA1,XMA2;
//+-----------------------------------+
//|             |
//+-----------------------------------+
enum Applied_price_ // 
  {
   PRICE_CLOSE_ = 1,     //Close
   PRICE_OPEN_,          //Open
   PRICE_HIGH_,          //High
   PRICE_LOW_,           //Low
   PRICE_MEDIAN_,        //Median Price (HL/2)
   PRICE_TYPICAL_,       //Typical Price (HLC/3)
   PRICE_WEIGHTED_,      //Weighted Close (HLCC/4)
   PRICE_SIMPL_,         //Simpl Price (OC/2)
   PRICE_QUARTER_,       //Quarted Price (HLOC/4) 
   PRICE_TRENDFOLLOW0_,  //TrendFollow_1 Price 
   PRICE_TRENDFOLLOW1_,  //TrendFollow_2 Price 
   PRICE_DEMARK_         //Demark Price
  };
//+-----------------------------------+
//|             |
//+-----------------------------------+
/*enum Smooth_Method -     SmoothAlgorithms.mqh
  {
   MODE_SMA_,  //SMA
   MODE_EMA_,  //EMA
   MODE_SMMA_, //SMMA
   MODE_LWMA_, //LWMA
   MODE_JJMA,  //JJMA
   MODE_JurX,  //JurX
   MODE_ParMA, //ParMA
   MODE_T3,    //T3
   MODE_VIDYA, //VIDYA
   MODE_AMA,   //AMA
  }; */
//+-----------------------------------+
//|         |
//+-----------------------------------+
input Smooth_Method MA_Method1=MODE_SMA_; // 
input int Length_main=10; // main 
input int Length_plus=20; // plus                   
input int PhaseX=15; // ,
                     // JJMA    -100 ... +100,     ;
//  VIDIA   CMO,  AMA    
input Applied_price_ IPC=PRICE_CLOSE_;// 
input double dK1=1.5;  // 1   
input double dK2=2.5;  // 2   
input uint std_period=9; //  
input int Shift=0; //      
input int PriceShift=0; // c     
//+-----------------------------------+

//----   ,    
//      
double XdinMA[],ColorXdinMA[];
double BearsBuffer1[],BullsBuffer1[];
double BearsBuffer2[],BullsBuffer2[];
//----      
double dPriceShift;
double dXdinMA[];
//----      
int  min_rates_total;
//+------------------------------------------------------------------+   
//| XdinMA indicator initialization function                         | 
//+------------------------------------------------------------------+ 
void OnInit()
  {
//----     
   int StartBars1=XMA1.GetStartBars(MA_Method1, Length_main, PhaseX);
   int StartBars2=XMA2.GetStartBars(MA_Method1, Length_plus, PhaseX);
   min_rates_total=MathMax(StartBars1,StartBars2)+1+int(std_period);
//----       
   XMA1.XMALengthCheck("Length_main", Length_main);
   XMA2.XMALengthCheck("Length_plus", Length_plus);
//----       
   XMA1.XMAPhaseCheck("PhaseX",PhaseX,MA_Method1);

//----    
   dPriceShift=_Point*PriceShift;
//----       
   ArrayResize(dXdinMA,std_period);

//----      
   SetIndexBuffer(0,XdinMA,INDICATOR_DATA);
//----    1  
   PlotIndexSetInteger(0,PLOT_SHIFT,Shift);
//----      
   PlotIndexSetInteger(0,PLOT_DRAW_BEGIN,min_rates_total);
//----   ,      
   PlotIndexSetDouble(0,PLOT_EMPTY_VALUE,EMPTY_VALUE);

//----     ,     
   SetIndexBuffer(1,ColorXdinMA,INDICATOR_COLOR_INDEX);

//----    BearsBuffer   
   SetIndexBuffer(2,BearsBuffer1,INDICATOR_DATA);
//----    2  
   PlotIndexSetInteger(1,PLOT_SHIFT,Shift);
//----      
   PlotIndexSetInteger(1,PLOT_DRAW_BEGIN,min_rates_total);
//----    
   PlotIndexSetInteger(1,PLOT_ARROW,159);
//----      
   PlotIndexSetDouble(1,PLOT_EMPTY_VALUE,EMPTY_VALUE);

//----    BullsBuffer   
   SetIndexBuffer(3,BullsBuffer1,INDICATOR_DATA);
//----    3  
   PlotIndexSetInteger(2,PLOT_SHIFT,Shift);
//----      
   PlotIndexSetInteger(2,PLOT_DRAW_BEGIN,min_rates_total);
//----    
   PlotIndexSetInteger(2,PLOT_ARROW,159);
//----      
   PlotIndexSetDouble(2,PLOT_EMPTY_VALUE,EMPTY_VALUE);

//----    BearsBuffer   
   SetIndexBuffer(4,BearsBuffer2,INDICATOR_DATA);
//----    2  
   PlotIndexSetInteger(3,PLOT_SHIFT,Shift);
//----      
   PlotIndexSetInteger(3,PLOT_DRAW_BEGIN,min_rates_total);
//----    
   PlotIndexSetInteger(3,PLOT_ARROW,159);
//----      
   PlotIndexSetDouble(3,PLOT_EMPTY_VALUE,EMPTY_VALUE);

//----    BullsBuffer   
   SetIndexBuffer(5,BullsBuffer2,INDICATOR_DATA);
//----    3  
   PlotIndexSetInteger(4,PLOT_SHIFT,Shift);
//----      
   PlotIndexSetInteger(4,PLOT_DRAW_BEGIN,min_rates_total);
//----    
   PlotIndexSetInteger(4,PLOT_ARROW,159);
//----      
   PlotIndexSetDouble(4,PLOT_EMPTY_VALUE,EMPTY_VALUE);

//----      
   string shortname;
   string Smooth=XMA1.GetString_MA_Method(MA_Method1);
   StringConcatenate(shortname,"XdinMA(",Length_main,", ",Length_plus,", ",Smooth,")");
//---           
   IndicatorSetString(INDICATOR_SHORTNAME,shortname);

//---     
   IndicatorSetInteger(INDICATOR_DIGITS,_Digits+1);
//----  
  }
//+------------------------------------------------------------------+ 
//| XdinMA iteration function                                        | 
//+------------------------------------------------------------------+ 
int OnCalculate(
                const int rates_total,    //       
                const int prev_calculated,//       
                const datetime &time[],
                const double &open[],
                const double &high[],
                const double &low[],
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[]
                )
  {
//----       
   if(rates_total<min_rates_total) return(0);

//----       
   double price_,ma_main,ma_plus;
//----        
   int first1,first2,bar;
   double xdinma,SMAdif,Sum,StDev,dstd,BEARS1,BULLS1,BEARS2,BULLS2,Filter1,Filter2;

//----    first    
   if(prev_calculated>rates_total || prev_calculated<=0) //      
     {
      first1=0; //      
      first2=min_rates_total;
     }
   else
     {
      first1=prev_calculated-1; //      
      first2=first1;
     }

//----    
   for(bar=first1; bar<rates_total && !IsStopped(); bar++)
     {
      //----   PriceSeries     price_
      price_=PriceSeries(IPC,bar,open,low,high,close);

      //----    XMASeries.   
      ma_main = XMA1.XMASeries(0, prev_calculated, rates_total, MA_Method1, PhaseX, Length_main, price_, bar, false);
      ma_plus = XMA2.XMASeries(0, prev_calculated, rates_total, MA_Method1, PhaseX, Length_plus, price_, bar, false);
      //----       
      XdinMA[bar]=ma_main*2-ma_plus+dPriceShift;
     }

//----    
   for(bar=first2; bar<rates_total; bar++)
     {
      ColorXdinMA[bar]=0;
      if(XdinMA[bar-1]<XdinMA[bar]) ColorXdinMA[bar]=1;
      if(XdinMA[bar-1]>XdinMA[bar]) ColorXdinMA[bar]=2;
     }
     
//----    first    
   if(prev_calculated>rates_total || prev_calculated<=0) //      
      first1=min_rates_total;
//----      
   for(bar=first1; bar<rates_total && !IsStopped(); bar++)
     {
      //----        
      for(int iii=0; iii<int(std_period); iii++) dXdinMA[iii]=XdinMA[bar-iii]-XdinMA[bar-iii-1];

      //----     
      Sum=0.0;
      for(int iii=0; iii<int(std_period); iii++) Sum+=dXdinMA[iii];
      SMAdif=Sum/std_period;

      //----       
      Sum=0.0;
      for(int iii=0; iii<int(std_period); iii++) Sum+=MathPow(dXdinMA[iii]-SMAdif,2);

      //----      StDev   
      StDev=MathSqrt(Sum/std_period);

      //----  
      dstd=NormalizeDouble(dXdinMA[0],_Digits+2);
      Filter1=NormalizeDouble(dK1*StDev,_Digits+2);
      Filter2=NormalizeDouble(dK2*StDev,_Digits+2);
      BEARS1=EMPTY_VALUE;
      BULLS1=EMPTY_VALUE;
      BEARS2=EMPTY_VALUE;
      BULLS2=EMPTY_VALUE;
      xdinma=XdinMA[bar];

      //----   
      if(dstd<-Filter1 && dstd>=-Filter2) BEARS1=xdinma; //  
      if(dstd<-Filter2) BEARS2=xdinma; //  
      if(dstd>+Filter1 && dstd<=+Filter2) BULLS1=xdinma; //  
      if(dstd>+Filter2) BULLS2=xdinma; //  

      //----       
      BullsBuffer1[bar]=BULLS1;
      BearsBuffer1[bar]=BEARS1;
      BullsBuffer2[bar]=BULLS2;
      BearsBuffer2[bar]=BEARS2;
     }
//----     
   return(rates_total);
  }
//+------------------------------------------------------------------+
