//+---------------------------------------------------------------------+
//|                                                True_Range_Bands.mq5 | 
//|                              Copyright  2010, basisforex@gmail.com | 
//|                                                basisforex@gmail.com | 
//+---------------------------------------------------------------------+ 
//|          SmoothAlgorithms.mqh |
//|   (): __\\MQL5\Include        |
//+---------------------------------------------------------------------+
#property copyright "Copyright  2012, basisforex@gmail.com"
#property link "basisforex@gmail.com"
#property description "True Range Bands"

//----   
#property version   "1.10"
//----     
#property indicator_chart_window 
//----    2
#property indicator_buffers 2
//----     
#property indicator_plots   1
//+----------------------------------------------+
//|                            |
//+----------------------------------------------+
#define RESET 0 //        
//+----------------------------------------------+
//|                  |
//+----------------------------------------------+
//----     
#property indicator_type1   DRAW_FILLING
//----      
#property indicator_color1  clrLightGray
//----   
#property indicator_label1  "True Range Bands"
//+----------------------------------------------+
//|    CXMA                        |
//+----------------------------------------------+
#include <SmoothAlgorithms.mqh> 
//+----------------------------------------------+
//----    CXMA   SmoothAlgorithms.mqh
CXMA XMA1;
//+----------------------------------------------+
//|                        |
//+----------------------------------------------+
enum Applied_price_ // 
  {
   PRICE_CLOSE_ = 1,     //Close
   PRICE_OPEN_,          //Open
   PRICE_HIGH_,          //High
   PRICE_LOW_,           //Low
   PRICE_MEDIAN_,        //Median Price (HL/2)
   PRICE_TYPICAL_,       //Typical Price (HLC/3)
   PRICE_WEIGHTED_,      //Weighted Close (HLCC/4)
   PRICE_SIMPL_,         //Simpl Price (OC/2)
   PRICE_QUARTER_,       //Quarted Price (HLOC/4) 
   PRICE_TRENDFOLLOW0_,  //TrendFollow_1 Price 
   PRICE_TRENDFOLLOW1_,  //TrendFollow_2 Price
   PRICE_DEMARK_         //Demark Price
  };
//+----------------------------------------------+
//|                        |
//+----------------------------------------------+
/*enum Smooth_Method -     SmoothAlgorithms.mqh
  {
   MODE_SMA_,  //SMA
   MODE_EMA_,  //EMA
   MODE_SMMA_, //SMMA
   MODE_LWMA_, //LWMA
   MODE_JJMA,  //JJMA
   MODE_JurX,  //JurX
   MODE_ParMA, //ParMA
   MODE_T3,    //T3
   MODE_VIDYA, //VIDYA
   MODE_AMA    //AMA
  }; */
//+-----------------------------------+
//|         |
//+-----------------------------------+
input uint Period_ATR=14;                             //  R
input double Deviation = 1.618;                       // 
input Smooth_Method XMA_Method=MODE_SMMA_;            //  
input uint XLength=12;                                //                       
input int XPhase=15;                                  //  ,
//----  JJMA    -100 ... +100,     ;
input Applied_price_  Applied_price=PRICE_CLOSE_;     //    handle

input int Shift=0;                                    //        
//+-----------------------------------+
//----   ,    
//      
double ExtLineBuffer1[],ExtLineBuffer2[];

//----       
int ATR_Handle;
//----      
int min_rates_total;
//+------------------------------------------------------------------+   
//| True Range Bands indicator initialization function               | 
//+------------------------------------------------------------------+ 
int OnInit()
  {
//----     
   min_rates_total=int(Period_ATR);
   int min_rates=GetStartBars(XMA_Method,XLength,XPhase);
   min_rates_total=MathMax(min_rates_total,min_rates);

//----    ATR
   ATR_Handle=iATR(NULL,0,Period_ATR);
   if(ATR_Handle==INVALID_HANDLE)
     {
      Print("      ATR");
      return(INIT_FAILED);
     }

//----      
   SetIndexBuffer(0,ExtLineBuffer1,INDICATOR_DATA);
   SetIndexBuffer(1,ExtLineBuffer2,INDICATOR_DATA);
//----  ,     
   PlotIndexSetInteger(0,PLOT_DRAW_BEGIN,min_rates_total);
//----    1    Shift
   PlotIndexSetInteger(0,PLOT_SHIFT,Shift);
//----      
   PlotIndexSetDouble(0,PLOT_EMPTY_VALUE,0.0);
//----          
   ArraySetAsSeries(ExtLineBuffer1,true);
   ArraySetAsSeries(ExtLineBuffer2,true);

//----      
   string shortname;
   StringConcatenate(shortname,"True Range Bands(",Period_ATR,")");
//---           
   IndicatorSetString(INDICATOR_SHORTNAME,shortname);

//---     
   IndicatorSetInteger(INDICATOR_DIGITS,_Digits);
//----  
   return(INIT_SUCCEEDED);
  }
//+------------------------------------------------------------------+ 
//| True Range Bands iteration function                              | 
//+------------------------------------------------------------------+ 
int OnCalculate(
                const int rates_total,    //       
                const int prev_calculated,//       
                const datetime &time[],
                const double &open[],
                const double &high[],
                const double &low[],
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[]
                )
  {
//----       
   if(BarsCalculated(ATR_Handle)<rates_total || rates_total<min_rates_total) return(RESET);

//----    
   int to_copy,limit,bar,maxbar=rates_total-1;
   double Range[],ATR,xma,price;

//----    limit    
   if(prev_calculated>rates_total || prev_calculated<=0)//      
     {
      limit=rates_total-1; //      
     }
   else limit=rates_total-prev_calculated; //      

//----     
   to_copy=limit+1;

//----       Range[]
   if(CopyBuffer(ATR_Handle,0,0,to_copy,Range)<=0) return(RESET);

//----         
   ArraySetAsSeries(Range,true);
   ArraySetAsSeries(open,true);
   ArraySetAsSeries(low,true);
   ArraySetAsSeries(high,true);
   ArraySetAsSeries(close,true);

//----    
   for(bar=limit; bar>=0 && !IsStopped(); bar--)
     {
      price=PriceSeries(Applied_price,bar,open,low,high,close);
      xma=XMA1.XMASeries(maxbar,prev_calculated,rates_total,XMA_Method,XPhase,XLength,price,bar,true);
      ATR=Range[bar];

      if(price>xma)
        {
         ExtLineBuffer1[bar]=NormalizeDouble(xma+ATR*Deviation,_Digits);
         ExtLineBuffer2[bar]=NormalizeDouble(xma-ATR,_Digits);
        }
      else if(price>xma)
        {
         ExtLineBuffer1[bar]=NormalizeDouble(xma+ATR,_Digits);
         ExtLineBuffer2[bar]=NormalizeDouble(xma-ATR*Deviation,_Digits);
        }
      else
        {
         ExtLineBuffer1[bar]=NormalizeDouble(xma+ATR*Deviation,_Digits);
         ExtLineBuffer2[bar]=NormalizeDouble(xma-ATR*Deviation,_Digits);
        }
     }
//----     
   return(rates_total);
  }
//+------------------------------------------------------------------+
