//+---------------------------------------------------------------------+
//|                                                       RSI_Chart.mq5 | 
//|                                Copyright  2015, Yuriy Tokman (YTG) |
//|                                                  http://ytg.com.ua/ |
//+---------------------------------------------------------------------+ 
//|          SmoothAlgorithms.mqh |
//|   (): __\\MQL5\Include        |
//+---------------------------------------------------------------------+
#property copyright "Copyright  2015, Yuriy Tokman (YTG)"
#property link      "http://ytg.com.ua/"
#property description " RSI   "
//----   
#property version   "1.00"
//----     
#property indicator_chart_window 
//----    4
#property indicator_buffers 4 
//----     
#property indicator_plots   3
//+----------------------------------------------+
//|      RSI Cloud   |
//+----------------------------------------------+
//----     
#property indicator_type1   DRAW_FILLING
//----      
#property indicator_color1  clrLavender
//----   
#property indicator_label1  "RSI Cloud"
//+----------------------------------------------+
//|     XMA          |
//+----------------------------------------------+
//----   2   
#property indicator_type2   DRAW_LINE
//----        DarkOrange
#property indicator_color2  clrDarkOrange
//----   2 -  
#property indicator_style2  STYLE_SOLID
//----    2  2
#property indicator_width2  2
//----   
#property indicator_label2  "XMA"
//+----------------------------------------------+
//|     RSI          |
//+----------------------------------------------+
//----   3   
#property indicator_type3   DRAW_LINE
//----        Blue
#property indicator_color3  clrBlue
//----   3 -  
#property indicator_style3  STYLE_SOLID
//----    3  2
#property indicator_width3  2
//----   
#property indicator_label3  "RSI"
//+----------------------------------------------+
//|                            |
//+----------------------------------------------+
#define RESET 0                //        
//+----------------------------------------------+
//|    CXMA                        |
//+----------------------------------------------+
#include <SmoothAlgorithms.mqh> 
//+----------------------------------------------+
//----    CXMA   SmoothAlgorithms.mqh
CXMA XMA1;
//+----------------------------------------------+
//|                        |
//+----------------------------------------------+
enum Applied_price_ // 
  {
   PRICE_CLOSE_ = 1,     //Close
   PRICE_OPEN_,          //Open
   PRICE_HIGH_,          //High
   PRICE_LOW_,           //Low
   PRICE_MEDIAN_,        //Median Price (HL/2)
   PRICE_TYPICAL_,       //Typical Price (HLC/3)
   PRICE_WEIGHTED_,      //Weighted Close (HLCC/4)
   PRICE_SIMPL_,         //Simpl Price (OC/2)
   PRICE_QUARTER_,       //Quarted Price (HLOC/4) 
   PRICE_TRENDFOLLOW0_,  //TrendFollow_1 Price 
   PRICE_TRENDFOLLOW1_,  //TrendFollow_2 Price
   PRICE_DEMARK_         //Demark Price
  };
//+----------------------------------------------+
//|                        |
//+----------------------------------------------+
/*enum Smooth_Method -     SmoothAlgorithms.mqh
  {
   MODE_SMA_,  //SMA
   MODE_EMA_,  //EMA
   MODE_SMMA_, //SMMA
   MODE_LWMA_, //LWMA
   MODE_JJMA,  //JJMA
   MODE_JurX,  //JurX
   MODE_ParMA, //ParMA
   MODE_T3,    //T3
   MODE_VIDYA, //VIDYA
   MODE_AMA,   //AMA
  }; */
//+----------------------------------------------+
//|                    |
//+----------------------------------------------+
input uint PeriodRSI=14;                              //   RSI
input Smooth_Method XMA_Method=MODE_SMMA;             //  
input uint XLength=12;                                //   
input int XPhase=15;                                  //  
//----  JJMA    -100 ... +100,     ;
//----  VIDIA   CMO,  AMA    
input double Dev=10.0;                                //   
input ENUM_APPLIED_PRICE  Applied_price=PRICE_CLOSE;  //    handle
input uint  Level_RSI_UP = 60;                        //  
input uint  Level_RSI_DN = 40;                        //  
input int Shift=0;                                    //        
//+----------------------------------------------+
//----   ,   
//----      
double Line1Buffer[];
double Line2Buffer[];
double Line3Buffer[];
double Line4Buffer[];
//----
double dLevel_RSI_UP,dLevel_RSI_DN;
//----      
int min_rates_total,min_rates_1;
//---      
int Ind_Handle;
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+  
int OnInit()
  {
//----     
   min_rates_1=int(PeriodRSI);
   min_rates_total=min_rates_1+GetStartBars(XMA_Method,XLength,XPhase);
//----
   dLevel_RSI_UP=int(Level_RSI_UP-50)*_Point*Dev;
   dLevel_RSI_DN=int(Level_RSI_DN-50)*_Point*Dev;
//---    RSI
   Ind_Handle=iRSI(Symbol(),NULL,PeriodRSI,Applied_price);
   if(Ind_Handle==INVALID_HANDLE)
     {
      Print("     RSI");
      return(INIT_FAILED);
     }
//----      
   SetIndexBuffer(0,Line1Buffer,INDICATOR_DATA);
//----      
   SetIndexBuffer(1,Line2Buffer,INDICATOR_DATA);
//----    1    Shift
   PlotIndexSetInteger(0,PLOT_SHIFT,Shift);
//----       1  min_rates_total
   PlotIndexSetInteger(0,PLOT_DRAW_BEGIN,min_rates_total);

//----      
   SetIndexBuffer(2,Line3Buffer,INDICATOR_DATA);
//----    2    Shift
   PlotIndexSetInteger(1,PLOT_SHIFT,Shift);
//----       2  min_rates_total
   PlotIndexSetInteger(1,PLOT_DRAW_BEGIN,min_rates_total);

//----      
   SetIndexBuffer(3,Line4Buffer,INDICATOR_DATA);
//----    3    Shift
   PlotIndexSetInteger(2,PLOT_SHIFT,Shift);
//----       3  min_rates_total
   PlotIndexSetInteger(2,PLOT_DRAW_BEGIN,min_rates_total);

//----       
   ArraySetAsSeries(Line1Buffer,true);
   ArraySetAsSeries(Line2Buffer,true);
   ArraySetAsSeries(Line3Buffer,true);
   ArraySetAsSeries(Line4Buffer,true);
//----      
   string shortname;
   StringConcatenate(shortname,"F_RSI(",PeriodRSI,")");
//---           
   IndicatorSetString(INDICATOR_SHORTNAME,shortname);
//---     
   IndicatorSetInteger(INDICATOR_DIGITS,_Digits);
//----  
   return(INIT_SUCCEEDED);
  }
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int OnCalculate(const int rates_total,    //       
                const int prev_calculated,//       
                const datetime &time[],
                const double &open[],
                const double &high[],
                const double &low[],
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[])
  {
//----       
   if(BarsCalculated(Ind_Handle)<rates_total || rates_total<min_rates_total) return(RESET);
//----       
   double price,xma,RSI[];
//----        
   int to_copy,limit,bar,maxbar=rates_total-1-min_rates_1;
//----    limit    
   if(prev_calculated>rates_total || prev_calculated<=0)//      
     {
      limit=maxbar; //      
     }
   else limit=rates_total-prev_calculated; //      
//----
   to_copy=limit+1;
//----      
   if(CopyBuffer(Ind_Handle,MAIN_LINE,0,to_copy,RSI)<=0) return(RESET);
//----       
   ArraySetAsSeries(RSI,true);
   ArraySetAsSeries(open,true);
   ArraySetAsSeries(low,true);
   ArraySetAsSeries(high,true);
   ArraySetAsSeries(close,true);
//----    
   for(bar=limit; bar>=0 && !IsStopped(); bar--)
     {
      price=PriceSeries(Applied_price,bar,open,low,high,close);
      xma=XMA1.XMASeries(maxbar,prev_calculated,rates_total,XMA_Method,XPhase,XLength,price,bar,true);
      Line3Buffer[bar]=xma;
      Line4Buffer[bar]=xma+Dev*(RSI[bar]-50)*_Point;
      Line1Buffer[bar]=xma+dLevel_RSI_UP;
      Line2Buffer[bar]=xma+dLevel_RSI_DN;
     }
//----     
   return(rates_total);
  }
//+------------------------------------------------------------------+
