//+------------------------------------------------------------------+
//|                                                    DD_Report.mq4 |
//|                                           Copyright 2016, MFFDL. |
//|                                             https://www.mql5.com |
//+------------------------------------------------------------------+
#property copyright "Copyright 2016, MFFDL."
#property link      "https://www.mql5.com"
#property version   "1.00"
#property strict

const double DEFAULT_DD=0.20;
const int DEFAULT_LPI = 10;
const int DEFAULT_ASI = 60 * 60;

input double   DD=0.20; // DD Precentage
input int LOG_PRINT_INTERVAL=10; // Print Log Interval(s)
input int ALERT_SHOW_INTERVAL=60*60; // Show Alert Interval(s)

int lpi = DEFAULT_LPI;
int asi = DEFAULT_ASI;

double dd=DEFAULT_DD;
datetime preTime=0;
string strDD="";
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
int OnInit()
  {
   dd=(DD<0.05 || DD>0.95 ? DEFAULT_DD : DD);
   lpi = (LOG_PRINT_INTERVAL <= 0 ? DEFAULT_LPI : LOG_PRINT_INTERVAL);
   asi = (ALERT_SHOW_INTERVAL <= 0 ? DEFAULT_ASI : ALERT_SHOW_INTERVAL);

   strDD=StringConcatenate(DoubleToStr(dd*100,2),"%");

   EventSetTimer(lpi);
   return(INIT_SUCCEEDED);
  }
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
void OnDeinit(const int reason)
  {
   EventKillTimer();
  }
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
void OnTimer()
  {
   double balance= AccountBalance();
   double equity = AccountEquity();
   double current= equity/balance;
   string p=StringConcatenate(DoubleToStr(current*100,2),"%");

   Print(TimeToStr(TimeLocal(),TIME_DATE|TIME_SECONDS)," The Current Equity: ",p);

   if(1-current>dd)
     {
      datetime curTime=TimeCurrent();
      if(curTime-preTime>asi)
        {
         Alert(TimeToStr(TimeLocal(),TIME_DATE|TIME_SECONDS)," The Current Equity: ",p," Lower Than ",strDD);
         preTime=curTime;
        }
     }
  }
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
void OnTick()
  {
  }
//+------------------------------------------------------------------+
