//+------------------------------------------------------------------+
//|                                                     Extrem_N.mq5 |
//|                                 Copyright  2014 Serkov Alexandr | 
//|                              Khabarovsk,   farria@mail.redcom.ru | 
//+------------------------------------------------------------------+
//----  
#property copyright "Copyright  2014 Serkov Alexandr"
//----    
#property link "serkov-alexandr@mail.ru"
//----   
#property version   "1.00"
//----     
#property indicator_chart_window
//----        
#property indicator_buffers 2
//----    
#property indicator_plots   2
//+----------------------------------------------+
//|           |
//+----------------------------------------------+
//----   1   
#property indicator_type1   DRAW_LINE
//----         
#property indicator_color1  clrLime
//----   1 -  
#property indicator_style1  STYLE_SOLID
//----    1  3
#property indicator_width1  3
//----    
#property indicator_label1  "Bulls"
//+----------------------------------------------+
//|        |
//+----------------------------------------------+
//----   2   
#property indicator_type2   DRAW_LINE
//----         
#property indicator_color2  clrRed
//----   2 -  
#property indicator_style2  STYLE_SOLID
//----    2  3
#property indicator_width2  3
//----    
#property indicator_label2  "Bears"
//+----------------------------------------------+
//|                    |
//+----------------------------------------------+
input int period= 9; //   
input int Shift = 0; //       
//+----------------------------------------------+
//----   ,    
//      
double BullsBuffer[];
double BearsBuffer[];
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+  
void OnInit()
  {
//----    BullsBuffer   
   SetIndexBuffer(0,BullsBuffer,INDICATOR_DATA);
//----    1    Shift
   PlotIndexSetInteger(0,PLOT_SHIFT,Shift);
//----       1  period
   PlotIndexSetInteger(0,PLOT_DRAW_BEGIN,period);
//---      DataWindow
   PlotIndexSetString(0,PLOT_LABEL,"Bears");
//----      
   PlotIndexSetDouble(0,PLOT_EMPTY_VALUE,0.0);
//----    BearsBuffer   
   SetIndexBuffer(1,BearsBuffer,INDICATOR_DATA);
//----    2    Shift
   PlotIndexSetInteger(1,PLOT_SHIFT,Shift);
//----       2  period
   PlotIndexSetInteger(1,PLOT_DRAW_BEGIN,period);
//---      DataWindow
   PlotIndexSetString(1,PLOT_LABEL,"Bulls");
//----      
   PlotIndexSetDouble(1,PLOT_EMPTY_VALUE,0.0);
//----      
   string shortname;
   StringConcatenate(shortname,"(",period,", ",Shift,")");
//---           
   IndicatorSetString(INDICATOR_SHORTNAME,shortname);
//---     
   IndicatorSetInteger(INDICATOR_DIGITS,_Digits);
//----
  }
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int OnCalculate(const int rates_total,    //       
                const int prev_calculated,//       
                const datetime &time[],
                const double &open[],
                const double& high[],     //       
                const double& low[],      //        
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[])
  {
//----       
   if(rates_total<period-1) return(0);
//----    
   int first,bar;
//----    first    
   if(prev_calculated>rates_total || prev_calculated<=0) //      
      first=period; //      
   else first=prev_calculated-1; //      
//----    
   for(bar=first; bar<rates_total && !IsStopped(); bar++)
     {
      if(high[bar]>high[bar-period]) BullsBuffer[bar] = high[bar]; else BullsBuffer[bar] = 0.0;
      if(low[bar]<low[bar-period]) BearsBuffer[bar] = low[bar]; else BearsBuffer[bar] = 0.0;
     }
//----     
   return(rates_total);
  }
//+------------------------------------------------------------------+
