//+---------------------------------------------------------------------+
//|                                                        XMA_BBx3.mq5 | 
//|                                  Copyright  2016, Nikolay Kositsin | 
//|                                 Khabarovsk,   farria@mail.redcom.ru | 
//+---------------------------------------------------------------------+ 
//|          SmoothAlgorithms.mqh |
//|   (): __\\MQL5\Include        |
//+---------------------------------------------------------------------+
#property copyright "Copyright  2016, Nikolay Kositsin"
#property link "farria@mail.redcom.ru"
#property description "XMA Bollinger Bands"
//----   
#property version   "1.00"
//----     
#property indicator_chart_window 
//----    3
#property indicator_buffers 3 
//----   5  
#property indicator_plots   3
//+--------------------------------------------+
//|                |
//+--------------------------------------------+
//----     
#property indicator_type1   DRAW_LINE
//----       - 
#property indicator_color1 clrBlueViolet
//----   - 
#property indicator_style1  STYLE_SOLID
//----     2
#property indicator_width1  2
//----   
#property indicator_label1  "XMA"
//+--------------------------------------------+
//|    BB   |
//+--------------------------------------------+
//----      
#property indicator_type2   DRAW_LINE
#property indicator_type3   DRAW_LINE
//----    
#property indicator_color2  clrLime
#property indicator_color3  clrRed
//----   - 
#property indicator_style2 STYLE_SOLID
#property indicator_style3 STYLE_SOLID
//----     2
#property indicator_width2  2
#property indicator_width3  2
//----    
#property indicator_label2  "+2Sigma"
#property indicator_label3  "-2Sigma"
//+--------------------------------------------+
//|                   |
//+--------------------------------------------+
#include <SmoothAlgorithms.mqh> 
//+--------------------------------------------+
//----    CXMA  CStdDeviation   SmoothAlgorithms.mqh
CXMA XMA1;
CStdDeviation STD;
//+--------------------------------------------+
//|                      |
//+--------------------------------------------+
enum Applied_price_ // 
  {
   PRICE_CLOSE_ = 1,     //Close
   PRICE_OPEN_,          //Open
   PRICE_HIGH_,          //High
   PRICE_LOW_,           //Low
   PRICE_MEDIAN_,        //Median Price (HL/2)
   PRICE_TYPICAL_,       //Typical Price (HLC/3)
   PRICE_WEIGHTED_,      //Weighted Close (HLCC/4)
   PRICE_SIMPL_,         //Simpl Price (OC/2)
   PRICE_QUARTER_,       //Quarted Price (HLOC/4) 
   PRICE_TRENDFOLLOW0_,  //TrendFollow_1 Price 
   PRICE_TRENDFOLLOW1_,  //TrendFollow_2 Price
   PRICE_DEMARK_         //Demark Price 
  };
//+--------------------------------------------+
//|                      |
//+--------------------------------------------+
/*enum Smooth_Method -     SmoothAlgorithms.mqh
  {
   MODE_SMA_,  //SMA
   MODE_EMA_,  //EMA
   MODE_SMMA_, //SMMA
   MODE_LWMA_, //LWMA
   MODE_JJMA,  //JJMA
   MODE_JurX,  //JurX
   MODE_ParMA, //ParMA
   MODE_T3,    //T3
   MODE_VIDYA, //VIDYA
   MODE_AMA,   //AMA
  }; */
//+--------------------------------------------+
//|                  |
//+--------------------------------------------+
input Smooth_Method XMA_Method=MODE_SMA; //  
input uint XLength=100; //   
input int XPhase=15; //   
//----  JJMA    -100 ... +100,     ;
//----  VIDIA   CMO,  AMA    
input double BandsDeviation=2.0; // 
input Applied_price_ IPC=PRICE_CLOSE;//  
input int Shift=0; //      
input int PriceShift=0; //      
input color  Upper_color=clrMediumSeaGreen;
input color  Middle_color=clrBlue;
input color  Lower_color=clrRed;
//+--------------------------------------------+
//----   ,    
//      
double ExtLineBuffer0[];
//----   ,    
//        
double ExtLineBuffer1[],ExtLineBuffer2[];
//----      
double dPriceShift;
//----      
int min_rates_total,min_rates_1;
//----      
string upper_name,middle_name,lower_name;
//+------------------------------------------------------------------+   
//| XMA BBx3 indicator initialization function                       | 
//+------------------------------------------------------------------+ 
void OnInit()
  {
//----     
   min_rates_1=GetStartBars(XMA_Method,XLength,XPhase)+1;
   min_rates_total=min_rates_1+int(XLength);
//----       
   XMA1.XMALengthCheck("XLength",XLength);
//----       
   XMA1.XMAPhaseCheck("XPhase",XPhase,XMA_Method);
//----    
   dPriceShift=_Point*PriceShift;
//----   
   upper_name="Price_Channel_Central upper text lable";
   middle_name="Price_Channel_Central middle text lable";
   lower_name="Price_Channel_Central lower text lable";
//----      
   SetIndexBuffer(0,ExtLineBuffer0,INDICATOR_DATA);
//----    1  
   PlotIndexSetInteger(0,PLOT_SHIFT,Shift);
//----      
   PlotIndexSetInteger(0,PLOT_DRAW_BEGIN,min_rates_total);
//----   ,      
   PlotIndexSetDouble(0,PLOT_EMPTY_VALUE,EMPTY_VALUE);
//----      
   SetIndexBuffer(1,ExtLineBuffer1,INDICATOR_DATA);
   SetIndexBuffer(2,ExtLineBuffer2,INDICATOR_DATA);
//----  ,      
   PlotIndexSetInteger(1,PLOT_DRAW_BEGIN,min_rates_total);
   PlotIndexSetInteger(2,PLOT_DRAW_BEGIN,min_rates_total);
//----      
   PlotIndexSetDouble(1,PLOT_EMPTY_VALUE,EMPTY_VALUE);
   PlotIndexSetDouble(2,PLOT_EMPTY_VALUE,EMPTY_VALUE);
//---       Shift
   PlotIndexSetInteger(1,PLOT_SHIFT,Shift);
   PlotIndexSetInteger(2,PLOT_SHIFT,Shift);
//----      
   string shortname;
   string Smooth=XMA1.GetString_MA_Method(XMA_Method);
   StringConcatenate(shortname,"XMA_Bollinger Bands(",Smooth,", ",XLength,", ",DoubleToString(BandsDeviation,2),")");
//---           
   IndicatorSetString(INDICATOR_SHORTNAME,shortname);
//---     
   IndicatorSetInteger(INDICATOR_DIGITS,_Digits+1);
//----  
  }
//+------------------------------------------------------------------+
//| Custom indicator deinitialization function                       |
//+------------------------------------------------------------------+    
void OnDeinit(const int reason)
  {
//----
   ObjectDelete(0,upper_name);
   ObjectDelete(0,middle_name);
   ObjectDelete(0,lower_name);
//----
  }
//+------------------------------------------------------------------+ 
//| XMA BBx3 iteration function                                      | 
//+------------------------------------------------------------------+ 
int OnCalculate(const int rates_total,    //       
                const int prev_calculated,//       
                const datetime &time[],
                const double &open[],
                const double &high[],
                const double &low[],
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[])
  {
//----       
   if(rates_total<min_rates_total) return(0);
//----       
   double price,xma,line,stdev;
//----        
   int first,bar;
//----    first    
   if(prev_calculated>rates_total || prev_calculated<=0) //      
      first=0; //      
   else first=prev_calculated-1; //      
//----    
   for(bar=first; bar<rates_total && !IsStopped(); bar++)
     {
      price=PriceSeries(IPC,bar,open,low,high,close);
      xma=XMA1.XMASeries(0,prev_calculated,rates_total,XMA_Method,XPhase,XLength,price,bar,false);
      line=xma+dPriceShift;
      ExtLineBuffer0[bar]=line;
      stdev=STD.StdDevSeries(min_rates_1,prev_calculated,rates_total,XLength,BandsDeviation,price,xma,bar,false);
      ExtLineBuffer1[bar]=line+stdev;
      ExtLineBuffer2[bar]=line-stdev;
     }
   int bar0=rates_total-1;
   SetRightPrice(0,upper_name,0,time[bar0],ExtLineBuffer1[bar0],Upper_color,"Georgia");
   SetRightPrice(0,middle_name,0,time[bar0],ExtLineBuffer0[bar0],Middle_color,"Georgia");
   SetRightPrice(0,lower_name,0,time[bar0],ExtLineBuffer2[bar0],Lower_color,"Georgia");
//----     
   return(rates_total);
  }
//+------------------------------------------------------------------+
//|  RightPrice creation                                             |
//+------------------------------------------------------------------+
void CreateRightPrice(long chart_id,// chart ID
                      string   name,              // object name
                      int      nwin,              // window index
                      datetime time,              // price level time
                      double   price,             // price level
                      color    Color,             // Text color
                      string   Font)              // Text font
  {
//----
   ObjectCreate(chart_id,name,OBJ_ARROW_RIGHT_PRICE,nwin,time,price);
   ObjectSetInteger(chart_id,name,OBJPROP_COLOR,Color);
   ObjectSetString(chart_id,name,OBJPROP_FONT,Font);
   ObjectSetInteger(chart_id,name,OBJPROP_BACK,true);
//----
  }
//+------------------------------------------------------------------+
//|  RightPrice reinstallation                                       |
//+------------------------------------------------------------------+
void SetRightPrice(long chart_id,// chart ID
                   string   name,              // object name
                   int      nwin,              // window index
                   datetime time,              // price level time
                   double   price,             // price level
                   color    Color,             // Text color
                   string   Font)              // Text font
  {
//----
   if(ObjectFind(chart_id,name)==-1) CreateRightPrice(chart_id,name,nwin,time,price,Color,Font);
   else ObjectMove(chart_id,name,0,time,price);
//----
  }
//+------------------------------------------------------------------+
