//+------------------------------------------------------------------+ 
//|                                    Price_Channel_Central_HTF.mq5 | 
//|                               Copyright  2016, Nikolay Kositsin | 
//|                              Khabarovsk,   farria@mail.redcom.ru | 
//+------------------------------------------------------------------+ 
#property copyright "Copyright  2016, Nikolay Kositsin"
#property link "farria@mail.redcom.ru"
//---   
#property version   "1.60"
#property description "Price_Channel_Central      "
//----     
#property indicator_chart_window 
//----    5
#property indicator_buffers 5 
//----     
#property indicator_plots   5
//+----------------------------------------------+
//|                            |
//+----------------------------------------------+
#define RESET 0                                      //        
#define INDICATOR_NAME "Price_Channel_Central_HTF"   //    
#define SIZE 1                                       //      CountIndicator  
//+----------------------------------------------+ 
//|                  |
//+----------------------------------------------+
//----     
#property indicator_type1   DRAW_LINE
//----   
#property indicator_label1  "Chanell Upper"
//----      
#property indicator_color1 clrLime
//----   - 
#property indicator_style1  STYLE_SOLID
//----     5
#property indicator_width1  5
//+----------------------------------------------+ 
//|                  |
//+----------------------------------------------+
//----     
#property indicator_type2   DRAW_LINE
//----   
#property indicator_label2  "Chanell Middle"
//----      
#property indicator_color2 clrBlue
//----   - 
#property indicator_style2  STYLE_SOLID
//----     5
#property indicator_width2  5
//+----------------------------------------------+ 
//|                  |
//+----------------------------------------------+
//----     
#property indicator_type3   DRAW_LINE
//----   
#property indicator_label3  "Chanell Lower"
//----      
#property indicator_color3 clrRed
//----   - 
#property indicator_style3  STYLE_SOLID
//----     5
#property indicator_width3  5
//+----------------------------------------------+
//|        |
//+----------------------------------------------+
//---   4   
#property indicator_type4   DRAW_ARROW
//---         
#property indicator_color4  clrMagenta
//---    4  5
#property indicator_width4  5
//---    
#property indicator_label4  "Price_Channel_Central Sell"
//+----------------------------------------------+
//|           |
//+----------------------------------------------+
//---   5   
#property indicator_type5   DRAW_ARROW
//---         
#property indicator_color5  clrDodgerBlue
//---    5  5
#property indicator_width5  5
//---    
#property indicator_label5 "Price_Channel_Central Buy"
//+----------------------------------------------+
//|                    |
//+----------------------------------------------+
input ENUM_TIMEFRAMES TimeFrame=PERIOD_H4;   //   
//---
input uint Bars_Count=32;
input color  Upper_color=clrTeal;
input color  Middle_color=clrBlue;
input color  Lower_color=clrRed;
input int Shift=0;                           //      
//+----------------------------------------------+
//---   ,   
//---      
double Ind1Buffer[];
double Ind2Buffer[];
double Ind3Buffer[];
double Ind4Buffer[];
double Ind5Buffer[];
//---      
int min_rates_total;
//---      
int Ind_Handle;
//+------------------------------------------------------------------+
//|                                    |
//+------------------------------------------------------------------+
string GetStringTimeframe(ENUM_TIMEFRAMES timeframe)
  {return(StringSubstr(EnumToString(timeframe),7,-1));}
//+------------------------------------------------------------------+    
//| Custom indicator initialization function                         | 
//+------------------------------------------------------------------+  
int OnInit()
  {
//---     
   if(!TimeFramesCheck(INDICATOR_NAME,TimeFrame)) return(INIT_FAILED);
//---   
   min_rates_total=2;
//---    Price_Channel_Central
   Ind_Handle=iCustom(Symbol(),TimeFrame,"Price_Channel_Central",Bars_Count,Upper_color,Middle_color,Lower_color);
   if(Ind_Handle==INVALID_HANDLE)
     {
      Print("      Price_Channel_Central");
      return(INIT_FAILED);
     }
//---   
   BuffInit(0,Ind1Buffer);
   BuffInit(1,Ind2Buffer);
   BuffInit(2,Ind3Buffer);
   BuffInit(3,Ind4Buffer);
   BuffInit(4,Ind5Buffer);
//---     
   IndInit(0,0.0,min_rates_total,Shift);
   IndInit(1,0.0,min_rates_total,Shift);
   IndInit(2,0.0,min_rates_total,Shift);
   IndInit(3,0.0,min_rates_total,Shift);
   IndInit(4,0.0,min_rates_total,Shift);
//---           
   string shortname;
   StringConcatenate(shortname,INDICATOR_NAME,"(",GetStringTimeframe(TimeFrame),")");
//---
   IndicatorSetString(INDICATOR_SHORTNAME,shortname);
//---     
   IndicatorSetInteger(INDICATOR_DIGITS,_Digits);
//---  
   return(INIT_SUCCEEDED);
  }
//+------------------------------------------------------------------+  
//| Custom iteration function                                        | 
//+------------------------------------------------------------------+  
int OnCalculate(const int rates_total,    //       
                const int prev_calculated,//       
                const datetime &time[],
                const double &open[],
                const double &high[],
                const double &low[],
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[])
  {
//---       
   if(rates_total<min_rates_total) return(RESET);
   if(BarsCalculated(Ind_Handle)<Bars(Symbol(),TimeFrame)) return(prev_calculated);
//---         
   ArraySetAsSeries(time,true);
//---
   if(!CountIndicator(0,NULL,TimeFrame,Ind_Handle,0,
      Ind1Buffer,1,Ind2Buffer,2,Ind3Buffer,3,Ind4Buffer,4,Ind5Buffer,
      time,rates_total,prev_calculated,min_rates_total)) return(RESET);
//---     
   return(rates_total);
  }
//+------------------------------------------------------------------+
//|                                  |
//+------------------------------------------------------------------+    
void BuffInit(int Number,double &Buffer[])
  {
//---      
   SetIndexBuffer(Number,Buffer,INDICATOR_DATA);
//---       
   ArraySetAsSeries(Buffer,true);
  }
//+------------------------------------------------------------------+
//|                                           |
//+------------------------------------------------------------------+    
void IndInit(int Number,double Empty_Value,int Draw_Begin,int nShift)
  {
//---      
   PlotIndexSetInteger(Number,PLOT_DRAW_BEGIN,Draw_Begin);
//---   ,      
   PlotIndexSetDouble(Number,PLOT_EMPTY_VALUE,Empty_Value);
//---    2    Shift
   PlotIndexSetInteger(Number,PLOT_SHIFT,nShift);
  }
//+------------------------------------------------------------------+
//| CountIndicator                                                   |
//+------------------------------------------------------------------+
bool CountIndicator(uint     Numb,            //   CountLine      (  - 0)
                    string   Symb,            //  
                    ENUM_TIMEFRAMES TFrame,   //  
                    int      IndHandle,       //   
                    uint     BuffNumb1,       //     1
                    double&  IndBuf1[],       //    1
                    uint     BuffNumb2,       //     2
                    double&  IndBuf2[],       //    2
                    uint     BuffNumb3,       //     3
                    double&  IndBuf3[],       //    3                    
                    uint     BuffNumb4,       //     4
                    double&  IndBuf4[],       //    4
                    uint     BuffNumb5,       //     5
                    double&  IndBuf5[],       //    5
                    const datetime& iTime[],  //  
                    const int Rates_Total,    //       
                    const int Prev_Calculated,//       
                    const int Min_Rates_Total)//       
  {
//---
   static int LastCountBar[SIZE];
   datetime IndTime[1];
   int limit;
//---     
//---    limit    
   if(Prev_Calculated>Rates_Total || Prev_Calculated<=0)//      
     {
      limit=Rates_Total-Min_Rates_Total-1; //      
      LastCountBar[Numb]=limit;
     }
   else limit=LastCountBar[Numb]+Rates_Total-Prev_Calculated; //       
//---    
   for(int bar=limit; bar>=0 && !IsStopped(); bar--)
     {
      //---       IndTime
      if(CopyTime(Symbol(),TFrame,iTime[bar],1,IndTime)<=0) return(RESET);
      //---
      if(iTime[bar]>=IndTime[0] && iTime[bar+1]<IndTime[0])
        {
         LastCountBar[Numb]=bar;
         double Arr[1];
         //---      
         if(CopyBuffer(IndHandle,BuffNumb1,iTime[bar],1,Arr)<=0) return(RESET); IndBuf1[bar]=Arr[0];
         if(CopyBuffer(IndHandle,BuffNumb2,iTime[bar],1,Arr)<=0) return(RESET); IndBuf2[bar]=Arr[0];
         if(CopyBuffer(IndHandle,BuffNumb3,iTime[bar],1,Arr)<=0) return(RESET); IndBuf3[bar]=Arr[0];
         if(CopyBuffer(IndHandle,BuffNumb4,iTime[bar],1,Arr)<=0) return(RESET); IndBuf4[bar]=Arr[0];
         if(CopyBuffer(IndHandle,BuffNumb5,iTime[bar],1,Arr)<=0) return(RESET); IndBuf5[bar]=Arr[0];
        }
      else
        {
         IndBuf1[bar]=IndBuf1[bar+1];
         IndBuf2[bar]=IndBuf2[bar+1];
         IndBuf3[bar]=IndBuf3[bar+1];
         IndBuf4[bar]=IndBuf4[bar+1];
         IndBuf5[bar]=IndBuf5[bar+1];
        }
     }
//---     
   return(true);
  }
//+------------------------------------------------------------------+
//| TimeFramesCheck()                                                |
//+------------------------------------------------------------------+    
bool TimeFramesCheck(string IndName,
                     ENUM_TIMEFRAMES TFrame) //   
  {
//---     
   if(TFrame<Period() && TFrame!=PERIOD_CURRENT)
     {
      Print("    "+IndName+"       !");
      Print("    !");
      return(RESET);
     }
//---
   return(true);
  }
//+------------------------------------------------------------------+
