//+------------------------------------------------------------------+
//|                                                    ColorXADX.mq5 |
//|                           Copyright  2010,     Nikolay Kositsin | 
//|                              Khabarovsk,   farria@mail.redcom.ru | 
//+------------------------------------------------------------------+
//----  
#property copyright "Copyright  2010, Nikolay Kositsin"
//----    
#property link "farria@mail.redcom.ru" 
//----   
#property version   "1.03"
//----     
#property indicator_separate_window
//----        
#property indicator_buffers 5
//----    
#property indicator_plots   3
//+----------------------------------------------+
//|    XDi           |
//+----------------------------------------------+
//----   1   
#property indicator_type1   DRAW_FILLING
//----     
#property indicator_color1  clrLime,clrRed
//----   
#property indicator_label1  "XDi"
//+----------------------------------------------+
//|    XADX Line     |
//+----------------------------------------------+
//----   2   
#property indicator_type2   DRAW_LINE
//----         
#property indicator_color2  clrGray
//----   2 -  
#property indicator_style2  STYLE_SOLID
//----    2  1
#property indicator_width2  1
//----   
#property indicator_label2  "XADX Line"
//+----------------------------------------------+
//|   ADX            |
//+----------------------------------------------+
//----   3   
#property indicator_type3   DRAW_COLOR_ARROW
//----    ADX   
#property indicator_color3  clrGray,clrBlue,clrMagenta,clrRed
//----   3 -  
#property indicator_style3  STYLE_SOLID
//----    3  3
#property indicator_width3  3
//----   
#property indicator_label3  "XADX"
//+----------------------------------------------+
//|     |
//+----------------------------------------------+
#property indicator_levelcolor clrBlue
#property indicator_levelstyle STYLE_DASHDOTDOT
//+----------------------------------------------+
//|                     |
//+----------------------------------------------+
#include <SmoothAlgorithms.mqh> 
//+----------------------------------------------+
//----    CXMA   SmoothAlgorithms.mqh
CXMA XDIP,XDIM,XADX;
//+----------------------------------------------+
//|                        |
//+----------------------------------------------+
enum Applied_price_ // 
  {
   PRICE_CLOSE_ = 1,     //Close
   PRICE_OPEN_,          //Open
   PRICE_HIGH_,          //High
   PRICE_LOW_,           //Low
   PRICE_MEDIAN_,        //Median Price (HL/2)
   PRICE_TYPICAL_,       //Typical Price (HLC/3)
   PRICE_WEIGHTED_,      //Weighted Close (HLCC/4)
   PRICE_SIMPL_,         //Simpl Price (OC/2)
   PRICE_QUARTER_,       //Quarted Price (HLOC/4) 
   PRICE_TRENDFOLLOW0_,  //TrendFollow_1 Price 
   PRICE_TRENDFOLLOW1_,  //TrendFollow_2 Price
   PRICE_DEMARK_         //Demark Price
  };
//+----------------------------------------------+
//|                        |
//+----------------------------------------------+
/*enum Smooth_Method -     SmoothAlgorithms.mqh
  {
   MODE_SMA_,  //SMA
   MODE_EMA_,  //EMA
   MODE_SMMA_, //SMMA
   MODE_LWMA_, //LWMA
   MODE_JJMA,  //JJMA
   MODE_JurX,  //JurX
   MODE_ParMA, //ParMA
   MODE_T3,    //T3
   MODE_VIDYA, //VIDYA
   MODE_AMA,   //AMA
  }; */
//+----------------------------------------------+
//|                        |
//+----------------------------------------------+
enum ENUM_WIDTH // 
  {
   w_1=0,  //1
   w_2,    //2
   w_3,    //3
   w_4,    //4
   w_5     //5
  };
//+----------------------------------------------+
//|                    |
//+----------------------------------------------+
input Smooth_Method XMA_Method=MODE_T3; //   
input uint ADX_Period=14; //  XMA 
input int ADX_Phase=100; //  XMA 
//----    -100 ... +100,
//----     ;
input Applied_price_ IPC=PRICE_CLOSE_;//  
input int Shift=0; //      
input uint ExtraHighLevel=60; //   
input uint HighLevel=40; //   
input uint LowLevel=20;//   
input ENUM_LINE_STYLE LevelStyle=STYLE_DASHDOTDOT; //   
input color LevelColor=clrBlue; //  
input ENUM_WIDTH LevelWidth=w_1; //  
//+----------------------------------------------+
//----   ,    
//----      
double DiPlusBuffer[];
double DiMinusBuffer[];
double ADXBuffer[];
double ADXLineBuffer[];
double ColorADXBuffer[];
//----      
int min_rates_di,min_rates_total;
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+  
void OnInit()
  {
//----     
   min_rates_di=XADX.GetStartBars(XMA_Method,ADX_Period,ADX_Phase);
   min_rates_total=2*min_rates_di+1;
   min_rates_di++;
//----    DiPlusBuffer   
   SetIndexBuffer(0,DiPlusBuffer,INDICATOR_DATA);
//----    DiMinusBuffer   
   SetIndexBuffer(1,DiMinusBuffer,INDICATOR_DATA);
//----    ADXLineBuffer   
   SetIndexBuffer(2,ADXLineBuffer,INDICATOR_DATA);
//----    ADXBuffer   
   SetIndexBuffer(3,ADXBuffer,INDICATOR_DATA);
//----     ,     
   SetIndexBuffer(4,ColorADXBuffer,INDICATOR_COLOR_INDEX);

//----       1  min_rates_di
   PlotIndexSetInteger(0,PLOT_DRAW_BEGIN,min_rates_di);
//----   ,      
   PlotIndexSetDouble(0,PLOT_EMPTY_VALUE,EMPTY_VALUE);
//----    1  
   PlotIndexSetInteger(0,PLOT_SHIFT,Shift);

//----       2  min_rates_di
   PlotIndexSetInteger(1,PLOT_DRAW_BEGIN,min_rates_di);
//----   ,      
   PlotIndexSetDouble(1,PLOT_EMPTY_VALUE,EMPTY_VALUE);
//----    1  
   PlotIndexSetInteger(1,PLOT_SHIFT,Shift);

//----       3  min_rates_total
   PlotIndexSetInteger(2,PLOT_DRAW_BEGIN,min_rates_total);
//----   ,      
   PlotIndexSetDouble(2,PLOT_EMPTY_VALUE,EMPTY_VALUE);
//----    1  
   PlotIndexSetInteger(2,PLOT_SHIFT,Shift);

//----      
   string shortname;
   string Smooth=XADX.GetString_MA_Method(XMA_Method);
   StringConcatenate(shortname,"XADX( ",Smooth,", ",ADX_Period,", ",ADX_Phase,", ",EnumToString(IPC),", ",Shift," )");
//---           
   IndicatorSetString(INDICATOR_SHORTNAME,shortname);
//---     
   IndicatorSetInteger(INDICATOR_DIGITS,0);
//----    
   IndicatorSetInteger(INDICATOR_LEVELS,3);
   IndicatorSetDouble(INDICATOR_LEVELVALUE,0,ExtraHighLevel);
   IndicatorSetDouble(INDICATOR_LEVELVALUE,1,HighLevel);
   IndicatorSetDouble(INDICATOR_LEVELVALUE,2,LowLevel);
   IndicatorSetInteger(INDICATOR_LEVELCOLOR,0,LevelColor);
   IndicatorSetInteger(INDICATOR_LEVELSTYLE,0,LevelStyle);
   IndicatorSetInteger(INDICATOR_LEVELWIDTH,0,LevelWidth);
   IndicatorSetInteger(INDICATOR_LEVELCOLOR,1,LevelColor);
   IndicatorSetInteger(INDICATOR_LEVELSTYLE,1,LevelStyle);
   IndicatorSetInteger(INDICATOR_LEVELWIDTH,1,LevelWidth);
   IndicatorSetInteger(INDICATOR_LEVELCOLOR,2,LevelColor);
   IndicatorSetInteger(INDICATOR_LEVELSTYLE,2,LevelStyle);
   IndicatorSetInteger(INDICATOR_LEVELWIDTH,2,LevelWidth);
  }
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int OnCalculate(const int rates_total,    //       
                const int prev_calculated,//       
                const datetime &time[],
                const double &open[],
                const double& high[],     //       
                const double& low[],      //        
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[])
  {
//----       
   if(rates_total<min_rates_total) return(0);
//----    
   int first,bar;
   double DiPlus,DiMinus;
   double Hi,Lo,prevHi,prevLo,prevCl,dTmpP,dTmpN,tr,dTmp;
//----     OnCalculate()
   if(prev_calculated>rates_total || prev_calculated<=0)//      
      first=1; //      
   else first=prev_calculated-1;//      
//----    
   for(bar=first; bar<rates_total && !IsStopped(); bar++)
     {
      int bar1=bar-1;
      Hi=high[bar];
      prevHi=high[bar1];
      //----
      Lo=low[bar];
      prevLo=low[bar1];
      //----
      prevCl=close[bar1];
      //----
      dTmpP=Hi-prevHi;
      dTmpN=prevLo-Lo;
      //----
      dTmpP=MathMax(0.0,dTmpP);
      dTmpN=MathMax(0.0,dTmpN);
      //----
      if(dTmpP>dTmpN) dTmpN=NULL;
      else
        {
         if(dTmpP<dTmpN) dTmpP=NULL;
         else
           {
            dTmpP=NULL;
            dTmpN=NULL;
           }
        }
      //----
      tr=MathMax(MathMax(MathAbs(Hi-Lo),MathAbs(Hi-prevCl)),MathAbs(Lo-prevCl));
      //---
      if(tr)
        {
         DiPlus=100.0*dTmpP/tr;
         DiMinus=100.0*dTmpN/tr;
        }
      else
        {
         DiPlus=NULL;
         DiMinus=NULL;
        }
      //----
      DiPlusBuffer [bar]=XDIP.XMASeries(1,prev_calculated,rates_total,XMA_Method,ADX_Phase,ADX_Period,DiPlus, bar,false);
      DiMinusBuffer[bar]=XDIM.XMASeries(1,prev_calculated,rates_total,XMA_Method,ADX_Phase,ADX_Period,DiMinus,bar,false);
      //----
      dTmp=DiPlusBuffer[bar]+DiMinusBuffer[bar];
      //----
      if(dTmp) dTmp=100.0*MathAbs((DiPlusBuffer[bar]-DiMinusBuffer[bar])/dTmp);
      else          dTmp=NULL;
      //----
      ADXBuffer[bar]=XADX.XMASeries(min_rates_di,prev_calculated,rates_total,XMA_Method,ADX_Phase,ADX_Period,dTmp,bar,false);
      ADXLineBuffer[bar]=ADXBuffer[bar];
     }
//----     
   for(bar=first; bar<rates_total && !IsStopped(); bar++)
     {
      int clr=1;
      if(ADXBuffer[bar]>ExtraHighLevel) clr=3;
      else if(ADXBuffer[bar]>HighLevel) clr=2;
      else if(ADXBuffer[bar]<LowLevel)  clr=0;
      ColorADXBuffer[bar]=clr;
     }
//----     
   return(rates_total);
  }
//+------------------------------------------------------------------+
