//+------------------------------------------------------------------+
//|                                                   METRO_Sign.mq5 | 
//|                           Copyright  2005, TrendLaboratory Ltd. |
//|                                       E-mail: igorad2004@list.ru |
//+------------------------------------------------------------------+
#property copyright "Copyright  2005, TrendLaboratory Ltd."
#property link      "E-mail: igorad2004@list.ru"
#property description "METRO"
//----   
#property version   "1.10"
//---     
#property indicator_chart_window 
//---        
#property indicator_buffers 2
//---     
#property indicator_plots   2
//+----------------------------------------------+
//|        |
//+----------------------------------------------+
//---   1   
#property indicator_type1   DRAW_ARROW
//---         
#property indicator_color1  clrMagenta
//---    1  4
#property indicator_width1  4
//---    
#property indicator_label1  "METRO Sell"
//+----------------------------------------------+
//|           |
//+----------------------------------------------+
//---   2   
#property indicator_type2   DRAW_ARROW
//---         
#property indicator_color2  clrLime
//---    2  4
#property indicator_width2  4
//---    
#property indicator_label2 "METRO Buy"
//+----------------------------------------------+
//|                            |
//+----------------------------------------------+
#define RESET  0 //        
//+----------------------------------------------+
//|                    |
//+----------------------------------------------+
input uint PeriodRSI=7;                               //  
input int StepSizeFast=5;                             //  
input int StepSizeSlow=15;                            //  
input ENUM_APPLIED_PRICE  Applied_price=PRICE_CLOSE;  //    handle
//+----------------------------------------------+
//---   ,   
//---      
double SellBuffer[];
double BuyBuffer[];
//----      
int RSI_Handle,ATR_Handle;
//----      
int min_rates_total;
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+  
int OnInit()
  {
//----     
   int ATR_Period=15;
   min_rates_total=int(PeriodRSI);
   min_rates_total=MathMax(min_rates_total,ATR_Period)+1;
//---    ATR
   ATR_Handle=iATR(NULL,0,ATR_Period);
   if(ATR_Handle==INVALID_HANDLE)
     {
      Print("      ATR");
      return(INIT_FAILED);
     }
//----    RSI
   RSI_Handle=iRSI(NULL,0,PeriodRSI,Applied_price);
   if(RSI_Handle==INVALID_HANDLE)
     {
      Print("      RSI");
      return(INIT_FAILED);
     }
//---      
   SetIndexBuffer(0,SellBuffer,INDICATOR_DATA);
//---       1
   PlotIndexSetInteger(0,PLOT_DRAW_BEGIN,min_rates_total);
//---   
   PlotIndexSetInteger(0,PLOT_ARROW,174);
//----   ,      
   PlotIndexSetDouble(0,PLOT_EMPTY_VALUE,0.0);
//---       
   ArraySetAsSeries(SellBuffer,true);
//---      
   SetIndexBuffer(1,BuyBuffer,INDICATOR_DATA);
//---       2
   PlotIndexSetInteger(1,PLOT_DRAW_BEGIN,min_rates_total);
//---   
   PlotIndexSetInteger(1,PLOT_ARROW,174);
//----   ,      
   PlotIndexSetDouble(1,PLOT_EMPTY_VALUE,0.0);
//---       
   ArraySetAsSeries(BuyBuffer,true);
//----      
   string shortname;
   StringConcatenate(shortname,"METRO_Sign(",PeriodRSI,", ",StepSizeFast,", ",StepSizeSlow,")");
//---           
   IndicatorSetString(INDICATOR_SHORTNAME,shortname);
//---     
   IndicatorSetInteger(INDICATOR_DIGITS,_Digits);
//----  
   return(INIT_SUCCEEDED);
  }
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int OnCalculate(const int rates_total,    //       
                const int prev_calculated,//       
                const datetime &time[],
                const double &open[],
                const double& high[],     //       
                const double& low[],      //        
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[])
  {
//----       
   if(BarsCalculated(RSI_Handle)<rates_total || BarsCalculated(ATR_Handle)<rates_total || rates_total<min_rates_total) return(RESET);
//----    
   int limit,to_copy,bar,ftrend,strend;
   double fmin0,fmax0,smin0,smax0,RSI0,RSI[],ATR[],fast=0.0,slow=0.0;
   static double fmax1,fmin1,smin1,smax1,fast_prev,slow_prev;
   static int ftrend_,strend_;
//----         
   ArraySetAsSeries(RSI,true);
   ArraySetAsSeries(ATR,true);
   ArraySetAsSeries(high,true);
   ArraySetAsSeries(low,true);
//----    first    
   if(prev_calculated>rates_total || prev_calculated<=0) //      
     {
      limit=rates_total-1; //      
      fmin1=+999999;
      fmax1=-999999;
      smin1=+999999;
      smax1=-999999;
      ftrend_=0;
      strend_=0;
      fast_prev=0.0;
      slow_prev=0.0;
     }
   else limit=rates_total-prev_calculated; //      
   to_copy=limit+1;
//----      
   if(CopyBuffer(RSI_Handle,0,0,to_copy,RSI)<=0) return(RESET);
   if(CopyBuffer(ATR_Handle,0,0,to_copy,ATR)<=0) return(RESET);
//----   
   ftrend=ftrend_;
   strend=strend_;
//----    
   for(bar=limit; bar>=0 && !IsStopped(); bar--)
     {
      //----        
      if(rates_total!=prev_calculated && bar==0)
        {
         ftrend_=ftrend;
         strend_=strend;
        }
      //---
      RSI0=RSI[bar];
      //---
      fmax0=RSI0+2*StepSizeFast;
      fmin0=RSI0-2*StepSizeFast;
      //---
      if(RSI0>fmax1) ftrend=+1;
      if(RSI0<fmin1) ftrend=-1;
      //---
      if(ftrend>0 && fmin0<fmin1) fmin0=fmin1;
      if(ftrend<0 && fmax0>fmax1) fmax0=fmax1;
      //---
      smax0=RSI0+2*StepSizeSlow;
      smin0=RSI0-2*StepSizeSlow;
      //---
      if(RSI0>smax1)  strend=+1;
      if(RSI0<smin1)  strend=-1;
      //---
      if(strend>0 && smin0<smin1) smin0=smin1;
      if(strend<0 && smax0>smax1) smax0=smax1;
      //---
      if(ftrend>0) fast=fmin0+StepSizeFast;
      if(ftrend<0) fast=fmax0-StepSizeFast;
      if(strend>0) slow=smin0+StepSizeSlow;
      if(strend<0) slow=smax0-StepSizeSlow;
      //---
      BuyBuffer[bar]=0.0;
      SellBuffer[bar]=0.0;
      //---      
      if(fast_prev<=slow_prev && fast>slow) BuyBuffer[bar]=low[bar]-ATR[bar]*3/8;
      if(fast_prev>=slow_prev && fast<slow) SellBuffer[bar]=high[bar]+ATR[bar]*3/8;
      //---
      if(bar>0)
        {
         fmin1=fmin0;
         fmax1=fmax0;
         smin1=smin0;
         smax1=smax0;
         fast_prev=fast;
         slow_prev=slow;
        }
     }
//----     
   return(rates_total);
  }
//+------------------------------------------------------------------+
