//+------------------------------------------------------------------+
//|                                                FuncDayOfWeek.mqh |
//|                                                          Aktiniy |
//|                                                                  |
//+------------------------------------------------------------------+
#property copyright "Aktiniy"
#property link      ""
//+------------------------------------------------------------------+
//| DayOfWeek function                                               |
//+------------------------------------------------------------------+

int func_day_o_w(int year,int month,int day_o_w,int sequence)
  {
   int number_y=year%28;
   ushort jan=0,feb=0,mar=0,apr=0,may=0,jun=0,jul=0,aug=0,sep=0,oct=0,nov=0,dec=0;     //Clarification Mo=1,Tu=2,We=3,Th=4,Fr=5,Sa=6,Su=7
// Number of the year. This parameter  is needed to know a kind of year (bissextile or not) and determine which day of the week begins each month
// the parameters are writen for the interval from 1988 to 2015, but it is enough to calculate any year date, because the years are repeated every 28 years
   switch(number_y)
     {
      case 0: jan=5;feb=1;mar=2;apr=5;may=7;jun=3;jul=5;aug=1;sep=4;oct=6;nov=2;dec=4; //1988
      break;
      case 1: jan=7;feb=3;mar=3;apr=6;may=1;jun=4;jul=6;aug=2;sep=5;oct=7;nov=3;dec=5; //1989
      break;
      case 2: jan=1;feb=4;mar=4;apr=7;may=2;jun=5;jul=7;aug=3;sep=6;oct=1;nov=4;dec=6; //1990
      break;
      case 3: jan=2;feb=5;mar=5;apr=1;may=3;jun=6;jul=1;aug=4;sep=7;oct=2;nov=5;dec=7; //1991
      break;
      case 4: jan=3;feb=6;mar=7;apr=3;may=5;jun=1;jul=3;aug=6;sep=2;oct=4;nov=7;dec=2; //1992
      break;
      case 5: jan=5;feb=1;mar=1;apr=4;may=6;jun=2;jul=4;aug=7;sep=3;oct=5;nov=1;dec=3; //1993
      break;
      case 6: jan=6;feb=2;mar=2;apr=5;may=7;jun=3;jul=5;aug=1;sep=4;oct=6;nov=2;dec=4; //1994
      break;
      case 7: jan=7;feb=3;mar=3;apr=6;may=1;jun=4;jul=6;aug=2;sep=5;oct=7;nov=3;dec=5; //1995
      break;
      case 8: jan=1;feb=4;mar=5;apr=1;may=3;jun=6;jul=1;aug=4;sep=7;oct=2;nov=5;dec=7; //1996
      break;
      case 9: jan=3;feb=6;mar=6;apr=2;may=4;jun=7;jul=2;aug=5;sep=1;oct=3;nov=6;dec=1; //1997
      break;
      case 10: jan=4;feb=7;mar=7;apr=3;may=5;jun=1;jul=3;aug=6;sep=2;oct=4;nov=7;dec=2; //1998
      break;
      case 11: jan=5;feb=1;mar=1;apr=4;may=6;jun=2;jul=4;aug=7;sep=3;oct=5;nov=1;dec=3; //1999
      break;
      case 12: jan=6;feb=2;mar=3;apr=6;may=1;jun=4;jul=6;aug=2;sep=5;oct=7;nov=3;dec=5; //2000
      break;
      case 13: jan=1;feb=4;mar=4;apr=7;may=2;jun=5;jul=7;aug=3;sep=6;oct=1;nov=4;dec=6; //2001
      break;
      case 14: jan=2;feb=5;mar=5;apr=1;may=3;jun=6;jul=1;aug=4;sep=7;oct=2;nov=5;dec=7; //2002
      break;
      case 15: jan=3;feb=6;mar=6;apr=2;may=4;jun=7;jul=2;aug=5;sep=1;oct=3;nov=6;dec=1; //2003
      break;
      case 16: jan=4;feb=7;mar=1;apr=4;may=6;jun=2;jul=4;aug=7;sep=3;oct=5;nov=1;dec=3; //2004
      break;
      case 17: jan=6;feb=2;mar=2;apr=5;may=7;jun=3;jul=5;aug=1;sep=4;oct=6;nov=2;dec=4; //2005
      break;
      case 18: jan=7;feb=3;mar=3;apr=6;may=1;jun=4;jul=6;aug=2;sep=5;oct=7;nov=3;dec=5; //2006
      break;
      case 19: jan=1;feb=4;mar=4;apr=7;may=2;jun=5;jul=7;aug=3;sep=6;oct=1;nov=4;dec=6; //2007
      break;
      case 20: jan=2;feb=5;mar=6;apr=2;may=4;jun=7;jul=2;aug=5;sep=1;oct=3;nov=6;dec=1; //2008
      break;
      case 21: jan=4;feb=7;mar=7;apr=3;may=5;jun=1;jul=3;aug=6;sep=2;oct=4;nov=7;dec=2; //2009
      break;
      case 22: jan=5;feb=1;mar=1;apr=4;may=6;jun=2;jul=4;aug=7;sep=3;oct=5;nov=1;dec=3; //2010
      break;
      case 23: jan=6;feb=2;mar=2;apr=5;may=7;jun=3;jul=5;aug=1;sep=4;oct=6;nov=2;dec=4; //2011
      break;
      case 24: jan=7;feb=3;mar=4;apr=7;may=2;jun=5;jul=7;aug=3;sep=6;oct=1;nov=4;dec=6; //2012
      break;
      case 25: jan=2;feb=5;mar=5;apr=1;may=3;jun=6;jul=1;aug=4;sep=7;oct=2;nov=5;dec=7; //2013
      break;
      case 26: jan=3;feb=6;mar=6;apr=2;may=4;jun=7;jul=2;aug=5;sep=1;oct=3;nov=6;dec=1; //2014
      break;
      case 27: jan=4;feb=7;mar=7;apr=3;may=5;jun=1;jul=3;aug=6;sep=2;oct=4;nov=7;dec=2; //2015
      break;
     }
   int f_day=0;
   uchar leap_y=0;
// Calculation by months
   switch(month) //Clarification jan=1,feb=2,mar=3,apr=4,may=5,jun=6,jul=7,aug=8,sep=9,oct=10,nov=11,dec=12
     {
      case 1: if(day_o_w==jan) {f_day=1;} // Check if the first month day satisfies the desired day of the week
      if(day_o_w!=jan)                    // if not, then find the first number of the desired day of the week
        {
         if((jan-day_o_w)>0)
           {
            f_day=8-jan+day_o_w;
           }
         if((jan-day_o_w)<0)
           {
            f_day=1+fabs(jan-day_o_w);
           }
        }
      if(sequence>1) {f_day=f_day+7*(sequence-1);} // If we have not the first desired day of the week this month, we add days
      if(f_day>31) {f_day=f_day-7;}
      break;
      case 2: if(day_o_w==feb) {f_day=1;} // Similarly for the other months
      if(day_o_w!=feb)
        {
         if((feb-day_o_w)>0)
           {
            f_day=8-feb+day_o_w;
           }
         if((feb-day_o_w)<0)
           {
            f_day=1+fabs(feb-day_o_w);
           }
        }
      if(sequence>1) {f_day=f_day+7*(sequence-1);}
      if(year%4>0) {leap_y=28;} else {leap_y=29;} // This case considered, that every fouth year is bissextile that is, it 29 days in February
      if(f_day>leap_y) {f_day=f_day-7;}
      break;
      case 3: if(day_o_w==mar) {f_day=1;}
      if(day_o_w!=mar)
        {
         if((mar-day_o_w)>0)
           {
            f_day=8-mar+day_o_w;
           }
         if((mar-day_o_w)<0)
           {
            f_day=1+fabs(mar-day_o_w);
           }
        }
      if(sequence>1)   {f_day=f_day+7*(sequence-1);}
      if(f_day>31)     {f_day=f_day-7;}
      break;
      case 4: if(day_o_w==apr) {f_day=1;}
      if(day_o_w!=apr)
        {
         if((apr-day_o_w)>0)
           {
            f_day=8-apr+day_o_w;
           }
         if((apr-day_o_w)<0)
           {
            f_day=1+fabs(apr-day_o_w);
           }
        }
      if(sequence>1)   {f_day=f_day+7*(sequence-1);}
      if(f_day>30)     {f_day=f_day-7;}
      break;
      case 5: if(day_o_w==may) {f_day=1;}
      if(day_o_w!=may)
        {
         if((may-day_o_w)>0)
           {
            f_day=8-may+day_o_w;
           }
         if((may-day_o_w)<0)
           {
            f_day=1+fabs(may-day_o_w);
           }
        }
      if(sequence>1)   {f_day=f_day+7*(sequence-1);}
      if(f_day>31)     {f_day=f_day-7;}
      break;
      case 6: if(day_o_w==jun) {f_day=1;}
      if(day_o_w!=jun)
        {
         if((jun-day_o_w)>0)
           {
            f_day=8-jun+day_o_w;
           }
         if((jun-day_o_w)<0)
           {
            f_day=1+fabs(jun-day_o_w);
           }
        }
      if(sequence>1)   {f_day=f_day+7*(sequence-1);}
      if(f_day>30)     {f_day=f_day-7;}
      break;
      case 7: if(day_o_w==jul) {f_day=1;}
      if(day_o_w!=jul)
        {
         if((jul-day_o_w)>0)
           {
            f_day=8-jul+day_o_w;
           }
         if((jul-day_o_w)<0)
           {
            f_day=1+fabs(jul-day_o_w);
           }
        }
      if(sequence>1)   {f_day=f_day+7*(sequence-1);}
      if(f_day>31)     {f_day=f_day-7;}
      break;
      case 8: if(day_o_w==aug) {f_day=1;}
      if(day_o_w!=aug)
        {
         if((aug-day_o_w)>0)
           {
            f_day=8-aug+day_o_w;
           }
         if((aug-day_o_w)<0)
           {
            f_day=1+fabs(aug-day_o_w);
           }
        }
      if(sequence>1)   {f_day=f_day+7*(sequence-1);}
      if(f_day>31)     {f_day=f_day-7;}
      break;
      case 9: if(day_o_w==sep) {f_day=1;}
      if(day_o_w!=sep)
        {
         if((sep-day_o_w)>0)
           {
            f_day=8-sep+day_o_w;
           }
         if((sep-day_o_w)<0)
           {
            f_day=1+fabs(sep-day_o_w);
           }
        }
      if(sequence>1)   {f_day=f_day+7*(sequence-1);}
      if(f_day>30)     {f_day=f_day-7;}
      break;
      case 10: if(day_o_w==oct) {f_day=1;}
      if(day_o_w!=oct)
        {
         if((oct-day_o_w)>0)
           {
            f_day=8-oct+day_o_w;
           }
         if((oct-day_o_w)<0)
           {
            f_day=1+fabs(oct-day_o_w);
           }
        }
      if(sequence>1)   {f_day=f_day+7*(sequence-1);}
      if(f_day>31)     {f_day=f_day-7;}
      break;
      case 11: if(day_o_w==nov) {f_day=1;}
      if(day_o_w!=nov)
        {
         if((nov-day_o_w)>0)
           {
            f_day=8-nov+day_o_w;
           }
         if((nov-day_o_w)<0)
           {
            f_day=1+fabs(nov-day_o_w);
           }
        }
      if(sequence>1)   {f_day=f_day+7*(sequence-1);}
      if(f_day>30)     {f_day=f_day-7;}
      break;
      case 12: if(day_o_w==dec) {f_day=1;}
      if(day_o_w!=dec)
        {
         if((dec-day_o_w)>0)
           {
            f_day=8-dec+day_o_w;
           }
         if((dec-day_o_w)<0)
           {
            f_day=1+fabs(dec-day_o_w);
           }
        }
      if(sequence>1)   {f_day=f_day+7*(sequence-1);}
      if(f_day>31)     {f_day=f_day-7;}
      break;
     }
   return(f_day);
  }
//+------------------------------------------------------------------+
